PROGRAM UnitScan;

{$M 25000,0,655000}

Uses PbMISC, PbDATA, PbOBJS, PbPARMS, PbOUT0,
     PbDBLIB, PbDBOBJ, xUnits, xProcs;

{
Description : Scans .PAS for Procs & Functions

Author      : Howard Richoux
Date        : 12/13/93
Last revised: 5/2/94 HNR 1.20 creates dbf files as needed
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}


type WorkProc_type = Procedure (var s : string);

type procrec = record
       proclead : string[9];   { FUNCTION/PROCEDURE }
       unitname : string[8];
       procname : string[24];
       procargs : string[254]; { ( var ... ) }
       proctype : string[24];  { : string }
       proccomm : string[254]; { comments }
       end;


var T   : TFILE_object;
var UN  : UNITS_DBF_object;
var PR  : PROCS_DBF_object;
var P   : procrec;
var QUITFlag : boolean;

var oktowrite  : boolean;
    skipmode   : boolean;
    state      : byte;
    UnitString : string;
    UsesString : string;

var procfname  : string;
    unitfname  : string;

{*****************************************************************}

Function FmtP(P : procrec) : string;
var s : string;
     begin
     s := P.procname;
     if P.procargs <> '' then s := s + '(' + P.procargs + ')';
     if P.proctype <> '' then s := s + ' : ' + P.proctype;
     s := s + ';';
     RemoveExcessBlanks(s);
     FmtP := leftstr(P.proclead,9) + ' ' + s;
     end;


Procedure AddProcRecord(P : procrec);
     begin
     fillchar(PR.rec,sizeof(PR.rec),0);
     PR.rec._UNITNAME  := P.unitname;
     PR.rec._PROCNAME  := P.procname;
     PR.rec._PROCLEAD  := P.proclead;
     PR.rec._FUNCTYPE  := P.proctype;
     PR.rec._STATEMENT := FmtP(p);
     PR.rec._CATEGORY  := GetDelimitedStr(P.proccomm,'[',']');
     PR.rec._COMMENT   := P.proccomm;
     PR.rec._LASTMOD   := '0000000000';
     PR.rec._AUTHOR    := 'hnr';
     PR.rec._PROCSTATUS := 'ok';
     PR.rec._CODESTATUS := 'ok';
     if oktowrite then
          begin
          PR.writerec(PR.numrecs+1);
        {  OUT('Wrote record '+P.procname); }
          end;
     end;


Procedure DoneWithProc(var P : procrec; var s : string);
var i : integer;
    tch : char;
    s1  : string;
     begin
     P.unitname := UnitString;

     OUT('['+leftstr(P.unitname,8)+'] '+FmtP(P));
     trim(s);
     i := pos('}',s);
     if (i > 0 ) and (s[1]='{') then
          begin
          delete(s,1,1);
          P.proccomm := GetLeftStr(s,'}');
          OUT('                  {'+P.proccomm+'}');
          trim(P.proccomm);
          end;
     AddProcRecord(P);
     fillchar(P,sizeof(p),0);
     state := 0;
     end;


Procedure FindProcs(var s : string; var done : boolean);
var s1 : string;
    ch, tch : char;
    i  : integer;
     begin
     trim(s);
     if leftstr(s,14) = 'IMPLEMENTATION' then
          begin
          done := true;
          s := '';
          writeln('*IMPLEMENTATION*');
          end
     else if (leftstr(s,3) = '{+}')  then
          begin
          delete(s,1,3);
          skipmode := false;
          if pDebug then
               begin
               OUT('{done skipping}');
               OUT(' ');
               end;
          end
     else if (leftstr(s,3) = '{-}') then
          begin
          delete(s,1,3);
          skipmode := true;
          if pDebug then
               begin
               OUT(' ');
               OUT('{skipping}');
               end;
          end
     else if leftstr(s,5) = 'USES ' then
          begin
          delete(s,1,5);
          UsesString := NibbleString(s,[';'],tch);
          OUT('USES '+ UsesString + ';');
          OUT(' ');
          end
     else if leftstr(s,5) = 'UNIT ' then
          begin
          delete(s,1,5);
          UnitString := NibbleString(s,[';'],tch);
          OUT('UNIT '+ UnitString + ';');
          OUT(' ');
          end
     else if not skipmode then
          begin
          if pDebug then OUT(integerstr(length(s),3)+'..'+leftstr(s,60));
          case state of
              0  : begin  {have nothing}
                   s1 := NibbleString(s,[' '],tch);
                   if (s1 = 'PROCEDURE') or
                      (s1 = 'Procedure') or
                      (s1 = 'procedure') or
                      (s1 = 'function') or
                      (s1 = 'Function') or
                      (s1 = 'FUNCTION') then
                         begin
                         state := 1;
                         P.proclead := trimstr(s1);
                         if pDebug then
                              OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                         end;
                    trim(s);
                    end;

              1  : begin  {have lead, look for name}
                   s1 := NibbleString(s,[';',':','('],tch);
                   P.procname := trimstr(s1);
                   if tch = ';' then
                        begin
                        if pDebug then
                           OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                        DoneWithProc(P,s);
                        end
                   else if tch = ':' then
                        begin { no args, look for F type }
                        state := 3;
                        i := pos(')',s);
                        if i > 0 then
                             begin
                             end;
                        if pDebug then
                            OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                        end
                   else if tch = '(' then
                        begin { args }
                        state := 2;
                        if pDebug then
                           OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                        end
                   end;

              2  : begin  {have open (, looking for )}
                   i := pos(')',s);
                   if i > 0 then
                        begin
                        P.procargs := trimstr(leftstr(s,i-1));
                        delete(s,1,i);
                        trim(s);
                        if s[1] = ':' then
                             begin
                             state := 3;
                             delete(s,1,1);
                             trim(s);
                             end
                        else begin
                             state := 4;
                             end;
                        if pDebug then
                             OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                        end;
                   end;

              3  : begin  {have :, looking for function type }
                   P.proctype := GetLeftStr(s,';');
                   DoneWithProc(P,s);
                   if pDebug then
                       OUT('[**'+integerstr(state,2)+'**] '+FmtP(P));
                   trim(s);
                   end;

              4  : begin  {need closing ; }
                   s1 := GetLeftStr(s,';');
                   DoneWithProc(P,s);
                   trim(s);
                   end;

              else begin { how did I get here? }
                   writeln('Huh!' );
                   writeln('[',s,']');
                   done := true;
                   s := '';
                   end;
              end;
          end
     else begin
          if length(s) > 1 then delete(s,1,1);
          end;
     end;



Procedure  ReadLogicalBigChunk(fname : string);
var s, ws : string;
    ok,done : boolean;
    badloop : longint;
     begin
     done := false;
     badloop := 0;
     s := ''; ws := ''; done := false; state := 0;
     fillchar(P,sizeof(p),0);
     T.init(fname,false);
     while T.fetchnext(s) and not done do
          begin
          if length(ws) + length(s) < 250 then
               begin
               ws := ws + ' ' + s;
               end
          else begin
               while length(ws) > 120 do FindProcs(ws,done);
               ws := ws + ' ' + s;
               end;
          inc(badloop);
          if badloop > 499999 then
               begin
               done := true;
               writeln('BAD LOOP EXIT');
               end;
          end;
     badloop := 0;
     done := false;
     while (length(ws) > 0) and not done  do
          begin
          inc(badloop);
          if badloop > 50 then
               begin
               done := true;
               end;
          FindProcs(ws,done);
          end;
     T.done;
     end;


Procedure GoOn;
     begin
     if QUITFlag then exit;
     OUT('File: '+pCurrFName);
     OUT(' ');
     ReadLogicalBigChunk(pCurrFName);
     end;


Procedure CreateUnitsFile;
var spec : string;
    err  : integer;
     begin
     spec := '[UNITNAME(C8),PATH(C30),PROCS(N3.0),FUNCTIONS(N3.0),OBJS(N3.0),'+
             'UNITSTATUS(C4),CREATEDATE(D8),UNITUSES(C100),LASTMOD(D8),NOTES(C200),'+
             'GLOBALS(C20)]';
     if DBFCreateFile('units.dbf',spec,err) then
          begin
          UN.init(procfname,UNITS_DBF_recsize,fREADWRITE,'','',0);
          if not UN.opened then
               writeln('Unable to open or create UNITS.DBF');
          end;
     end;


Procedure CreateProcsFile;
var spec : string;
    err  : integer;
     begin
     spec := '[UNITNAME(C8),PROCNAME(C20),PROCLEAD(C9),FUNCTYPE(C20),'+
             'CATEGORY(C16),STATEMENT(C150),COMMENT(C100),LASTMOD(D8),'+
             'AUTHOR(C8),PROCSTATUS(C4),CODESTATUS(C4)]';
     if DBFCreateFile('procs.dbf',spec,err) then
          begin
          PR.init(procfname,PROCS_DBF_recsize,fREADWRITE,'','',0);
          if not PR.opened then
               writeln('Unable to open or create PROCS.DBF');
          end;
     end;


Procedure OpendBaseFiles;
     begin
     procfname  := Addbackslash(pDataPath)+'procs.dbf';
     OUT('using dbf files ['+procfname+']');
     unitfname  := Addbackslash(pDataPath)+'units.dbf';
     OUT('using dbf files ['+unitfname+']');

     PR.init(procfname,PROCS_DBF_recsize,fREADWRITE,'','',0);
     if not PR.opened then CreateProcsFile;
     if oktowrite then OUT('opened '+procfname+'  '+integerstr(PR.err,4));

     UN.init(unitfname,UNITS_DBF_recsize,fREADWRITE,'','',0);
     if not UN.opened then CreateUnitsFile;
     if oktowrite then OUT('opened '+unitfname+'  '+integerstr(UN.err,4));
     end;


Procedure Init;
    begin
    QUITFlag := false;
   { CRT.checkBreak := true;}
    UsesString := '<usestring>';
    UnitString := '<unitstring>';
    skipmode   := false;

    AddParm(1,'DBFWRITE','NO');

    StandardOUTInit;

    oktowrite := CheckOK('DBFWRITE');

    pProgID := 'UnitScan 1.05';
    if not pDebug then OUTSetNoPause;

    OpendBaseFiles;
    if oktowrite then
         begin
         OUT('Updating database on: ['+pDataPath+']');
         if not PR.opened then QUITFlag := true;
         end;
    end;


(*  Main program *)
    BEGIN
    pProgID := 'UNITSCAN 1.20';
    Init;
    if paramcount > 0 then
         begin
         pCurrFName := paramstr(1);
         if fileexists(pCurrFName) then GoOn
         else writeln('Unable to find file [',pCurrFName,']');
         end;
    OUTdone;
    end.


