
PROGRAM PATCH;

{$M 20000,0,655000}

Uses DOS, PbMISC, PbDATA, PbOBJS, PbPARMS, PbOUT0;


{
Description : Text string find and replace

Author      : Howard Richoux
Date        : 12/9/93
Last revised: 12/31/93 hnr 1.02 cleanup
               2/18/94 hnr 1.04 new libraries
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

Config Parameters        Meaning                                Default
       FIND              string to find                         ''
       REPLACE           replace with                           ''
       BOTH              ignore CASE                            'YES'
       ALL               replace all occurances on each line    'YES'
       CMDFILE           file of replacement commands           ''

}

var fndstr   : string;
    repstr   : string;
    bothflag : boolean;
    allflag  : boolean;
    cmdfile  : string;
    fnd,rep  : STRA_object;

{*****************************************************************}


Procedure ProcessString(var s : string; var fnd,rep : STRA_object;
                        both,all : boolean);
var fs,rs : string;
    i     : integer;
     begin
     for i := 1 to fnd.count do
          begin
          fs := fnd.fetchN(i);
          rs := rep.fetchN(i);
          s  := FindAndReplaceStr(s,fs,rs,both,all);
          end;
     end;


Procedure ProcessFile(fn : string; var fnd,rep : STRA_object;
                        both,all : boolean);
var s,s0,s1,t1nm, t2nm, t3nm : string;
    T1,T2    : TFILE_object;
    n       : integer;
     begin
     OUT('File: '+fn);
     if fnd.count < 1 then
          begin
          OUT('  No changes requested.');
          exit;
          end;
     n := 0;
     t1nm := fn;
     T1.init(t1nm,false);
     t2nm := fn;
     ForceExt(t2nm,'NEW');
     EraseFile(t2nm);
     T2.init(t2nm,true);
     while T1.fetchnext(s) do
          begin
          s0 := s;
          inc(n);
          ProcessString(s,fnd,rep,both,all);
          T2.append(s);
          if s0 <> s then OUT(' ('+integerstr(n,4)+') '+s);
          end;
     T2.done;
     T1.done;
     OUT(' ');
     ForceRenameToBAK(t1nm);    { .pas -> .bak }
     RenameFile(t2nm,fn);       { .NEW -> .pas }
     end;


Procedure GoOn;      { Initialization is over, do some work.}
var i : integer;
     begin
     OUT('Changing File: ['+pCurrFName+']');
     for i := 1 to fnd.count do
          OUT('                    ['+fnd.fetchN(i)+']'+
                ' --> ['+rep.fetchN(i)+']');
     OUT(' ');
     ProcessFile(pCurrFName,fnd,rep,bothflag,allflag);
     end;


Procedure LoadCommands(cmdfile : string; var fnd,rep : STRA_object);
var t : TFILE_object;
    s,fs,rs : string;
     begin
     fs := '';
     rs := '';
     t.init(cmdfile,false);
     while t.fetchnext(s) do
          begin
          fs := GetLeftStr(s,'/');
        {  delete(fs,length(fs),1);}
          trim(fs);
          trim(s);
          rs := RemoveBrackets(s);
          fs := RemoveBrackets(fs);
          if fs <> '' then
               begin
               fnd.append(fs);
               rep.append(rs);
               end;
          fs := '';
          rs := '';
          end;
     t.done;
     end;


Procedure Init;
var s : string;
     begin
     fnd.init(100);   { strings to find }
     rep.init(100);   { replace them with }

     AddParm(1,'FIND','');
     AddParm(1,'REPLACE','');
     AddParm(1,'BOTH','YES');
     AddParm(1,'ALL','YES');
     AddParm(1,'CMDFILE','');

     StandardOUTInit;

     OUTSetNoPause;

     cmdfile    := GetParmStr('CMDFILE');
     if fileexists(cmdfile) then
          begin
          LoadCommands(cmdfile,fnd,rep);
          end
     else if cmdfile <> '' then
          begin
          writeln('Unable to file command file: [',cmdfile,']');
          end
     else begin
          fndstr     := RemoveBrackets(GetParmStr('FIND'));
          patchstr(fndstr,'^',' ');
          repstr     := RemoveBrackets(GetParmStr('REPLACE'));
          patchstr(repstr,'^',' ');
          if fndstr <> '' then
               begin
               fnd.append(fndstr);
               rep.append(repstr);
               end;
          end;

     bothflag   := CheckOK('BOTH');
     allflag    := CheckOK('ALL');

     if paramcount > 0 then pCurrFName := paramstr(1);
     end;


    BEGIN
    pProgID := 'PATCH 1.04';
    Init;

    if ParamCount > 0 then
         begin
         GoOn;
         end
    else ShowDocFile;
    OUTdone;
    end.


