(*PAGE*)
PROGRAM ENV;

{$M 15000,0,20000}

Uses DOS, CRT, PbCRT, PbMISC, PbDATA, PbOBJS, PbPARMS, PbOUT0,
          PbSELECT,PbLJII;

{
Description :  Prints envelopes on LJ4

Author      : Howard Richoux
Date        : 11/20/93
Last revised: 11/30/93  more config parameters
              1/3/94    1.02 converted to PbOUT0
              2/18/94   1.04 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 5.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none
}


var S            : string;
var fname        : string[40];
    SetupString  : string[40];
    Ret1, Ret2, Ret3, Ret4   : string[60];
    ReturnFlag   : boolean;
    ManualFlag   : boolean;
    AddressPAD   : integer;
    ReturnPAD    : integer;
    LinesBetween : integer;
    setup1, setup2, setup3 : string;
    printed      : integer;

var crtsave      : CRTSaveRec;

var addressdir,template   : string[40];

{*****************************************************************}



Procedure EnvelopeSetUp;
var i : integer;
    begin
    OUTNoCR(#27+'E');  {RESET}
    if not pDebug then         {for debug, just run regular paper}
         begin
         OUTNoCR(LJIICMD(3));  {Landscape Mode}
         if ManualFlag then OUTNoCR(LJIICMD(8));  {Manual Feed}
         end;

    OUTNoCR(#27+'(10U');  {PC-8}
    if setup1 <> '' then OUTNoCR(#27+setup1);

    if returnflag then
         begin
         OUTNoCR(#27+'&l6D');  {6 lpi}
         OUT(conststr(' ',returnpad)+Ret1);
         OUT(conststr(' ',returnpad)+Ret2);
         OUT(conststr(' ',returnpad)+Ret3);
         OUT(conststr(' ',returnpad)+Ret4);
         end;
    for i := 1 to linesbetween do OUT('');
    if setup3 <> '' then OUTNoCR(#27+setup3);
    OUTNoCR(#27+'&l4D');  {4 lpi}
    end;


Procedure ListFile(fname : string);
var line, CurrFName : string;
    done : boolean;
    tx   : TFILE_object;
    begin
    done := false;
    CurrFName := UpCaseStr(fname);
    tx.init(CurrFName,false);
    while tx.fetchnext(line) and not done do
        begin
        OUT(Conststr(' ',AddressPad)+line);
        if keypressed then done := true;
        end;
    tx.done;
    OUTNoCR(#27+'E');  {RESET}
    end;


Function LocateFile(var fn : string) : boolean;
var i :integer;
    found : boolean;
    begin
    found := true;
    if      FileExists(addressdir+fn + '.adr') then
         fn := addressdir+fn + '.adr'
    else if FileExists(addressdir+fn)          then
         begin end
    else found := false;
    if found then writeln('Locatefile ',addressdir+fn);
    LocateFile := found;
    end;


Procedure PrintAddress(fn : string);
var SR :searchrec;
    i  : integer;
    fname : string[80];
    begin
    fname := fn;
    i := Pos('.',fname);
    if LocateFile(fname) then
         begin
         EnvelopeSetUp;
         ListFile(fname);
         inc(printed);
         end
    else writeln('PrintAddress - File Not Found - [',fname,']');
    end;


(*PAGE*)

Procedure Getfiles( Template : string; var fl : STRA_object);
var SR : searchrec;
    ok : boolean;
     begin
     FindFirst(Template,0,SR);
     while DOSError = 0 do
          begin
          if length(sr.name) > 4 then
              begin
              ok := fl.append(sr.name);
              end;
          FindNext(SR);
          end;
     fl.sort;
     end;


Procedure DoView(dir,template : string);
var filename   : string[40];
    cmd        : string[40];
    itemselect : integer;
var files      : STRA_object;
     begin
     itemselect := 1;
  {   HelpMaxLines := 1000;   }
     filename   := '';
     cmd        := '?RESELECT';
     files.init(100);
     Getfiles(addressdir+Template, files);
     while itemselect > 0 do
          begin
          SetSelectwindow(2,2,18,3,15);
          SetSelectWindowLabels(' ENV - Envelope Printer ',' Select a File ');
          Select(files,filename,itemselect,cmd);
          if (filename <> '') then
              begin
              if printed > 0 then OUTDoneWithPage;
              EnvelopeSetUp;
              ListFile(addressdir+filename);
             {itemselect := 0;}
              end;
          end;
     files.done;
     end;



(*PAGE*)


Procedure DoStatus;
    begin
    ListParms(0);
    end;


Procedure Init;
    begin
    printed := 0;
    AddParm(1,'PATH','c:\address\');
    template := '*.adr';
    addparm(1,'ADDRESSPAD','60');
    addparm(1,'RETURNPAD','5');
    addparm(1,'BETWEEN','9');
    addparm(1,'SETUP1','');
    addparm(1,'SETUP2','');
    addparm(1,'SETUP3','');
    addparm(1,'RET1','');
    addparm(1,'RET2','');
    addparm(1,'RET3','');
    addparm(1,'RET4','');
    addparm(1,'MANUAL','YES');

    StandardOUTInit;
    OUTSetCompressed;
    OUTSetLandscape;
    OUTSetLengths(200,58);   { Manual override }

    addressdir   := GetParmStr('PATH');
    addresspad   := GetParmNum('ADDRESSPAD');
    returnpad    := GetParmNum('RETURNPAD');
    LinesBetween := GetParmNum('BETWEEN');

    setup1       := GetParmStr('SETUP1');
    setup2       := GetParmStr('SETUP2');
    setup3       := GetParmStr('SETUP3');

    Ret1         := GetParmStr('RET1');
    Ret2         := GetParmStr('RET2');
    Ret3         := GetParmStr('RET3');
    Ret4         := GetParmStr('RET4');
    ReturnFlag   := CheckOK('RETURN');
    ManualFlag   := CheckOK('MANUAL');

    if returnflag and (ret1 <> '') then dec(linesbetween);
    if returnflag and (ret2 <> '') then dec(linesbetween);
    if returnflag and (ret3 <> '') then dec(linesbetween);
    if returnflag and (ret4 <> '') then dec(linesbetween);
    end;


(*  Main program *)
    BEGIN
    pProgID := 'ENV 1.04';
    writeln(pProgID,' - Utility to address envelopes - 11/93 ');
    SaveCRT(CRTSave);
    Init;

    fname := 'x';
    if ParamCount > 0 then
         begin
         fname := UpCaseStr(paramstr(1));
         if      fname = 'HELP'   then ShowDocFile
         else if fname = 'STATUS' then DoStatus
         else
              begin
              PrintAddress(fname);
              end;
         end
    else
         begin
         if template <> '' then DoView(addressdir,template)
         else writeln('template = ',template,'   dir = ',addressdir);
         end;
    writeln('');
    RestoreCRT(CRTSave);
  {  OUTdone;  }
    end.


