(*PAGE*)
PROGRAM DDIR;

{$M 20000,0,655000}

Uses DOS, PbMISC, PbDATA, PbOBJS, PbPARMS, PbOUT0;

{
Description : DDIR - simple DDIR

Author      : Howard Richoux
Date        : 12/27/93
Last revised: 2/18/94 New libraries
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

}
var files    : STRA_object;

var filespec : string;
    err      : byte;
    root     : string;
    totals   : searchrec;
    totfiles : integer;

{ SearchRec - for reference
    type searchrec = record
           fill  : array[1..21] of byte;
           attr  : byte;
           time  : longint;
           size  : longint;
           name  : string[12];
           end;
}



{*****************************************************************}

Procedure DealWithIt( var sr : SearchRec; p : pathstr);
var s : string;
     begin
     inc(totfiles);
     totals.size := totals.size + SR.size;
     if SR.time > totals.time then totals.time := SR.time;
     s := FmtSearchRec(SR);
     files.append(s);
     end;


Procedure DoubleDisplay;
var i,j,k,half : integer;
    s     : string;
     begin
     half := files.count div 2;
     if ((half) * 2) <> files.count then files.append(' ');
     half := files.count div 2;
     OUT('Directory: '+root);
     for i := 1 to half do
          begin
          s := files.fetchN(i) + ' | ' + files.fetchN(i+half);
          OUT(s);
          end;
     totals.name := 'TOT('+integerstr(totfiles,3)+')';
     s := FmtSearchRecK(totals);
     OUT(' '+s);
     end;



Procedure TripleDisplay;
var i,j,k,third : integer;
    s     : string;
     begin
     third := files.count div 3;
     if ((third) * 3) <> files.count then files.append(' ');
     if ((third) * 3) <> files.count then files.append(' ');
     third := files.count div 3;
     OUT('Directory: '+root);
     for i := 1 to third do
          begin
          s := files.fetchN(i) + ' | ' + files.fetchN(i+third) + ' | ' +
               files.fetchN(i+third+third);
          OUT(s);
          end;
     totals.name := 'TOT('+integerstr(totfiles,3)+')';
     s := FmtSearchRecK(totals);
     OUT(' '+s);
     end;


Procedure DoIt;
     begin
     SearchEngine(root+filespec,anyfile,DealWithIt,Err);
     files.sort;
     if OUTCompressed then TripleDisplay
     else DoubleDisplay;
     end;


Procedure Init;
var i : integer;
     begin
     fillchar(totals,sizeof(totals),0);
     totals.name := 'TOTAL';
     totfiles := 0;
     filespec := '*.*';
     files.init(500);
     if paramcount > 0 then
          begin
          if UpCaseStr(paramstr(1)) = 'P' then GetDir(0,root)
          else root := paramstr(1);
          end
     else begin
          GetDir(0,root);
          end;
     root := UpCaseStr(root);
     i := pos('.',root);
     if i = 0 then root := addbackslash(root);
     StandardOUTInit;
     end;


(*  Main program *)
     BEGIN
     pProgID := 'DDIR 1.00';
     init;
     DoIt;
     OUTdone;
     end.


