PROGRAM DB; {DBase Utility  ZAP/CLONE/SORT/CREATE/EXPORT/IMPORT }

{$M 30000,0,655000}

Uses DOS, CRT, PbCRT, PbMISC, PbDATA, PbOBJS, PbHIGH, PbPARMS, PbOUT1,
          PbDBOBJ, PbDBLIB;

{
Description : Combo DB Utility to save code space


Author      : Howard Richoux
Date        : 1/4/94
Last revised: 1/4/94  1.00 Initial from DBSORT/DBZAP
              1/4/94  1.02 Added DUMP/DDL/EXPORT/CREATE/CLONE
              1/18/94 1.10 added KEYVALUE for DUMP
              2/1/94  1.12 added DB DDL *
              5/2/94  1.14 CREATE works, define SPEC= in parms
Application : IBM PC and compatibles, done in Turbo Pascal 5.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none
}



var   DBshowDDLflag  : boolean;    { a validation tool, shows rec struct }
      DBDoItFlag     : boolean;    { OK to do the operation    }
      DBProg         : string[20]; { Functional division of DB }


{ Global variables needed PRIMARILY for specific functions, can be used
    by other functions - Named for their primary user. }

var DUMPTrimFlag    : boolean;     { if true, packs down fields, not as pretty,
                                       but fits more per line }
var DUMPRecNumFlag  : boolean;     { Do/Don't list record # }

var DUMPBetween     : string[5];   { what goes between fields on a DUMP }



Function VerifyStr(var fn : string; msg : string) : boolean;
var recs,fields,recsize : integer;
    eof                 : longint;
     begin
     ForceExt(fn,'dbf');
     DBFGetClosedFileInfo(fn,recs,fields,recsize,eof);
     writeln('File: [ ',fn,' ] has ',recs,' records.');
     if CheckYesNo(msg,'Y') then
          VerifyStr := true
     else VerifyStr := false;
     end;


Function DecodeFNAME( p : integer; ext : string; var doit : boolean) : string;
var fn : string;
    i  : integer;
     begin
     doit := false;  fn := '';
     if paramcount >= p then
           begin
           fn := paramstr(p);
           i := pos('!',fn);
           if i <> 0 then
                begin
                delete(fn,i,1);
                doit := true;
                end;
           SuggestExt(fn,ext);
           end
     else writeln('File name not specified on param line.');
     DecodeFNAME := UpCaseStr(fn);
     end;


{PAGE}
Procedure DDLPrintHeader(var Y : DBF_object);
var i,j : integer;
    nam      : string;
    fldtyp   : char;
    ln,decp  : integer;
    s        : string;
    ch       : char;
    begin
    OUT(Y.filename+'   recsize='+integerstr(Y.recsize,4)+
            ' bytes    records='+integerstr(Y.numrecs,4));
    OUTSetIndent(15);
    s := 'Fld#'+'  '+'Name         Type  Len  Decp';
    OUT(s);
    for i := 1 to Y.dbf.no_col do
        begin
        DBFDecodeFieldDef(Y.exportfielddefn(i),nam,fldtyp,ln,decp);
        s := integerstr(i,4)+'  '+leftstr(nam,13)+'  '+fldtyp+'  '+
             integerstr(ln,4);
        if decp > 0 then s := s + '   ' + integerstr(decp,2);
        OUT(s);
        end;
    OUT('      end');
    OUTSetIndent(0);
    end;


Procedure DoOneDDL;
var Y   : DBF_object;
    begin
    Y.init(pCurrFName,0,fREADWRITE);
    if (Y.err = 0) then
         begin
         OUT(' ');
         DDLPrintHeader(Y);
         end
    else writeln('Unable to open database [',pCurrFName,']');
    Y.done;
    end;


Procedure GoOnDDL;
var s : string;
    i,j : integer;
    files : STRA_object;
    begin
    OUT(pProgID+' DDL - Data Dictionary Listing ');
    OUT(' ');
    s := pCurrFName;
    suggestext(s,'dbf');
    i := pos('*',s);
    j := pos('?',s);
    if (i > 0) or (j > 0) then
         begin
         files.init(20);
         GetFilesSTRA(s,files,fSortByName);
         for i := 1 to files.count do
              begin
              pCurrFName := files.fetchN(i);
              suggestext(pCurrFName,'dbf');
              DoOneDDL;
              OUT(' ');
              OUT(' ');
             { OUTDoneWithPage;}
              end;
         end
    else begin
         DoOneDDL;
         end;
    end;

{PAGE}
Procedure DUMPPrintHeader(var X : KEYED_DBF_object; trimflag : boolean;
                          var flist : HOLD_object);
var j,fld,len : integer;
    s,s1,nam    : string;
     begin
     OUT(' ');
     OUT(pProgID+'   file= '+X.filename+'    recsize='+integerstr(X.recsize,4)+
                          '   total recs='+integerstr(X.numrecs,5));
     OUT(' ');
     s := DBFFmtDumpRecNum(0,1,trimflag,DUMPRecNumFlag,DUMPBetween);
     j := 1;
     while (j <= flist.count) and (j <= X.dbf.dbnumfields) do
          begin
          nam := flist.fetchstrN(j);
          fld := DBFDecodeFldName(x,nam);
          if fld > 0 then
               begin
               len := flist.fetchnumN(j);
               if len > 0 then
                    s1 := leftstr(X.dbf.dbfldname(fld),len)
               else s1 := leftstr(X.dbf.dbfldname(fld),X.dbf.dbfldwidth(fld));
              { s1 := '('+integerstr(fld,2)+')';} {debugging}
               end
          else s1 := '?';
          if trimflag then trim(s1);
          s := s + s1 + DUMPBetween;
          inc(j);
          end;
     if j > 1 then delete(s,(length(s)-length(DUMPBetween))+1,length(DUMPBetween));
     OUT(s);

     s := DBFFmtDumpRecNum(0,2,trimflag,DUMPRecNumFlag,DUMPBetween);
     j := 1;
     while (j <= flist.count) and (j <= X.dbf.dbnumfields) do
          begin
          nam := flist.fetchstrN(j);
          fld := DBFDecodeFldName(x,nam);
          if fld > 0 then
               begin
               len := flist.fetchnumN(j);
               s1 := conststr('-',40);
               if len > 0 then
                    s1 := leftstr(s1,len)
               else s1 := leftstr(s1,X.dbf.dbfldwidth(fld));
               end
          else s1 := '';
          if trimflag then trim(s1);
          s := s + s1 + DUMPBetween;
          inc(j);
          end;
     if j > 1 then delete(s,(length(s)-length(DUMPBetween))+1,length(DUMPBetween));
     OUT(s);
     end;


Procedure DUMPPrintRecs(var X : KEYED_DBF_object; trimflag : boolean;
                        var flist : HOLD_object; first,last : integer);
var i,j,k,fld,len  : integer;
    s,s1,kval : string;
    ok        : boolean;
    kflds        : HOLD_object;
    begin
    if DBFKeyValue <> '*' then
         begin
         kflds.init(10);
         FStringToFList(DBFKeySpec,X,kflds)
         end;
    s := '';
    i := first;
    if i < 1 then i := 1;
    while (i <= last) and (i <= X.numrecs) do
         begin
         ok := X.fetchn(i);
         if not ok then writeln('fetchn error ',X.err);
         if DBFKeyValue <> '*' then
              begin
              kval := FListDataStr(kflds,X);
              ok   := Compare(kval,DBFKeyValue);
              end;
         if ok then
              begin
              s := DBFFmtDumpRec(x,flist,trimflag,DUMPRecNumFlag,DUMPBetween);
              OUT(s);
              end;
         inc(i);
         end;
    OUT(' ');
    end;


Procedure GoOnDUMP;
var X  : KEYED_DBF_object;
    begin
    if not FileExists(pCurrFName) then
         begin
         writeln('file does not exist. [',pCurrFName,']');
         exit;
         end;
    X.init(pCurrFName,0,fREADONLY,DBFKeytag,DBFKeySpec,DBFKeyMax);
    if X.err = 0 then
         begin
         if DBFKeyValue <> '*' then
              begin
              DBFKeySpec := UpCaseStr(DBFKeySpec);
              if (DBFKeySpec = '') then
                   begin
                   OUT('ERROR - You must specify a KEYSPEC=[...] '+
                       'param to use KEYVALUE='+DBFKeyValue);
                   exit;
                   end;
              DBFKeyValue := UpCaseStr(DBFKeyValue);
              OUT('Printing where ['+DBFKeySpec+'] ='+DBFKeyValue);
              end;
         DBFDecodeFString(DBFFstring,X,DBFFlist);
         DUMPPrintHeader(X,DUMPTrimFlag,DBFFlist);
         DUMPPrintRecs(X,DUMPTrimFlag,DBFFlist,pfirst,pLast);
         end
    else writeln('Unable to open database [',pCurrFName,']');
    X.done;
    end;


{PAGE}
Procedure EXPORTPrintHeader(var X : KEYED_DBF_object;var flist : HOLD_object);
var s,s1 : string;
     begin
     s  := DBFExportHeaderStr(X,flist);
     s1 := BreakLineChr(s,77,',');
     OUT(s1);
     While length(s) > 0 do
          begin
          s1 := BreakLineChr(s,77,',');
          OUT(' '+s1);
          end;
     end;


Procedure EXPORTPrintRec(n : integer;var X : DBF_object;
                                     var flist : HOLD_object);
var s,s1 : string;
var ok   : boolean;
     begin
     ok := X.fetchn(n);
     if not ok then OUT('fetchn error '+integerstr(X.err,4)+' ['+
                            integerstr(n,4)+']')
     else begin
          s  := DBFFmtDumpRec(X,flist,true,false,',');
          s1 := BreakLineChr(s,77,',');
          if length(s) > 0 then OUT('['+s1)
          else                  OUT('['+s1+']');
          While length(s) > 0 do
               begin
               s1 := BreakLineChr(s,77,',');
               if length(s) > 0 then OUT(' '+s1)
               else                  OUT(' '+s1+']');
               end;
          end;
     end;


Procedure EXPORTPrintRecs(var X : KEYED_DBF_object;var flist : HOLD_object;
                          first,last : integer);
var i,j,k,fld,len  : integer;
    s,s1 : string;
    ok : boolean;
    begin
    s := '';
    i := first;
    if i < 1 then i := 1;
    while (i <= last) and (i <= X.numrecs) do
         begin
         EXPORTPrintRec(i,X,flist);
         inc(i);
         end;
    OUT(' ');
    end;


Procedure GoOnEXPORT;
var X  : KEYED_DBF_object;
    begin
    X.init(pCurrFName,0,fREADONLY,DBFKeytag,DBFKeySpec,DBFKeyMax);
    if X.err = 0 then
         begin
         DBFDecodeFString(DBFFstring,X,DBFFlist);
         EXPORTPrintHeader(X,DBFFlist);
         EXPORTPrintRecs(X,DBFFlist,pfirst,pLast);
         end
    else writeln('Unable to open database [',pCurrFName,']');
    X.done;
    end;


{PAGE}
Procedure GoOnCREATE;
var err : integer;
     begin
     if pDebug then writeln('GoOnCREATE [',pCurrFName,']');
     if pCurrFName = '' then exit;
     pCurrFName := DecodeFNAME( 2,'dbf',DBDoItFlag);
     if FileExists(pCurrFName) then
          begin
          writeln('File Already exists. [',pCurrFName,']');
          exit;
          end;
     if pDebug then writeln('DBFFstring {',DBFFstring,'}');
     if DBFCreateFile(pCurrFName, DBFFstring, err) then
          begin
          DBFShowStructure(pCurrFName);
          end
     else writeln('DBFCreateFile failed. [',pCurrFName,']');
     end;


Procedure GoOnCLONE;
var fn2 : string;
     begin
     if pDebug then writeln('GoOnCLONE [',pCurrFName,']');
     if pCurrFName = '' then exit;
     if not FileExists(pCurrFName) then
          begin
          writeln('Unable to find file to be CLONEd: [',pCurrFName,']');
          exit;
          end;
     fn2 := DecodeFNAME( 3,'dbf',DBDoItFlag);
     if DBFCLONEFile(pCurrFName, fn2) then
          begin
          DBFShowStructure(fn2);
          end
     else writeln('DBFCloneFile failed. [',pCurrFName,']');
     end;



Procedure GoOnZAP;
var recs,fields,recsize : integer;
    eof                 : longint;
     begin  { already have DOIT! }
     if pDebug then writeln('GoOnZAP [',pCurrFName,']');
     if pCurrFName = '' then exit;
     if not FileExists(pCurrFName) then
          begin
          writeln('Unable to find file to be ZAPped: [',pCurrFName,']');
          exit;
          end;
     if DBFZapFile(pCurrFName) then
          begin
          DBFGetClosedFileInfo(pCurrFName,recs,fields,recsize,eof);
          if recs = 0 then
               begin
               writeln('DBFZapFile OK. [',pCurrFName,']');
               writeln('');
               end
          else begin
               writeln('DBFZapFile reported OK. [',pCurrFName,']');
               writeln('SOMETHING WRONG, ',pCurrFName,' shows ',recs,' records.');
               writeln('');
               end;
          if DBshowDDLflag then DBFShowStructure(pCurrFName);
          end
     else writeln('DBFZapFile failed. [',pCurrFName,']');
     end;

{PAGE}


Procedure GoOnSORT;
     begin
     if pDebug then writeln('GoOnSORT [',pCurrFName,']');
     if pCurrFName = '' then exit;
     if not FileExists(pCurrFName) then
          begin
          writeln('Unable to find file to be sorted: [',pCurrFName,']');
          exit;
          end;
     if DBFSORTFile(pCurrFName,DBFKeyTag,DBFKeySpec) then
          begin
          writeln('DBFSORTFile OK. [',pCurrFName,']');
          writeln('');
          if DBshowDDLflag then DBFShowStructure(pCurrFName);
          end
     else writeln('DBFSORTFile failed. [',pCurrFName,']');
     end;


Procedure GoOnSELFTEST;
var err : integer;
    dbf : KEYED_DBF_object;
    dbf2 : DBF_object;
     begin
     if pDebug then writeln('GoOnSELFTEST [',pCurrFName,']');
     pCurrFName := 'junkfile.dbf';
     DBFFstring := '[field1(c20),field2(n10.2)]';
     if FileExists(pCurrFName) then EraseFile(pCurrFName);
     if DBFCreateFile(pCurrFName, DBFFstring, err) then
          begin
          DBFShowStructure(pCurrFName);
          end
     else writeln('DBFCreateFile failed. [',pCurrFName,']');
     dbf2.init(pCurrFName,0,fREADWRITE);
     if dbf2.NoError then
          begin
          dbf2.dbf.dbputstr (1,'abcdefg'); dbf2.dbf.dbputreal(2,123.45);
          dbf2.append;
          dbf2.dbf.dbputstr (1,'ABCDEFGH'); dbf2.dbf.dbputreal(2,987.65);
          dbf2.append;
          dbf2.dbf.dbputstr (1,'1234abcd'); dbf2.dbf.dbputreal(2,1.23);
          dbf2.append;
          end;
     if dbf2.NoError then
          begin
          DBFDecodeFString('[*]',dbf2,DBFFlist);
          end;
     dbf2.done;
     dbf.init(pCurrFName,0,fREADWRITE,'','',100);
     if dbf.err = 0 then
          begin
          DBFDecodeFString(DBFFstring,dbf,DBFFlist);
          DUMPPrintHeader(dbf,DUMPTrimFlag,DBFFlist);
          DUMPPrintRecs(dbf,DUMPTrimFlag,DBFFlist,pfirst,pLast);
          end
     else writeln('Unable to open database [',pCurrFName,']');
     dbf.done;
     end;


{PAGE}

Procedure GoOn;
     begin
     pCurrFName := DecodeFNAME( 2,'dbf',DBDoItFlag);
     if      DBProg = 'SORT' then
          begin
          writeln('File will be sorted using KEYSPEC= [',DBFKeySpec,']');
          if not DBDoItFlag then DBDoItFlag :=
              VerifyStr(pCurrFName,'Do you wish to SORT these records? ');
          if DBDoItFlag then GoOnSORT;
          end
     else if DBProg = 'ZAP' then
          begin
          if not DBDoItFlag then DBDoItFlag :=
              VerifyStr(pCurrFName,'Do you wish to DELETE ALL records? ');
          if DBDoItFlag then GoOnZAP;
          end
     else if DBProg = 'CREATE' then
          begin
          GoOnCREATE;
          end
     else if DBProg = 'DDL' then
          begin
          GoOnDDL;
          end
     else if DBProg = 'DUMP' then
          begin
          GoOnDUMP;
          end
     else if DBProg = 'EXPORT' then
          begin
          GoOnEXPORT;
          end
     else if DBProg = 'CLONE' then
          begin
          GoOnCLONE;
          end
     else if DBProg = 'SELFTEST' then
          begin
          GoOnSELFTEST;
          end
     else begin
          writeln('Unrecognized Function [',DBProg,']  Type DB(cr) for help');
          end
     end;



Procedure Init;
var i : integer;
    s : string;
     begin
     DBProg := '';
     DBFFlist.init(127);  {allow for up to 127 fields }
     DBFKeyTag := '';
     DBFKeySpec := '';
     DBDoItFlag := false;

     AddParm(1,'SHOWSTRUCT','NO');
     AddParm(1,'RECNUM','YES');
     AddParm(1,'COMPRESSED','YES');
     AddParm(1,'TRIM','NO');
     AddParm(1,'SPEC','[*]');  {FIELDS}
     AddParm(1,'BETWEEN','[ | ]');

     DBFAddParms;
     StandardOUTInit;
     DBFGetParms;
     PARMSetFirstLast;

     s              := GetParmStr('BETWEEN');
     DBFFstring     := GetParmStr('SPEC');
     DUMPBetween    := ExtractDelimitedStr(s,'[',']');
     DUMPTrimFlag   := CheckOK('TRIM');
     DUMPRecNumFlag := CheckOK('RECNUM');
     DBshowDDLflag  := checkok('SHOWSTRUCT');

     if paramcount > 0 then
           begin
           DBProg := UpCaseStr(paramstr(1));
           end;

     if pDEBUG then OUT('Using field list = '+DBFFstring);
     end;


(*  Main program *)
     BEGIN
     pProgID := 'DB 1.14';
     writeln('xBase - DBF - DDL/SORT/ZAP/CLONE/EXPORT/IMPORT/CREATE   12/93');
     Init;
     if paramcount > 1 then GoOn     {minimum DB <FUNCTION> <file> }
     else ShowDocFile;
     OUTDone;
     end.


