{SECTION ..PbPARMS }
UNIT PbPARMS;

INTERFACE

Uses  Dos, PbMISC, PbDATA, PbOBJS;


{
Description:  Support for configuration files and param line handling

Author      : Howard Richoux
Date        : 1/26/91    major rewrite
Last revised: 11/20/93   re-added multilevel CFG files
                         standard variables
                         DOC file support
               12/7/93   add optional extra cfg file
               12/21/93  add ScanParms
               1/3/94    cleanup
               1/29/94   StandardpVarsInit writes Placed in the Public Domain by message
               2/13/94   Added c:\HNR.CFG as Global Default
               2/17/94   cut over to PbMISC/PbDATA/PbOBJS
Application : IBM PC and compatibles, Turbo Pascal 5.0
Status      : Placed in the Public Domain by HNR Software 1/94
Published in: none

  Total rewrite of PbPARMS unit using the INFO_object.

  Routines to support the use of config files and param lines by programs
   HNR 12/13/88
    Config files contain entries such as:
      OUTPUT=CON
      DISPLAY=YES
    They are loaded in from one or more files into an array and accessed
     by name at any time.  Either the actual value can be retrieved
    or a numeric or boolean interpretation.

     <pid>   --> parameter identifier, an 8 character string
     <pval>  --> string value of parameter (24 chars), unit also
                  keeps a boolean interpretation, and can be accessed
                  as a numeric value

StandardpVarsInit - sets a group of standard variables, free decoding:
    Internal   External(CFG)    Possible Use                   Default
    --------   --------         ---------------------------    -------
    pFirst     FIRST=<nnn>      First record number to keep    0
    pLast      LAST=<nnn>       Last record number to keep     32700
    pCount     COUNT=<nnn>      Number of records to keep      32700
    pRecs      RECS=<nnn>       Number of records to keep      32700
    pSkip      SKIP=<nnn>       Number of records to skip      0
    pSize      SIZE=<nnn>       Record size                    16
    pDelay     DELAY=<nnn>      millisecond delay              100

    pDataPath  DATAPATH=xx..x   Data directory                 ''
    pOutFile                    CON LPT1, ...                  'CON'

    pDebug     DEBUG=ON         Turn On/Off debugging          false

    pExtraCFG  EXTRA=fspec      secondary CFG file             ''
    pSystemID  SYSTEM=xxx       TAG to identify system         ''
    pPrinterID PRINTER=xxxx     TAG to identify printer type   'LJ4'

    pProgID                     ID & version # of program      '<progid>'
    pCurrFName                  file being operated on         ''
}


{SECTION .PARM_object }
{-}
type  PARM_object = object(INFO_object)
          CONSTRUCTOR init(max : integer);
          Procedure merge (fname : string);
          Procedure DecodePARMString(s : string);
          Procedure ParamLineOverride;
          end;

var parms : PARM_object;   { mostly private }
{+}

{SECTION .PROCEDURES }


Procedure PARMSetFirstLast;
             {[PARMS] resolve conflicts between first last and count}

Procedure StandardpVarsInit;
             {[PARMS] * Primary Call * (unless using StandardOUTInit)}

Procedure ShowDOCfile;
             {[PARMS] Display Instructions from the *.DOC file}

Function  GetParmStr(pid : string) : string;
             {[PARMS] Check a PARM - returns param string value}

Function  GetParmNum(pid : string) : word;
             {[PARMS] Check a PARM - returns numeric value}

Function  CheckOK(pid : string) : boolean;
             {[PARMS] Check a PARM - returns boolean value}

Procedure SetParmFileDefault;
             {[PARMS] sets file as .CFG from .EXE - goes through sequence}

Procedure ParamLineOverride;
             {[PARMS] takes params of param line - mostly internal}

Procedure AddParm(pfnum : byte; pid,pval : string);
             {[PARMS] Add your own PARM w/default, or set default on standard PARM }

Procedure ListParms(pfnum : byte);
             {[PARMS] for debugging }

Function  ScanParms(str : string) : boolean;
             {[PARMS] - searches parm line for "STR" }


{SECTION .zImplementation }
IMPLEMENTATION

Procedure InitIt; forward;

{SECTION  AddParm }
Procedure AddParm(pfnum : byte; pid,pval : string); { for Init procs }
var ok : boolean;
     begin
     if not parmsinitted then InitIt;
     ok := parms.store(pid,pval);
     end;


{SECTION  CheckOK }
Function  CheckOK(pid : string) : boolean;    {returns boolean value}
     begin
     CheckOK :=  parms.fetchboolean(pid);
     end;


{SECTION  GetParmNum }
Function  GetParmNum(pid : string) : word;    {returns numeric value}
     begin
     GetParmNum := parms.fetchinteger(pid);
     end;


{SECTION  GetParmStr }
Function  GetParmStr(pid : string) : string;  {returns param string value}
     begin
     GetParmStr :=  parms.fetchstring(pid);
     end;


{SECTION  InitIt }
Procedure InitIt;
     begin
     parms.init(100);
     parmsinitted := true;
     end;


{SECTION  InitpVars }
Procedure InitpVars;
     begin
     AddParm(1,'COUNT','32700');
     AddParm(1,'DATAPATH','');
     AddParm(1,'DEBUG','NO');
     AddParm(1,'DELAY','100');
     AddParm(1,'EXTRA','');
     AddParm(1,'FIRST','0');
     AddParm(1,'LAST','32700');
     AddParm(1,'OUT','CON');
     AddParm(1,'RECS','32700');
     AddParm(1,'SIZE','16');
     AddParm(1,'SKIP','0');
     AddParm(1,'SYSTEM','');
     AddParm(1,'PRINTER','LJ4');
     end;


{SECTION  ListParms }
Procedure ListParms(pfnum : byte);
     begin
     parms.dump;
     end;


{SECTION  ParamLineOverride }
Procedure ParamLineOverride;                  {takes params of param line}
     begin
     parms.paramlineoverride;
     end;


{SECTION  PARMSetFirstLast }
Procedure PARMSetFirstLast;
     begin
     if pFirst < 1 then pFirst := 1;
     if      (pCount <> 32700) and (pLast = 32700) then
          pLast := pFirst + pCount - 1
     else if (pCount = 32700) and (pLast <> 32700) then
          pCount := pLast - pFirst + 1
     else if (pCount <> 32700) and (pLast <> 32700) then
          pLast := pFirst + pCount - 1;
     end;


{SECTION PARM_object }
CONSTRUCTOR PARM_object.init(max : integer);
var l : longint;
    i : integer;
     begin
     sepchar := '=';  { separator between key and data }
     infoheader.init;
     keystring.init(max);
     keyvalue.init(max);
     end;


Procedure PARM_object.DecodePARMString(s : string);
var pid,pval : string;
    OK : boolean;
     begin
     pval := s;
     RemoveDelimitedString(pval,'{','}');  {throw away comments}
     pid := UpCaseStr(GetLeftStr(pval,sepchar));
     trim(pval);
     if pid <> '' then ok := INFO_object.store(pid,pval);
     end;


Procedure PARM_object.merge(fname : string);
var fn : string[60];
    s  : string;
    OK : boolean;
    TEXTF : text;
     begin
     fn := fname;
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'.CFG');
          end;
     assign(TEXTF, fn);
     {$I-} reset(TEXTF);  {$I+}
     OK := (IORESULT = 0);
     if not ok then exit;
     while ok and (not EOF(TEXTF)) do
         begin
         readln(TEXTF, s);
         if (INFO_object.count = 0) and (s[1] = '*') then
              begin
              delete(s,1,1);
              ok := infoheader.store(s);
              end
         else if (s <> '') and (s[1] <> '*') then
              begin
              DecodePARMString(s);
              end;
         end;
     {$I-} Close(TEXTF); {$I+}
     end;



Procedure PARM_object.ParamLineOverride;
var i,j : integer;
    s : string;
    begin
    if paramcount > 0 then
        begin
        for j := 1 to paramcount do
            begin
            s := paramstr(j);
            if (s[1] = '/') or (s[1] = '-') then
                 begin
                 delete(s,1,1);
                 DecodePARMString(s);
                 end
            else begin
                 i := pos(sepchar,s);
                 if i > 0 then PARM_object.DecodePARMString(s);
                 end;
            end;
        end;
    end;



{SECTION ScanParms }
Function ScanParms(str : string) : boolean;
     {[PARMS] - searches parm line for "STR"}
var s1 : string;
    i  : integer;
     begin
     ScanParms := false;
     s1 := UpCaseStr(str);
     i := 1;
     while i <= paramcount do
          begin
          if UpCaseStr(paramstr(i)) = s1 then ScanParms := true;
          inc(i);
          end;
     end;



{SECTION  SetParmFileDefault }
Procedure SetParmFileDefault;                 {sets file as .CFG from .EXE}
var s,dir,nam,ext : string;
     begin
     if not parmsinitted then InitIt;

     s := 'C:\HNR.CFG';      {System Level Global CFG file}
     forceext(s,'cfg');
     parms.merge(s);

     s := paramstr(0);       {The CFG file with the EXE}
     forceext(s,'cfg');
     parms.merge(s);

     FSplit(s,dir,nam,ext);  {The CFG file in the current directory}
     s := nam;
     forceext(s,'cfg');
     parms.merge(s);

     pExtraCFG := GetParmStr('EXTRA');
     if (pExtraCFG <> '') and FileExists(pExtraCFG) then
          begin
          writeln('Loading extra CFG file [',pExtraCFG,']');
          parms.merge(pExtraCFG);
          end
     else if pExtraCFG <> '' then
          writeln('NOT FOUND Extra CFG file [',pExtraCFG,']');
     end;


{SECTION  ShowDOCFile }
Procedure ShowDOCFile;   {Display Instructions}
var fn,s  : string;
    OK    : boolean;
    TEXTF : text;
     begin
     fn := paramstr(0);   {The DOC file with the EXE}
     forceext(fn,'doc');
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'.CFG');
          end;
     assign(TEXTF, fn);
     {$I-} reset(TEXTF);  {$I+}
     OK := (IORESULT = 0);
     if not ok then exit;
     while ok and (not EOF(TEXTF)) do
         begin
         readln(TEXTF, s);
         if s[1] = '?'then OK := false else writeln(s);
         end;
     {$I-} Close(TEXTF); {$I+}
     end;


{SECTION  StandardpVarsInit }
Procedure StandardpVarsInit;
     begin

     SetParmFileDefault;
     ParamLineOverride;


     pCount    := trunc(GetParmNum('COUNT'));
     pDataPath := GetParmStr('DATAPATH');
     pDebug    := CheckOK('DEBUG');
     pFirst    := trunc(GetParmNum('FIRST'));
     pLast     := trunc(GetParmNum('LAST'));
     pSize     := trunc(GetParmNum('SIZE'));
     pSkip     := trunc(GetParmNum('SKIP'));
     pRecs     := trunc(GetParmNum('RECS'));
     pDelay    := trunc(GetParmNum('DELAY'));

     pOutFile  := UpCaseStr(GetParmStr('OUT'));
     pSystemID := UpCaseStr(GetParmStr('SYSTEM'));
     pPrinterID := UpCaseStr(GetParmStr('PRINTER'));   { LJ4, NONE, SIMPLE }

     PARMSetFirstLast;
     writeln(pProgID,'  Placed in the Public Domain by HNR Software 2/12/94.');
     writeln('');
     end;


{SECTION  zzInitialization }
     begin {initialization }
     InitpVars;
     END.



