{SECTION ..PbHELP }
UNIT PbHELP;

INTERFACE

uses CRT, PbCRT, PbWIND, PbMISC, PbDATA, PbOBJS, PbSELECT;

{
Description:  Simple windowed help

Author      : Howard Richoux
Date        : 12/30/90
Last revised: 1/1/94  hnr   Not so simple HELP - section support
              2/18/94 HNR   NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 5.x
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none

    A HELP file is simply a text file which has been divided into
named sections with something like '?section one'.

    The two DISPLAYHELP procedures load the named section into a string
array, use a few keys to page around in it, and dispose of the section on exit.

    the DOHELP procedures provide the window for the display routines.

Notes - 1/2/94 - section seek seems to work OK, but I am suspicious of
   the currentposition reported out of TFILE_object. Check further.
}

var HelpMaxLines : integer;

{-}
{SECTION .HELP_object }
type HELP_object = object(STRA_object)
     Procedure loadsectionseek(fname,stag,sname : string;posn : longint);
     end;
{SECTION .Procs }
{+}


Procedure DisplayHelp(HLP : HELP_object; rows,cols : byte;var cmd : string);
                 {[MISC] HELP is sectioned text file returns exit command}

Procedure DoHelp(fname,secttag,sname : string;var cmd : string);
                 {[MISC] single section full screen}

Procedure DoHelpW(fname,secttag,sname : string;
                     x0,y0,rows,cols : byte; var cmd : string);
                 {[MISC] single section, return exit command}

Procedure DoHelpPosn(fname,secttag,sname : string;
                     posn : longint; var cmd : string);
                 {[MISC] single section using positioning}

Procedure DoHelpFileView(fn,secttag : string; var cmd : string);
                 {[MISC] Whole file by section selection}


{-}
{
   This form of a help system will consist of data taken from a text file
   which has been divided into '?SECTION's.

   The unit will read the file and keep the section names for selection.

   When a section has been selected, The section will be read into a
   string array and displayed as requested.  Upon exit from HELP, the
   array will be disposed of.

   This is NOT a 'tight' piece of code, I just want something NOW.
}
{+}


{SECTION .zImplementation }
IMPLEMENTATION

var sections   : HOLD_object;  { holds section names }
    keys       : STRA_object;  { holds keywords  }


{SECTION  HELP_object }
Procedure HELP_object.loadsectionseek(fname,stag,sname : string;
                                      posn : longint);
var secttag,sectname  : string[40];
    ok, found : boolean;
    sectlen   : integer;
    s     : string;
    i     : integer;
    TEXTF : TFILE_object;
     begin
     i := 0;
     found := false;
     secttag  := UpcaseStr(stag);
     sectname := UpcaseStr(sname);
     sectlen  := length(sectname);
     trim(sectname);
     TEXTF.init(fname,false);
     ok := TEXTF.opened;
     if ok then TEXTF.seek(posn-200);  { position near then read forward }
     while ok do                       { why ?? }
          begin
          ok := TEXTF.fetchnext(s);
          if ok then
               begin
               if secttag = leftstr(UpCaseStr(s),length(secttag)) then
                     begin
                    { writeln(posn,' ',TEXTF.currentposition,
                             ' [',s,']');
                     pause;}
                     if found then
                          begin
                          found := false;
                          ok := false;
                          end
                     else begin
                          delete(s,1,length(secttag));
                          trim(s);
                          if leftstr(UpCaseStr(s),sectlen) = sectname then
                                found := true;
                          end;
                     end
               else if found then ok := HELP_object.append(s);
               end;
          end;
     TEXTF.done;
     end;



{SECTION  LoadHELPSection }
Procedure LoadHELPSection(fn,secttag,sectname : string;
                          var HLP : HELP_object);
var s : string[1];
     begin
     HLP.init(HelpMaxLines);  {max lines per help section}
     if secttag <> '' then HLP.loadsection(fn,secttag,sectname)
     else HLP.load(fn);
     if HLP.count = 0 then
          begin
          if not fileexists(fn) then
               writeln('Help file does not exist [',fn,']')
          else writeln('Cannot file Help section [',sectname,']');
          end;
     end;


{SECTION  LoadHELPSectionPosn }
Procedure LoadHelpSectionPosn(fn,secttag,sectname : string; posn : longint;
                          var HLP : HELP_object);
var s : string[1];
     begin
     HLP.init(HelpMaxLines);  {max lines per help section}
     HLP.loadsectionseek(fn,secttag,sectname,posn);
     if HLP.count = 0 then
          begin
          if not fileexists(fn) then
               writeln('Help file does not exist [',fn,']')
          else writeln('Cannot file Help section [',sectname,']');
          end;
     end;


{SECTION  DisplayHelp }
Procedure DisplayHelp(HLP : HELP_object; rows,cols : byte;var cmd : string);
var s       : string;
    first,incr,prev,n,xrows   : integer;
     begin
     xrows := rows-3;
     cmd := '?HOME';
     first := 1;
     while (cmd <> '?ESCAPE') and (cmd <> '?SCREENPR') and
           (cmd <> '?LEFTARR') and (cmd <> '?RIGHTARR') do
          begin
          if (incr = 1) then
               begin
               n := (first+xrows-1);
               if (n<>prev) then writeln(HLP.fetchN(n));
               prev := n;
               end
          else begin
               clrscr;
               HLP.listpage(first,xrows,cols);
               end;
          GetKeycmd(cmd);
          incr := 0;
          if      cmd = '?UP'      then incr := -1*xrows
          else if cmd = '?DOWN'    then incr := xrows
          else if cmd = '?DOWNARR' then incr := 1
          else if cmd = '?UPARR'   then incr := -1
          else if cmd = '?HOME'    then first := 1
          else if cmd = '?END'     then first := 9999;
          first := first + incr;
          if ((first+rows) > HLP.count) then first := HLP.count - (xrows-1);
          if (first < 1) then first := 1;
          end;
     end;


{SECTION  DoHelp }
Procedure DoHelp(fname,secttag,sname : string;var cmd : string);
var wndw    : WINDOW_object;
    fn      : string[40];
    HLP     : HELP_object;
     begin
     fn := fname;
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'hlp');
          end;
     wndw.init(1,5,18,78,0);
     wndw.setlabels(' '+fname+' ['+sname+'] ',' ESC-Exit/Arr&Pg-move ');
     wndw.PopUp;
     wndw.smallwindow;
     LoadHelpSection(fn,secttag,sname,HLP);
     DisplayHelp(HLP,16,76,cmd);
     HLP.done;
     wndw.done;
     end;



{SECTION  DoHelpPosn }
Procedure DoHelpPosn(fname,secttag,sname : string;
                     posn : longint;var cmd : string);
var wndw    : WINDOW_object;
    fn      : string[40];
    HLP     : HELP_object;
     begin
     fn := fname;
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'hlp');
          end;
     wndw.init(1,5,18,78,0);
     wndw.setlabels(' '+fname+' ['+sname+'] ',' ESC-Exit/Arr&Pg-move ');
     wndw.PopUp;
     wndw.smallwindow;
     LoadHelpSectionPosn(fn,secttag,sname,posn,HLP);
     DisplayHelp(HLP,16,76,cmd);
     HLP.done;
     wndw.done;
     end;


{SECTION  DoHelpW }
Procedure DoHelpW(fname,secttag,sname : string;
                     x0,y0,rows,cols : byte; var cmd : string);
var wndw    : WINDOW_object;
    fn      : string[40];
    HLP     : HELP_object;
    sz      : string[14];
     begin
     fn := fname;
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'hlp');
          end;
     LoadHelpSection(fn,secttag,sname,HLP);
     sz := '['+integerstr(HLP.count,4);
     removeblanks(sz);
     sz := sz + ' lines]';
     wndw.init(x0,y0,x0+cols+2,y0+rows+1,0);
     wndw.setlabels(' '+fname+' ['+sname+'] ',' ESC-Exit/Arr&Pg-move '+sz);
     wndw.PopUp;
     wndw.smallwindow;
     DisplayHelp(HLP,rows,cols,cmd);
     HLP.done;
     wndw.done;
     end;


{SECTION  DoHelpFileView }
{PAGE}

{ Full sectioned text file browsing   DoHelpFileView(fname,sectiontag); }


Procedure UpdateKeysList(var keys : STRA_object; str : string);
var s,s1 : string;
    i : integer;
     begin
     s := trimstr(str);
     patchstr(s,'{',' ');
     patchstr(s,'[',' ');
     patchstr(s,']',' ');
     patchstr(s,'}',' ');
     while length(s) > 0 do
          begin
          trim(s);
          s1 := GetLeftStr(s,' ');
          i := keys.linearfind(s1);
          if i = 0 then keys.append(s1);
          end;
     end;


Procedure BuildHelpSectionIndex(fn : string; secttag, filter : string;
                       var sections : HOLD_object; var keys : STRA_object);
var t0       : TFILE_object;
    taglen   : integer;
    posn     : longint;
    s,s1,stag : string;
    i        : integer;
     begin
     writeln('Indexing ',fn,' ',secttag,'  Please wait a few seconds.');
    { pause;}
     taglen  := length(secttag);
     stag    := UpCaseStr(secttag);
     posn    := 0;
     t0.init(fn,false);
     while t0.fetchnext(s) do
          begin
          if (UpCaseStr(leftstr(s,taglen)) = stag) then
               begin
               delete(s,1,taglen);
               trim(s);
               s1 := GetLeftStr(s,' ');
               UpdateKeysList(keys,s);
               if (s1 <> '') then
                    begin
                  { writeln('section - ',s1);}
                    if filter = '' then sections.append(s1,posn)
                    else begin
                         i := pos(filter,s); {check the keywords}
                         if i > 0 then sections.append(s1,posn);
                         end;
                    end;
               end;
          posn := t0.currentposition;
          end;
     t0.done;
     end;


Procedure LoadHelpSections(fn : string; secttag, filter : string;
                       var sections : HOLD_object; var keys : STRA_object);
var txxname,keyname : string;
     begin
     if filter = '' then
          begin
          txxname := fn; forceext(txxname,'txx');
          keyname := fn; forceext(keyname,'key');
          if fileexists(txxname) and
            (filedate(fn,'') < filedate(txxname,'')) then
               begin
               sections.load(txxname);
               keys.load(keyname);
               end
          else begin
               BuildHelpSectionIndex(fn,secttag,'',sections,keys);
               sections.sort;
               sections.save(txxname);
               keys.sort;
               keys.save(keyname);
               end;
          end
     else begin
          BuildHelpSectionIndex(fn,secttag,filter,sections,keys);
          keys.sort;
          sections.sort;
          end;
     writeln('Sections = ',sections.count);
     end;


Procedure HelpViewCommand(var cmd : string; var sections : HOLD_object;
                          var itemselect : integer);
     begin
     if cmd = '?LEFTARR' then
          begin
          dec(itemselect);
          if itemselect < 1 then itemselect := 1;
          cmd := '?SELECTED';
          end
     else if cmd = '?RIGHTARR' then
          begin
          inc(itemselect);
          if itemselect > sections.count then
               itemselect := sections.count;
          cmd := '?SELECTED';
          end
     else begin
          cmd := '?RESELECT';
          end;
     end;


Procedure DoHelpWCmdPosn(fname,secttag,sname : string; posn : longint;
                     x0,y0,rows,cols : byte; var cmd : string);
var wndw    : WINDOW_object;
    fn      : string[40];
    HLP     : HELP_object;
     begin
     fn := fname;
     if fn = '' then
          begin
          fn := paramstr(0);
          ForceExt(fn,'hlp');
          end;
     LoadHelpSectionPosn(fn,secttag,sname,posn,HLP);
     wndw.init(x0,y0,x0+cols+2,y0+rows-1,0);
     wndw.setlabels(' '+fname+' ['+sname+'] ',
                    ' ESC-Exit/Arr&Pg-move ');
     wndw.PopUp;
     wndw.smallwindow;
     {HLP.save('junk.txt');}
     DisplayHelp(HLP,rows,cols,cmd);
     HLP.done;
     wndw.done;
     end;


Procedure ChooseNewFilter(var fn,secttag,filter : string);
var itemselect : integer;
    cmd : string;
     begin
     itemselect := 1;
     SetSelectwindow(1,1,22,4,15);  { x0,y0,x1,columns,colwidth}
     SetSelectWindowLabels(' File: '+fn+'    keyword: '+filter+' ',
                           ' Choose a Filter ');
     Select(keys,filter,itemselect,cmd);
     sections.done;
     sections.init(1000);
     LoadHelpSections(fn,secttag,filter,sections,keys);
     end;


Procedure DoHelpFileView(fn,secttag : string; var cmd : string);
var sectname   : string[40];
var itemselect : integer;
    filter     : string;
    posn       : longint;
     begin
     filter := '';
     itemselect := 1;
     HelpMaxLines := 100;
     cmd        := '?RESELECT';
     sections.init(1000);
     keys.init(200);
     LoadHelpSections(fn,secttag,filter,sections,keys);
     while itemselect > 0 do
          begin
          SetSelectwindow(1,1,22,4,15);  { x0,y0,x1,columns,colwidth}
          SetSelectWindowLabels(' File: '+fn+'    keyword: '+filter+' ',
                                ' Select a Section / F5 - choose filter ');
          Select(sections,sectname,itemselect,cmd);
          if cmd = '?FKEY5' then ChooseNewFilter(fn,secttag,filter);
          while (cmd = '?SELECTED') do
              begin
              sectname := sections.fetchStrN(itemselect);
              posn     := sections.fetchNumN(itemselect);
              DoHelpWCmdPosn(fn,secttag,sectname,posn,1,1,22,77,cmd);
              HelpViewCommand(cmd,sections,itemselect);
              end;
          end;
     sections.done;
     keys.done;
     end;


{SECTION  zzInitialization }
     begin {Initialization }
     HelpMaxLines := 300;
     end.
