{SECTION ..PbDATA }
UNIT PbDATA;

INTERFACE


{
Description:  Global data for all programs

Author      : Howard Richoux
Date        : 2/18/94
Last revised:
Application : IBM PC and compatibles, Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/94
Published in: none

These variables are supported by PbPARMS  .CFG file loading

StandardpVarsInit - sets a group of standard variables, free decoding:
    Internal   External(CFG)    Possible Use                   Default
    --------   --------         ---------------------------    -------
    pFirst     FIRST=<nnn>      First record number to keep    0
    pLast      LAST=<nnn>       Last record number to keep     32700
    pCount     COUNT=<nnn>      Number of records to keep      32700
    pRecs      RECS=<nnn>       Number of records to keep      32700
    pSkip      SKIP=<nnn>       Number of records to skip      0
    pSize      SIZE=<nnn>       Record size                    16
    pDelay     DELAY=<nnn>      millisecond delay              100

    pDataPath  DATAPATH=xx..x   Data directory                 ''
    pOutFile                    CON LPT1, ...                  'CON'

    pDebug     DEBUG=ON         Turn On/Off debugging          false

    pSystemID                   TAG to identify system         ''
    pPrinterID                  TAG to identify printer type   ''
    pProgID    (*miscstuf*)     ID & version # of program      ''
    pCurrFName                  file being operated on         ''
    pExtraCFG  EXTRA=fspec      secondary CFG file             ''
}

{SECTION ..PbPARMS_DATA }
var pProgID                                 : string[24];
var pSkip, pCount, pFirst, pLast, pRecs     : integer;
var pDelay, pSize                           : integer;
var pDataPath                               : string[60];
var pDebug                                  : boolean;
var pCurrFName, pOutFile                    : string[50];
var pExtraCFG                               : string[50];
var pSystemID,pPrinterID                    : string[12];
var parmsinitted                            : boolean;


IMPLEMENTATION

Procedure InitPbDATA;
     begin
     pSkip        := 0;     pCount   := 32700;
     pFirst       := 0;     pLast    := 32700;     pRecs    := 32700;
     pDelay       := 100;
     pSize        := 16;
     pDebug       := false;
     pDataPath    := '';
     parmsinitted := false;
     pCurrFName   := '<pCurrFileName>';
     pOutFile     := 'CON';
     pProgID      := '<pProgID>';
     pExtraCFG    := '';
     end;


     begin  {initialization}
     InitPbDATA;
     end.
