{SECTION  TFILE_object }
procedure TFILE_object.init(fn : string; create : boolean);
var fdir   : string[40];
    fname  : string[8];
    fext   : string[4];
     begin
     opened   := false;
     filename := fn;
     linenum  := 0;
     PosCurr  := 0;
     err := 0;
     TFILE_object.open(filename,create);
     end;


procedure TFILE_object.InitAppend(fn : string);
var fdir   : string[40];
    fname  : string[8];
    fext   : string[4];
     begin
     opened   := false;
     filename := fn;
     linenum  := 0;
     PosCurr  := 0;
     err := 0;
     if not FileExists(fn) then
          begin
          TFILE_object.open(filename,true);
          end
     else begin
          assign(fil,fn);
          {$I-} System.Append(fil); {$I+}
          opened := not IOResultErrChk;
          end;
     end;


procedure TFILE_object.done;
     begin
     TFILE_object.close;
     end;


Function TFILE_object.IOResultErrChk : boolean;
     begin
     err := IORESULT;
     if err = 0 then
          IOResultErrChk := false
     else IOResultErrChk := true;
     if err <> 0 then
          writeln('tfile error [',filename,']  ',err);
     end;



Procedure TFILE_object.open(fn : string; create : boolean);
     begin
     linenum := 0;
     if opened then TFILE_object.close;
     assign(fil,fn);
     if create then
          {$I-} ReWrite(fil) {$I+}
     else begin
          {$I-} Reset(fil); {$I+}
          end;
     opened := not IOResultErrChk;
     end;


Procedure TFILE_object.seek(l : longint);
var ok : boolean;
    ch  : char;
     begin
     if opened then ok := TextSeek(fil,l);
     PosCurr := l;
     linenum := -1; {no way top compute}
     end;


Function  TFILE_object.currentposition : longint;
     begin
     PosCurr := textpos(fil);
     currentposition := PosCurr;
     end;


Function TFILE_object.fetchnext(var s : string) : boolean;
var ok : boolean;
     begin
     ok := false;
     s := '';
     if opened and not EOF(fil) then
          begin
         {$I-} SYSTEM.readln(fil,s); {$I+}
          if not IOResultErrChk then
               begin
               inc(linenum);
               ok := true;
               end;
          end;
     fetchnext := ok;
     end;


Function  TFILE_object.append(s : string) : boolean;
var ok : boolean;
     begin
     ok := false;
     if opened then
          begin
         {$I-}
          SYSTEM.writeln(fil,s);
         {$I+}
          if not IOResultErrChk then
               begin
               inc(linenum);
               ok := true;
               end;
          end;
     append := ok;
     end;



procedure TFILE_object.close;
     begin
     if opened then
          begin
         {$I-} SYSTEM.Close(fil); {$I+}
          IOResultErrChk;
          opened := false;
          end;
     end;


procedure TFILE_object.clearfile;
var fn : string;
     begin
     fn := filename;
     TFILE_object.close;
     TFILE_object.open(fn,true);      { do a REWRITE }
     end;


procedure TFILE_object.refreshfile;
var fn : string;
     begin
     fn := filename;
     TFILE_object.close;
     TFILE_object.open(fn,false);      { do a RESET }
     end;


Function  TFILE_object.error : boolean;
     begin
     if err <> 0 then error := true
     else error := false;
     end;
