PROGRAM UsesProg;

{$M 20000,0,50000}

Uses DOS, PbMISC, PbDATA, PbOBJS, PbOUT0, PbPARMS;

{
Description : Examines programs and units USES statements

Author      : Howard Richoux
Date        : 2/91
Last revised: 12/25/93
               2/18/94 2.05 new libraries
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

 Program to scan a group of .pas files and list out the USES statements.
 Alternative mode is to pass the name of a unit on the param line and
 the program will scan the files, listing the ones which use that unit.  The
 match will be for the length of the param you enter, so a group of
 units which all start the same way can be checked at once.
}

var S            : string;
var fname        : string[60];
    testunit     : string[8];
    firstmsg     : boolean;


{*****************************************************************}

Procedure CheckUses( testunit : string; var s1 : string);
var i,l    : integer;     { makes s1 := '' if testunit not found }
    s,s2   : string;
    ok     : boolean;
     begin
     {writeln('Checkuses  [',testunit,'] [',s1,']');}
     l := length(testunit);
     if l = 0 then exit;
     if length(s1) = 0 then exit;
     s := s1;
     ok := false;
     while length(s) > 0 do
          begin
          s2 := getstring(s);
          if testunit = UpCaseStr(leftstr(s2,l)) then ok := true;
          end;
     if not ok then s1 := '';
     end;


Procedure ListFile(fname : string);
var line,s : string;
    s1     : string;
    done,found,ok : boolean;
    i             : integer;
    tx            : TFILE_object;
    begin
   { writeln('ListFile  [',fname,']');}
    s1 := '';
    done := false;
    found := false;
    tx.init(fname,false);
    while tx.fetchnext(line) and not done do
        begin
        s := UpCaseStr(line);
        trim(s);
        if copy(s,1,4) = 'USES' then
             begin
             delete(line,1,4);
             found := true;
             end;
        if found then
             begin
             s1 := s1 + line;
             removeblanks(s1);
             ok := removebracketcomments(s1,'{','}');
             i := pos(';',line);
             if i > 0 then done := true;
             end;
        end;
    CheckUses(testunit,s1);
    if length(s1) > 0 then
         begin
         if firstmsg and (testunit <> '') then
              begin
              firstmsg := false;
              OUT(' The following files use: ['+testunit+']');
              OUT(' ');
              end;
         OUT(leftstr(fname,12)+' USES '+s1);
         end
    else if testunit = '' then OUT(leftstr(fname,12)+' USES none');
    tx.done;
    end;



Procedure ListFiles(fn : string);
var SR :searchrec;
    i  : integer;
    fname : string;
     begin
     writeln('');
    { writeln('ListFiles [',fn,']');}
     fname := fn;
     FindFirst(fname,anyfile,SR);
     while dosError = 0 do
          begin
          fname := SR.name;
          ListFile(fname);
          FindNext(SR);
          end;
     end;


Procedure init;
     begin
     testunit := '';
     firstmsg := true;

     StandardOUTInit;
     OUTSetCompressed;
     getdir(0,fname);
     fname := addbackslash(fname) + '*.pas';
     writeln('');
     end;


(*  Main program *)
     BEGIN
     pProgID := 'USES 2.05';
     init;
     writeln(pProgID,' - USES Checker');

     if paramcount > 0 then      { want to check for specific unit }
          begin
          writeln(' scanning: ',fname);
          if paramstr(1) = '*' then
               begin
               ListFiles(fname);
               end
          else begin
               testunit := UpCaseStr(paramstr(1));
               writeln(' Checking for: ',qt(testunit));
               ListFiles(fname);
               end;
          if firstmsg then
               begin
               if testunit <> '' then
                    writeln(' No files used [',testunit,']');
               end;
          end
     else ShowDocFile;
     OUTdone;
     end.


