Program README;

{$M 15000,0,655000}

uses PbCRT, PbMISC, PbDATA, PbOBJS, PbHIGH, PbPARMS, PbOUT0,
     PbSELECT, PbHELP;

{
Description:  README - Simple Program to View text files

Author      : Howard Richoux
Date        : 1/9/91
Last revised: 1/11/94 1.00 cleanup
              5/2/94  1.06 re-write add cfg file & print
Application : IBM PC and compatibles, done in Turbo Pascal 5.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none
}


var dir,template   : string[40];
var x              : CRTSaveRec;


Function OKToRead(fn : string) : boolean;
var ok   : boolean;
    extn : string[4];
    i    : integer;
    s    : string[1];
    crtsave : crtsaverec;
     begin
     ok := true;
     extn := rightstr(fn,4);
     if (extn = '.EXE') or (extn = '.COM') or
        (extn = '.DBF') or (extn = '.ZIP') or
        (extn = '.TPU') or (extn = '.   ') or
        (extn = '.ARC') or (extn = '.PCK') or
        (extn = '.OBJ') then
          begin
          ok := false;
          SimpleWindow(10,10,3,60,' NOT A TEXT FILE ',' Select again. ',crtsave);
          writeln('');
          writeln('  ',fn);
          readln(s);
          RestoreCRT(crtsave);
          end;
     OKToRead := ok;
     end;


Procedure OUTTextFile(fn : string);  {Probably move this to PbOUTs if useful }
var tx : TFILE_object;
    s : string;
    begin
    tx.init(fn,false);
    while tx.fetchnext(s) do
         begin
         OUT(s);
         end;
    OUTdoneWithPage;
    end;


Procedure DoView(dir,template : string);
var filename   : string[40];
    cmd        : string[40];
    itemselect : integer;
var files      : STRA_object;
     begin
     itemselect := 1;
     HelpMaxLines := 1000;
     filename   := '';
     cmd        := '?RESELECT';
     files.init(200);
     GetfilesSTRA(dir+Template, files, fsortbyname);
     while itemselect > 0 do
          begin
          SetSelectwindow(3,3,15,3,15);
          SetSelectWindowLabels(' '+pProgID+' - Text File Viewer ',
                                ' Select a File w/Arrows - ESC to exit ');
          Select(files,filename,itemselect,cmd);
          if (filename <> '') and OKToRead(filename) then
              begin
              DoHelpW(dir+filename,'','',1,1,22,77,cmd); {this is the biggest}
              if cmd = '?SCREENPR' then OUTTextFile(dir+filename);
              end;
          end;
     files.done;
     end;


Procedure READMEInit;
var i : integer;
    s : string;
     begin
     if paramcount > 0 then
          begin
          s := UpCaseStr(paramstr(1));
          if      (s = 'A') or ( s = 'A:') then dir := 'A:'
          else if (s = 'B') or ( s = 'B:') then dir := 'B:'
          else if s[length(s)] = '\'       then dir := s
          else begin
               i := pos('.',s);
               if i > 0 then template := s
               else dir := s;
               end;
          end;

     i := pos('\',template);
     if i > 0 then dir := ExtractPath(template);
     if dir = '' then getdir(0,dir);
     dir := addbackslash(dir);
     end;


Procedure Init;
     begin
     AddParm(1,'DIR','');
     ADDParm(1,'TEMPLATE','*.*');
     AddParm(1,'OUT','LPT1');

     StandardOUTInit;

     dir      := GetParmStr('DIR');
     template := GetParmStr('TEMPLATE');

     end;


     begin {main}
     pProgID := 'README 1.06';
     Init;
     SaveCRT(x);
     READMEInit;
     if template <> '' then DoView(dir,template)
     else writeln('template = ',template,'   dir = ',dir);
     RestoreCRT(x);
     OutDone;
     end.
