PROGRAM Put;

{$M 20000,0,50000}

Uses PbMISC, PbDATA, PbOBJS, PbHIGH, PbOUT0, PbPARMS;

{
Description : Smart copydown to Floppy

Author      : Howard Richoux
Date        : 12/18/93
Last revised: 12/20/93 hnr changed HNR* to H*
              12/25/93 1.02 PbOUT
              1/12/94  1.03 cleanup
              2/18/94  1.04 new libraries
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none

Config Parameters        meaning              default
FILES                    if no params         do HNR*.zip
SOURCE                   if no params         c:\zip\
DEST                     if no params         b:
ZIPTEST                  do PKUNZIP -t <dest><files>
}



var files  : string;
    source : string;
    dest   : string;
    fileext : string[3];
    ziptestflag : boolean;

var log      : STRA_object;

{*****************************************************************}


Procedure CopyAndTestFile(source,fn,dest : string; testflag : boolean);
var s : string;
    err : integer;
     begin
     s := 'copy   '+addbackslash(source)+fn+' '+
                  addbackslash(dest)+'*.*';
     log.append(s);
     writeln(s);
     err := ExecuteCommand(s);
     if err <> 0 then
          begin
          log.append('Copy   failed  err='+integerstr(err,4));
          exit;
          end;
     if ziptestflag then
          begin
          s := 'pkunzip -T '+addbackslash(dest)+fn;
          log.append(s);
          writeln(s);
          err := ExecuteCommand(s);
          if err <> 0 then
               begin
               log.append('PKUNZIP -T  failed  err='+integerstr(err,4));
               exit;
               end;
          end;
     OUT(' ');
     end;


Procedure DumpLog(log : STRA_object);
var i : integer;
    begin
    OUT(' ');
    OUT('PUT - log of commands');
    for i := 1 to log.count do
         begin OUT(log.fetchN(i)); end;
    log.done;
    end;


Procedure GoOn;
var s,srcfn,dstfn : string;
    flist : STRA_object;
    i : integer;
     begin
     flist.init(200);
     log.init(500);  { commands and errors }
     log.append('Copying ['+files+']  from ['+source+']  to ['+dest+']');

     s := addbackslash(source)+files;
     GetFilesSTRA(s,flist,fNoSort);
     i := 1;
     while i <= flist.count do
          begin
          srcfn := addbackslash(source)+flist.fetchN(i);
          dstfn := addbackslash(dest)+flist.fetchN(i);
          if not EquivalentFile(srcfn,dstfn) then
               begin
               CopyAndTestFile(source,flist.fetchN(i),dest,ziptestflag);
               end
          else begin
               log.append('Skipping '+srcfn);
               writeln('Skipping '+srcfn);
               end;
          inc(i);
          end;
     flist.done;
     DumpLog(log);
     end;



Procedure Init;
var s : string;
    begin
    AddParm(1,'FILES','H*.ZIP');
    AddParm(1,'EXT','ZIP');
    AddParm(1,'SOURCE', 'C:\ZIP\');
    AddParm(1,'DEST', 'B:');
    AddParm(1,'ZIPTEST', 'YES');

    StandardOUTInit;

    files       := GetParmStr('FILES');
    source      := GetParmStr('SOURCE');
    dest        := GetParmStr('DEST');
    fileext     := GetParmStr('EXT');
    ziptestflag := CheckOK('ZIPTEST');
    OUTSetNoPause;

    if paramcount >0 then
         begin
         files := paramstr(1);
         ForceExt(files,fileext);
         end;
    end;


(*  Main program *)
     BEGIN
     pProgID := 'Put 1.04';
     Init;
     GoOn;
     OUTdone;
     end.


