(*PAGE*)
PROGRAM FIND;

{$M 20000,0,655000}

Uses DOS, PbMISC, PbDATA, PbOBJS, PbOUT0, PbPARMS;

{
Description : FIND - locates all occurances of a filespec

Author      : Howard Richoux
Date        : 12/9/93
Last revised: 12/21/93 1.05 minor fixes
              12/30/93 1.10 combined with BIGFILES
               2/18/94 1.12 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

combined program BIGFILES and FIND to save code

>FIND *.* MODE=BIG MINSIZEK=250                    (SEARCHES WHOLE DISK)
>FIND *.* MODE=BIG MINSIZEK=250  ROOT=C:\WINDOWS   (SEARCHES C:\WINDOWS\..)

>FIND MISCSTUF.PAS


}



var filespec : string;
var ProgramMode : string;
var err      : byte;
var minsizek : longint;
var minsize  : longint;
var outfile  : string;
var root     : string;
var count    : integer;



{*****************************************************************}

{
 SearchRec - for reference
    type searchrec = record
           fill  : array[1..21] of byte;
           attr  : byte;
           time  : longint;
           size  : longint;
           name  : string[12];
           end;
}


{ FIND portion }

Procedure DealWithFind( var sr : SearchRec; p : pathstr);
var s : string;
     begin
     OUT(FullFmtSearchRec(SR,p));
     end;


Procedure FindIt;
     begin
     filespec := paramstr(1);
   {  SearchEngineAll('c:\',filespec,anyfile,DealWithfind,Err);}
     SearchEngineAll(root,filespec,anyfile,DealWithfind,Err);
     end;



{BIGFILES portion }

Procedure DealWithBigFile( var sr : SearchRec; p : pathstr);
var s : string;
     begin
     if sr.size > minsize then
          begin
          if count = 0 then
               begin
               OUT('  Current threshold ='+integerstr(minsizek,4)+
                     'k   root dir='+root);
               OUT(' ');
               end;
          OUT(FullFmtSearchRecK(sr,p));
          inc(count);
          end;
     end;


Procedure CheckBiggies;
     begin
     writeln('  Current threshold =',minsizek,'k   root dir=',root,
            '  Out=',pOutFile);
     SearchEngineAll(root,'*.*',anyfile,DealWithBigFile,Err);
     if count = 0 then writeln('   No files found.')
     else OUT('   Files found: '+ integerstr(count,4));
     end;


{Initialization}

Procedure init;
     begin
     AddParm(1,'ROOT','');            {default to current path}
     AddParm(1,'MINSIZEK','100');     {100k byte minimum}
     AddParm(1,'MODE','FIND');        {FIND/BIG}

     StandardOUTInit;

     ProgramMode := UpCaseStr(GetPARMStr('MODE'));

     count    := 0;
     minsizek := GetParmNum('MINSIZEK');
     minsize  := minsizek * 1024;
     root     := GetParmStr('ROOT');
     if root='*.*' then GetDir(0,root);
     end;


(*  Main program *)
     BEGIN
     pProgID := 'Find 1.12';
     init;
     if (ParamCount > 0) then
          begin
          if ProgramMode = 'FIND' then FindIt
          else CheckBiggies;
          end
     else ShowDocFile;
     OUTdone;
     end.
