Program dbPasGen;

{$M 10000,0,10000}

uses PbMISC, PbDATA, PbOBJS, PbPARMS, PbXBASE;

{
Description:  Program to generate PASCAL Type And OBJECT for dBase record

Author      : Howard Richoux
Date        : 10/10/90
Last revised: 11/10/90
              11/25/93  hnr 2.00  support DBF OBJECT
              12/13/93  hnr 2.05  keyed dbf object
              12/17/93  hnr 2.10  OUT_object
               1/10/94  hnr 2.15  make read & write boolean functions
               1/12/94  hnr 2.20  memo READ support
               1/16/94  hnr 2.25  handle 1 or 2 MEMO fields
               1/29/94  hnr 2.26  dates are 8 bytes not 10, do reals better
               2/9/94   hnr 2.28  added FINDREC (field, fieldval)
               2/10/94  hnr 2.30  added DELETEREC (n)
               2/18/94  HNR 2.32  NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 5.0
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}




var dbfname : string[40];
var dbf     : XBASE_DBF_object;
var recname : string[7];
var memoflag    : boolean;
    memofield1   : string;
    memofield1no : integer;
    memofield2   : string;
    memofield2no : integer;
    memoconst    : string[5];

var L       : OUT_object_0;


Procedure MakeUnit(dbroot : string);
var i, width   : integer;
    rtype      : char;
    tmp, tpe   : string[40];
     begin
     L.out('{SECTION ..X'+dbroot+' }');
     L.out(' ');
     L.out('{ '+pProgID+' '+FormatDTime+'   Placed in the Public Domain by HNR Software 1/29/1994 }');
     L.out(' ');
     L.out('Unit x'+dbroot+';');
     L.out(' ');
     L.out('INTERFACE');
     L.out(' ');
     L.out('Uses PbMISC, PbDATA, PbOBJS, PbXBASE, PbDBOBJ, PbMEMO;');
     L.out(' ');
     end;


Procedure MakeUnitEnd;
     begin
     L.out(' ');
     L.out('{SECTION zzInitialization }');
     L.out('      begin { initialization }');
     L.out('      end.');
     end;


Procedure MakeObject(dbroot : string);
var i, width   : integer;
    rtype      : char;
    tmp, tpe   : string[40];
     begin
     L.out('{SECTION .'+dbroot+'_DBF_object }');
     L.out(' ');
     L.out('const '+dbroot+'_DBF_recsize = '+
                integerstr(dbf.dbhead.rec_bytes,4)+';');
     if memoflag then L.out('const memomaxlines = '+memoconst+';');
     L.out(' ');
     L.out('type  '+dbroot+'_DBF_object = OBJECT(keyed_DBF_object)');
     L.out('         rec       : '+dbroot+'_record;');
     L.out('         msg       : string[60];');
     if memoflag then
          begin
          L.out('         memofile  : MEMO_object;');
          L.out('         memo1     : STRA_object;');
          if memofield2 <> '' then
               L.out('         memo2     : STRA_object;');
          L.out('         autoread  : boolean;');
          L.out('         UpdateMemo: boolean;');
          L.out('         Procedure  Init(fn : string; rcz,dm : integer;'+
                                   'tg,ks : string; km : integer);');
          L.out(' ');
          end;
     L.out('         Procedure  GetPas'+dbroot+';');
     L.out('         Procedure  PutPas'+dbroot+';');
     L.out('         Function   ReadRec  ( i : longint) : boolean;');
     L.out('         Function   WriteRec ( i : longint) : boolean;');
     L.out('         Function   DeleteRec ( i : longint) : boolean;');
     L.out('         Function   FindRec  ( fnam,fval : string) : boolean;');
     if memoflag then
          begin
          L.out('         Procedure  ReadMemos;');
          end;
     L.out('         end;');
     L.out(' ');
     L.out('{SECTION .zImplementation }');
     L.out('IMPLEMENTATION');
     L.out(' ');
     end;


Procedure MakeInitProc(dbroot : string);
var i, width   : integer;
    rtype      : char;
    tmp,tmp2,tpe    : string[20];
     begin
     if not memoflag then exit;
     L.out(' ');
     L.out('Procedure  '+dbroot+'_DBF_object.Init(fn : string; rcz,dm : integer;'+
                              'tg,ks : string; km : integer);');
     L.out('var memofn : string;');
     L.out('     begin');
     L.out('     msg        := ''' + dbroot + ' init ok'';');
     L.out('     autoread   := false;');
     L.out('     updatememo := false;');
     if memoflag then
          begin
          L.out('     memo1.init(memomaxlines);');
          if memofield2 <> '' then
               L.out('     memo2.init(memomaxlines);');
          L.out('     memofn := fn; forceext(memofn,''dbt'');');
          end;
     L.out('     KEYED_DBF_object.init(fn,rcz,dm,tg,ks,km);');
     L.out('     memofile.init(memofn,dm);');
     L.out('     end;');
     L.out(' ');
     L.out(' ');
     end;



Procedure MakeRecType(dbroot : string);
var i, width, decp : integer;
    rtype          : char;
    tmp, tpe       : string;
     begin
     L.out('{SECTION .'+dbroot+'_record }');
     L.out('type '+dbroot+'_record = record ');
     for i := 1 to dbf.dbnumfields do
         begin
         tmp := leftstr(dbf.dbfldname(i),10);
         rtype := dbf.dbfldrtype(i);
         width := dbf.dbfldwidth(i);
         decp  := dbf.dbflddecp(i);
         case rtype of
             'C' :tpe := 'string['+integerstr(width,3)+']';
             'N' :begin
                  if      decp  > 0 then  tpe := 'real'
                  else if width < 5 then  tpe := 'integer'
                  else if width < 10 then tpe := 'longint'
                  else tpe := 'real';
                  end;
             'D' :tpe := 'string[8]      {date}';
             'L' :tpe := 'boolean';
             'M' :begin
                  memoflag    := true;
                  if memofield1 = '' then
                       begin
                       memofield1   := trimstr(tmp);
                       memofield1no := i;
                       tpe := 'longint        { memo1 }';
                       end
                  else begin
                       memofield2   := trimstr(tmp);
                       memofield2no := i;
                       tpe := 'longint        { memo2 }';
                       end;
                  end;
             else
                  begin
                  L.out('{ *** Unknown type ['+rtype+'] }');
                  tpe := 'string[1]';
                  end;
             end;
         removeblanks(tpe);
         L.OUT('          _'+tmp+' : '+tpe+';');
         end;
     L.OUT('          end;');
     L.out(' ');
     end;



Procedure MakeGetPasProc(dbroot : string);
var i, width, decp   : integer;
    rtype            : char;
    tmp,tmp2,tpe     : string[20];
     begin
     L.out('{SECTION '+dbroot+'_DBF_object }');
     L.out(' ');
     L.out('Procedure '+dbroot+'_DBF_object.GetPas'+dbroot+';');
     L.OUT('     begin');
     L.OUT('     fillchar(rec,sizeof(rec),0);');
     L.OUT('     with rec do');
     L.OUT('          begin');
     for i := 1 to dbf.dbnumfields do
         begin
         tmp := leftstr(dbf.dbfldname(i),10);
         rtype := dbf.dbfldrtype(i);
         width := dbf.dbfldwidth(i);
         decp  := dbf.dbflddecp(i);
         case rtype of
             'C' :tpe := 'dbstr';
             'N' :begin
                  if      decp  > 0 then  tpe := 'dbreal'
                  else if width < 5 then  tpe := 'dbint'
                  else if width < 10 then tpe := 'dblong'
                  else tpe := 'dbreal';
                  end;
             'D' :tpe := 'dbstr';
             'L' :tpe := 'dblogic';
             'M' :tpe := 'dblong';
             else tpe := 'dbbadtype';
             end;
         removeblanks(tpe);
         tmp2 := tmp;
         trim(tmp2);
         L.OUT('          _'+tmp+' := dbf.'+tpe+'(dbf.dbfldno('''+
                                  tmp2+'''));');
         end;
     L.OUT('          end;');
     L.OUT('     end;');
     L.out(' ');
     L.out(' ');
     end;


Procedure MakePutPasProc(dbroot : string);
var i, width, decp   : integer;
    rtype            : char;
    tmp,tmp2,tpe     : string[20];
     begin
     L.out(' ');
     L.out('Procedure '+dbroot+'_DBF_object.PutPas'+dbroot+';');
     L.OUT('     begin');
     L.OUT('     dbf.dbcleardbbuf;');
     L.OUT('     with rec do');
     L.OUT('          begin');
     for i := 1 to dbf.dbnumfields do
         begin
         tmp := leftstr(dbf.dbfldname(i),10);
         rtype := dbf.dbfldrtype(i);
         width := dbf.dbfldwidth(i);
         decp  := dbf.dbflddecp(i);
         case rtype of
             'C' :tpe := 'dbputstr';
             'N' :begin
                  if      decp  > 0 then  tpe := 'dbputreal'
                  else if width < 5 then  tpe := 'dbputint'
                  else if width < 10 then tpe := 'dbputlong'
                  else tpe := 'dbputreal';
                  end;
             'D' :tpe := 'dbputstr';
             'L' :tpe := 'dbputlogic';
             'M' :tpe := 'dbputlong';
             else tpe := 'dbputbadtype';
             end;
         removeblanks(tpe);
         tmp2 := tmp;
         trim(tmp2);
         trim(tmp);
         L.OUT('          dbf.'+tpe+'(dbf.dbfldno('''+tmp2+'''), _'+tmp+');');
         end;
     L.OUT('          end;');
     L.OUT('     end;');
     L.out(' ');
     L.out(' ');
     end;


Procedure MakeReadWriteProcs(dbroot : string);
var i, width   : integer;
    rtype      : char;
    tmp,tmp2,tpe    : string[20];
     begin
     L.out(' ');
     L.out('Function  '+dbroot+'_DBF_object.ReadRec( i : longint) : boolean;');
     L.out('var memonum : longint;');
     L.OUT('     begin');
     L.out('     msg := '''+dbroot+' ReadRec ok.'';');
     L.OUT('     ReadRec := true;');
     L.OUT('     if not dbf.dbgoto(i) then ');
     L.OUT('          begin');
     L.OUT('          ReadRec := false;');
     L.OUT('          fillchar(rec,sizeof(rec),0);');
     L.out('          msg := ''' + dbroot + ' ReadRec failed. ('''+
                             '+integerstr(err,4)+'')   ''+longintstr(i,6);');
     L.OUT('          end');
     L.OUT('     else begin');
     L.OUT('          GetPas'+dbroot+';');
     if memoflag then
          L.OUT('          if autoread then ReadMemos;');
     L.OUT('          end;');
     L.OUT('     if dbf.dbdeleted then ');
     L.out('          msg := ''' + dbroot + ' Current record is DELETED. ('''+
                             '+integerstr(err,4)+'')   ''+longintstr(CurrRec,6);');
     L.OUT('     end;');
     L.out(' ');
     L.out(' ');
     L.out('Function  '+dbroot+'_DBF_object.WriteRec( i : longint) : boolean;');
     L.out('var blocks   : integer;');
     L.out('var memonum  : longint;');
     L.out('var ok       : boolean;');
     L.out('     begin');
     L.out('     WriteRec := true;');
     L.out('     msg := '''+dbroot+' WriteRec ok.'';');
     if memoflag then
          begin
          L.out('     if updatememo then ');
          L.out('          begin');
          L.out('          memonum := dbf.dblong(dbf.dbfldno('''+memofield1+'''));');
          L.out('          memofile.storeN(memo1,memonum,blocks);');
          L.out('          rec._'+memofield1+' := memonum; { if memo needed to be moved }');
          if memofield2 <> '' then
               begin
               L.out('          memonum := dbf.dblong(dbf.dbfldno('''+memofield2+'''));');
               L.out('          memofile.storeN(memo2,memonum,blocks);');
               L.out('          rec._'+memofield2+' := memonum; { if memo needed to be moved }');
               end;
          L.out('          end;');
          end;
     L.out('     PutPas'+dbroot+';');
     L.out('     if i > numrecs then ok := dbf.dbappend');
     L.out('     else begin');
     L.out('          if dbf.dbposition(i) then ');
     L.out('               ok := dbf.dbrewrite(i);');
     L.out('          end;');
     L.out('     if not ok then');
     L.out('          begin');
     L.out('          WriteRec := false;');
     L.out('          msg := ''' + dbroot + ' WriteRec failed. ('''+
                             '+integerstr(err,4)+'')   ''+longintstr(i,6);');
     L.out('          end;');
     L.out('     end;');
     L.out(' ');
     L.out(' ');
     L.out('Function  '+dbroot+'_DBF_object.FindRec( fnam,fval : string) : boolean;');
     L.out('var memonum : longint;');
     L.OUT('     begin');
     L.OUT('     FindRec := false;');
     L.OUT('     if fetchwhere(fnam, ''='', fval) then ');
     L.OUT('          begin');
     L.OUT('          FindRec := true;');
     L.OUT('          ReadRec(CurrRec);');
     L.OUT('          end');
     L.OUT('     else begin');
     L.OUT('          TOP;');
     L.OUT('          dbf.dbcleardbbuf;');
     L.OUT('          GetPas'+dbroot+';');
     L.out('          msg := ''' + dbroot + ' FindRec failed. ('''+
                        '+integerstr(err,4)+'')   [''+fnam+'',''+fval+'']'';');
     L.OUT('          end;');
     L.OUT('     end;');
     L.out(' ');
     L.out(' ');
     L.out('Function  '+dbroot+'_DBF_object.DeleteRec( i : longint) : boolean;');
     L.out('var ok           : boolean;');
     L.out('     begin');
     L.out('     DeleteRec := true;');
     L.out('     msg := '''+dbroot+' DeleteRec ok.'';');
     L.out('     if i <> CurrRec then ');
     L.out('          begin');
     L.out('          msg := ''' + dbroot + ' DeleteRec failed. Record not current. curr='''+
                             '+longintstr(CurrRec,6)+'' <> i=''+longintstr(i,6);');
     L.out('          DeleteRec := false;');
     L.out('          end');
     L.out('     else begin');
     L.out('          ok := dbf.dbdelete(i);');
     L.out('          if not ok then ');
     L.out('               begin');
     L.out('               DeleteRec := false;');
     L.out('               msg := ''' + dbroot + ' DeleteRec failed. ('''+
                             '+integerstr(err,4)+'')   ''+longintstr(i,6);');
     L.out('               end;');
     L.out('          end;');
     L.out('     end;');
     L.out(' ');
     L.out(' ');
     L.out(' ');
     end;


Procedure MakeMEMOProcs(dbroot : string);
var i, width   : integer;
    rtype      : char;
    tmp,tmp2,tpe    : string[20];
     begin
     if not memoflag then exit;
     L.out(' ');
     L.out('Procedure '+dbroot+'_DBF_object.ReadMemos;');
     L.out('var error,blocks : integer;');
     L.out('var memonum      : longint;');
     L.out('     begin');
     L.out('     error := 0;');
     L.out('     memo1.clear;');
     L.out('     memonum := dbf.dblong(dbf.dbfldno('''+memofield1+'''));');
     L.out('     if memonum > 0 then memofile.fetchN(memonum,memo1,blocks);');
     if memofield2 <> '' then
          begin
          L.out('     memo2.clear;');
          L.out('     memonum := dbf.dblong(dbf.dbfldno('''+memofield2+'''));');
          L.out('     if memonum > 0 then memofile.fetchN(memonum,memo2,blocks);');
          end;
     L.out('     end;');
     L.out(' ');
     L.out(' ');
     end;


Function MakeRoot(path : string) : string;
var s : string;
    i : integer;
     begin
     s := path;
     i := pos('\',s);
     while i > 0 do
          begin
          delete(s,1,i);
          i := pos('\',s);
          end;
     i := pos('.',s);
     if i > 1 then s := leftstr(s,i-1);
     Makeroot := s;
     end;


Procedure MakePas(dbroot : string);
var outfname : string[40];
     begin
     getdir(0,outfname);
     outfname := addbackslash(outfname) + 'x' + dbroot;
     forceext(outfname,'pas');
     writeln('writing to ',outfname);
     L.LISTinit(outfname,OUT_typREWRITE);
     L.LISTopen;

     MakeUnit(dbroot);
     MakeRecType(dbroot);
     MakeObject(dbroot);
     MakeInitProc(dbroot);
     MakeGetPasProc(dbroot);
     MakePutPasProc(dbroot);
     MakeReadWriteProcs(dbroot);
     MakeMEMOProcs(dbroot);
     MakeUnitEnd;

     L.done;
     end;


Procedure DodbPasGen(dbfname : string);
var fn : string[40];
    i  : integer;
    dbroot : string[8];
     begin
     fn := dbfname;
     ForceExt(fn,'dbf');
     writeln('fn ',fn);


     if recname = '' then dbroot := UpCaseStr(MakeRoot(fn))
     else dbroot := UpCaseStr(recname);
     writeln('record name= ',dbroot);
     dbf.init(fn,dbREADONLY);
     if dbf.err = 0 then
          begin
          dbf.dbShowstruc;
          MakePas(dbroot);
          dbf.dbclose;
          if (dbf.err <> 0) then writeln('Error closing dBase file');
          end
     else writeln('Unable to open dBase file: ',fn);
     end;


Procedure dbPasGenInit;
     begin
     memoflag     := false;
     memofield1   := '';
     memofield1no := 0;
     memofield2   := '';
     memofield2no := 0;
     recname := '';
     dbfname := '';
     AddParm(1,'MEMOCONST','500');

     StandardpVarsInit;

     memoconst := GetParmStr('MEMOCONST');
     if paramcount > 0 then dbfname := paramstr(1);
     if paramcount > 1 then recname := paramstr(2);
     end;


     begin
     pProgID := 'dbPasGen 2.32';
     writeln(pProgID, ' - Utility support for DBF object - HNR 11/93');
     dbPasGenInit;
     if dbfname <> '' then
          begin
          DodbPasGen(dbfname);
          end
     else writeln('dBase file name not passed as run parameter.');
     writeln('');
     end.
