{SECTION ..PbTBOX }
UNIT PbTBOX;

INTERFACE

uses PbMISC;

{
Description : Text Line Drawing support

Author      : Howard Richoux
Date        : 1/16/91
Last revised: 1/12/94 some cleanup, still not sure what I wrote
              2/18/94 new libraries
Application : IBM PC and compatibles, done in Turbo Pascal 5.5
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}

var TBOXType  : byte;   { 0 = off, 1 = single,     2 = double
                                   3 = SL noblank, 4 = DL w/blank
                                   default =  3 }
    TBOXchar  : char;   { triggering character             def. '~'  }

Procedure TBOXConvertLine(var line : string);
           {[STRING] Replaces ~ codes with line draw characters}

Procedure TBOXSetChars(i : byte; var lch,mch,rch : char);
           {[STRING] Internal, defines some of the codes}

Function  TBOXMakeBar(loff,len : byte;  lch,mch,rch : char) : string;
           {[STRING] makes a line draw string  ?? }

Function  TBOXMakeBarN(loff,len : byte;  chrset : byte) : string;
           {[STRING] makes a line draw string  ?? }

Function  TBOXMergeStrings(st1,st2 : string; l : byte) : string;
           {[STRING] combines st1 & st2, only where st1 is blank }

{SECTION .zImplementation }
IMPLEMENTATION

{
This is a VERY VERY simple unit to add some IBM graphic character
    Box drawing to an otherwise normal text file.

    The graphics are bracketed by '~' (which optionally get
    translated into blanks).

    see the example TBOXTEST for specifics.    Here is a partial example.

                       This is a Box

Everything         ~L---------M-------R~     Mnemonics:
outside            ~|         |       |~     L = Upper Left
the                ~|         |       |~     M = Upper Middle
squiggles          ~|         |       |~     R = Upper Right
is normal          ~S---------+-------s~     S = Left Side
text.              ~|         |       |~     + = center
                   ~|         |       |~     s = right side
                   ~|         |       |~     l = lower left
                   ~l---------m-------r~     m = lover middle
                                             r = lower right
                   ~1222222222222222223~

}





Function SLCvtChar( ch : char) : char;
var c : char;
     begin
     c := ' ';
     case ch of
         '-'         : c := chr(196);
         '|'         : c := chr(179);
         'L'         : c := chr(218);
         'M'         : c := chr(194);
         'R'         : c := chr(191);
         'S'         : c := chr(195);
         's'         : c := chr(180);
         'l'         : c := chr(192);
         'm'         : c := chr(193);
         'r'         : c := chr(217);
         'C','+','c' : c := chr(197);
         '1'         : c := chr(198);
         '2'         : c := chr(205);
         '3'         : c := chr(181);
          end;
     SLCvtChar := c;
     end;


Function DLCvtChar( ch : char) : char;
var c : char;
     begin
     c := ' ';
     case ch of
         '-'         : c := chr(205);
         '|'         : c := chr(186);
         'L'         : c := chr(201);
         'M'         : c := chr(203);
         'R'         : c := chr(187);
         'S'         : c := chr(204);
         's'         : c := chr(185);
         'l'         : c := chr(200);
         'm'         : c := chr(202);
         'r'         : c := chr(188);
         'C','+','c' : c := chr(206);
         '1'         : c := chr(195);
         '2'         : c := chr(196);
         '3'         : c := chr(180);
          end;
     DLCvtChar := c;
     end;


{SECTION  TBOXConvertLine }
Procedure TBOXConvertLine(var line : string);
var i,j : integer;
    s   : string;
    linemode : boolean;
     begin
     if (TBOXType < 1) then exit;
     s := '';
     linemode := false;
     if length(line) > 0 then
          begin
          for i := 1 to length(line) do
               begin
               if not linemode and (line[i] = '~') then
                    begin
                    linemode := true;
                    if (TBOXType > 2) then s := s + ' ';
                    end
               else if linemode and (line[i] = '~') then
                    begin
                    linemode := false;
                    if (TBOXType > 2) then s := s + ' ';
                    end
               else if linemode then
                    begin
                    if odd(TBOXType)then
                         s := s + SLCvtChar(line[i])
                    else s := s + DLCvtChar(line[i]);
                    end
               else s := s + line[i];
               end;
          end;
     line := s;
     end;



{SECTION  TBOXSetChars }
Procedure TBOXSetChars(i : byte; var lch,mch,rch : char);
     begin
     case i of
         0  : begin  { single bar flat, no end posts}
              lch := chr(196); mch := chr(196); rch := chr(196);
              end;
         1  : begin  { single bars with blanks between }
              lch := chr(179); mch := chr( 32); rch := chr(179);
              end;
         2  : begin  { single bars with single bar between }
              lch := chr(195); mch := chr(196); rch := chr(180);
              end;
         3  : begin  { single bars with double bar between }
              lch := chr(198); mch := chr(205); rch := chr(181);
              end;
         4  : begin  { top of single line box }
              lch := chr(218); mch := chr(196); rch := chr(191);
              end;
         5  : begin  { bottom of single line box }
              lch := chr(192); mch := chr(196); rch := chr(217);
              end;

         { DOUBLE bar things }

         32 : begin  { double bar flat, no end posts}
              lch := chr(205); mch := chr(205); rch := chr(205);
              end;
         33  : begin  {double bars with blanks between }
              lch := chr(186); mch := chr( 32); rch := chr(186);
              end;
         34  : begin  {double bars with double bar between }
              lch := chr(204); mch := chr(205); rch := chr(185);
              end;

         else begin
              lch := chr(195); mch := chr( 40); rch := chr(195);
              end;
         end;
     end;


{SECTION  TBOXMakeBar }
Function  TBOXMakeBar(loff,len : byte;  lch,mch,rch : char) : string;
var s,s1,s2 : string;
    l    : byte;
     begin
     s := ''; s1 := ''; s2 := '';
     l := loff + len;
     if l > 0 then
          begin
          s1 := ConstStr(' ',l);
          s2 := ConstStr(mch,len);
         { writeln('s2 1[',s2,']'); }
          if len > 0 then
               begin
               s2[len] := rch;
               s2[1] := lch;
               end;
         { writeln('s2 2[',s2,']'); }
          if loff > 0 then Replacestr(s1,loff+1,s2)
          else s1 := s2;
          s := leftstr(s1,l);
          end;
     TBOXMakeBar := s;
     end;


{SECTION  TBOXMakeBarN }
Function  TBOXMakeBarN(loff,len : byte;  chrset : byte) : string;
var ch1,ch2,ch3 : char;
     begin
     TBOXSetchars(chrset,ch1,ch2,ch3);
     TBOXMakeBarN := TBOXMakeBar(loff,len,ch1,ch2,ch3);
     end;


{SECTION  TBOXMergeStrings  }
Function  TBOXMergeStrings(st1,st2 : string; l : byte) : string;
{ ST1 takes precedence, need to add more merge logic to join bars }
var s : string;
    i,l1,l2 : byte;
    c1,c2 : char;
     begin
     s := '';
     if l > 0 then
          begin
          l1 := length(st1);
          l2 := length(st2);
          for i := 1 to l do
               begin
               c1 := ' '; c2 := ' ';
               if i <= l1 then c1 := st1[i];
               if i <= l2 then c2 := st2[i];
               if      (c1 <> ' ') then s := s + c1
               else if (c2 <> ' ') then s := s + c2
               else s := s + ' ';
               end;
          s := leftstr(s,l);
          end;
     TBOXMergeStrings := s;
     end;


{SECTION  zzInitialization }
     begin {initialization}
     TBOXType := 3;   { SL no blank }
     TBOXchar     := '~';
     end.

