{SECTION ..PbHIGH }
UNIT PbHIGH;
{$V-}

INTERFACE

USES DOS, PbMISC, PbDATA, PbOBJS;

{-}
{
Description : HNR higher level routines using MISC and OBJS

Author      : Howard Richoux
Date        : 2/18/94
Last revised: 2/18/94 old filescan routines


Application : IBM PC and compatibles, done in Turbo Pascal 7
Status      : Placed in the Public Domain by HNR Software 1/29/1994
Published in: none
}

type  TFILE_ProcessLineProc = procedure( s : string );


Procedure CreateTEXTSectionIndex(fn, sectiontag : string;
                                 var sections : HOLD_object);
            {[FILE] Creates section index for reading sectioned files}

Procedure GetfilesSTRA( Template : string; var files : STRA_object;
                    fsortcode : integer);
             {[FILE] Returns a work list of files from one directory.}

Procedure ReadTEXTfile(fn : string; work : TFILE_ProcessLineProc);
            {[FILE] All-in-one text file reader}

Procedure ReadTEXTSection(fn, sectiontag, sectionname : string;
                          startpos : longint; work : TFILE_ProcessLineProc);
            {[FILE] All-in-one text file SECTION reader}


{SECTION  .ZImplementation }
IMPLEMENTATION


{SECTION  CreateTEXTSectionIndex  }
Procedure CreateTEXTSectionIndex(fn, sectiontag : string;
                                 var sections : HOLD_object);
var secttag,sectname  : string[40];
    sectlen   : integer;
    ok, found : boolean;
    l         : longint;
    s         : string;
    tx        : TFILE_object;
     begin
     found := false;
     secttag  := UpCaseStr(sectiontag);
     sectname := '';
     tx.init(fn,false);
     ok := tx.opened;
     l := 0;
     while ok do
          begin
          ok := tx.fetchnext(s);
          if ok then
               begin
             {  writeln('<',s,'>'); }
               if secttag = leftstr(UpCaseStr(s),length(secttag)) then
                     begin
                     delete(s,1,length(secttag));
                     RemoveLeading(s,' ');
                     s := UpCaseStr(s);
                     sectname := GetLeftstr(s,' ');
                     ok := sections.append(sectname,l);
                    { writeln('[',sectname,',',l,']');}
                     end;
               l := tx.currentposition;
               end;
          end;
     tx.done;
     end;


{SECTION  GetFilesSTRA }
Procedure GetfilesSTRA( Template : string; var files : STRA_object;
                    fSortcode : integer);
var SR : searchrec;
    ok : boolean;
     begin
     FindFirst(Template,AnyFile,SR);
     while DOSError = 0 do
          begin
          if length(sr.name) > 4 then
              begin
              ok := files.append(sr.name);
              end;
          FindNext(SR);
          end;

     if fSortcode = fSortbyName then files.sort;
     end;


{SECTION  ReadTEXTfile  }
Procedure ReadTEXTfile(fn : string; work : TFILE_ProcessLineProc);
var tx : TFILE_object;
    s  : string;
     begin
     tx.init(fn,false);
     while tx.fetchnext(s) do work(s);
     tx.done;
     end;



{SECTION  ReadTEXTSection  }
Procedure ReadTEXTSection(fn, sectiontag, sectionname : string;
                          startpos : longint; work : TFILE_ProcessLineProc);
var secttag,sectname  : string[40];
    sectlen   : integer;
    ok, found : boolean;
    s,s0      : string;
    tx        : TFILE_object;
     begin
     found := false;
     secttag  := UpCaseStr(sectiontag);
     sectname := UpCaseStr(sectionname);
     trim(sectname);
     sectlen  := length(sectname);
     tx.init(fn,false);
     ok := tx.opened;
     if ok and (startpos > 0) then tx.seek(startpos);
     if sectionname = '' then  {name of '' means until first secttag }
          begin
          found := true;
          end;
     while ok do
          begin
          ok := tx.fetchnext(s0);
          s := s0;
          if ok then
               begin
              { if not found then writeln('*<',s,'>');}
               if secttag = leftstr(UpCaseStr(s),length(secttag)) then
                     begin
                     if found then
                          begin
                          found := false;
                          ok := false;
                          end
                     else begin
                          delete(s,1,length(secttag));
                          RemoveLeading(s,' ');
                          if leftstr(UpCaseStr(s),sectlen) = sectname then
                               begin
                               found := true;
                               WORK(s0);   { return the section statement also}
                               end;
                          end;
                     end
               else if found then WORK(s0);
               end;
          end;
     tx.done;
     end;



{SECTION ZInitialization }
     begin  { initializaion }
     end.
