
{SECTION  BFILE_object }
procedure BFILE_object.init(fn : string; recsz,FMode : integer);
var create : boolean;
     begin
     opened   := false;
     filename := fn;
     recsiz   := 1;
     hdrsiz   := 0;
     hdrptr   := NIL;
     err      := 0;
     curr     := -1;  { valid is 0 .. count-1 }
     if (recsz > 0) and (recsz < 4097) then recsiz := recsz;
     create := false;
     if FMode < 0 then create := true
     else              FileMode := FMode;
     BFILE_object.open(filename,create);
     end;


procedure BFILE_object.InitWithHdr(fn : string; recsz,hdsz,FMode : integer);
var create : boolean;
     begin
     opened   := false;
     filename := fn;
     recsiz   := 1;
     hdrptr   := NIL;
     hdrsiz   := 0;
     err      := 0;
     curr     := 0;  { valid is 1 to count }
     create := false;
     if FMode < 0 then create := true
     else              FileMode := FMode;
     if (recsz > 0) and (recsz < 4097)     then recsiz := recsz;
     if (hdsz > 0)  and (hdsz < BFILE_maxheader) then
          begin
          if (MemAvail > BFILE_maxheader) then
               begin
               hdrsiz := hdsz;
               NEW(hdrptr);
               fillchar(hdrptr^,sizeof(BFILE_headerbuf_type),0);
               end;
          end;
     BFILE_object.open(filename,create);
     end;


Procedure BFILE_object.SetHdrSiz  (hdsz : integer);
     begin  { After discovering header size of existing file }
     if hdrptr = NIL then exit;
     if (hdsz > 0) and (hdsz < BFILE_maxheader) then
          begin
          hdrsiz := hdsz;
          ReadHeader;
          curr := 0;   {BOF for fetchnext}
          end
     else begin
          hdrsiz := 0;
          curr := -1;  {BOF for fetchnext}
          end;
     end;


Function BFILE_object.IOResultErrChk : boolean;
var xerr : integer;
     begin
     xerr := IORESULT;
     if err = 0 then err := xerr; { Leave Err alone if non-Zero }
     if xerr <> 0 then
          begin
          writeln(DOSErrStr(xerr),'[',filename,']');
          IOResultErrChk := true;
          end
     else IOResultErrChk := false;
     end;


Function BFILE_object.NoError : boolean;
     begin
     NoError := (err = 0);
     end;


Function  BFILE_object.Count : longint;
var rs,hs : longint;
     begin
     rs := recsiz; hs := hdrsiz;
     count := ((filesize(fil)+1) - hs) div rs;
     end;


Function  BFILE_object.RecAddress(n : longint) : longint;
var rs,hs : longint;
     begin
     rs := recsiz; hs := hdrsiz;
     if hs = 0 then
          RecAddress := n * rs
     else RecAddress := (n-1)*rs + hs;
     end;


Procedure BFILE_object.open(fn : string; create : boolean);
     begin
     if opened then BFILE_object.close;
     assign(fil,fn);
     if create then
          begin {create empty file}
         {$I-} ReWrite(fil,1); {$I+}
          if not IOResultErrChk and (hdrsiz > 0) then
               begin {write empty header}
               UpdateHeader;
               end;
          end
     else begin
          {$I-} Reset(fil,1); {$I+}
          IOResultErrChk;
          if hdrsiz > 0 then ReadHeader;
          end;
     if NoError then opened := true;
     end;


procedure BFILE_object.close;
var l : longint;
    i : integer;
    ok : boolean;
     begin
     if opened then
          begin
         {$I-} SYSTEM.Close(fil); {$I+}
          IOResultErrChk;
          opened := false;
          end;
     end;


procedure BFILE_object.done;
     begin
     if not opened then exit;
     BFILE_object.close;
     end;


procedure BFILE_object.dump;
var l : longint;
    results : integer;
    zbuf : array[1..16] of byte;
     begin
     l := 0;
     if not opened then exit;
     write('Dump of File: ',filename,'   Size:',filesize(fil),
                                       '  Count:',count);
     if hdrsiz > 0 then
          writeln('   Header size:',hdrsiz)
     else writeln('   No header');
     while l < filesize(fil) do
          begin
         {$I-} SYSTEM.seek(fil,l); {$I+}
          IOResultErrChk;
          if NoError then
               begin
               fillchar(zbuf,sizeof(zbuf),0);
              {$I-} SYSTEM.blockread(fil,zbuf,16,results); {$I+}
               IOResultErrChk;
               if NoError then
                   begin
                   writeln(Buf16ToHexStr(l,16,zbuf,true));
                   end;
               end;
          l := l + 16;
          end;
     end;


procedure BFILE_object.SmartDump;
var l : longint;
    results : integer;
    rbuf : array[1..4096] of byte;
    zbuf : array[1..16] of byte;
    i,j,first  : integer;
     begin
     l := 0; first := 0;
     if not opened then exit;
     writeln('SmartDump of File: ',filename,'  Size:',filesize(fil),
             '  HdrSiz:',hdrsiz,'  RecSiz:',recsiz,'  Recs:',count);
     ReadHeader;
     if NoError then
          begin
          first := 1;
          i := 1;
          writeln('Header - size=',hdrsiz);
          while i < hdrsiz do
              begin
              move(hdrptr^[i],zbuf,16);
              writeln(Buf16ToHexStr(i,(hdrsiz-i),zbuf,true));
              i := i + 16;
              end;
          if hdrsiz > 16 then writeln(' ');
          end;
     for j := first to count do
          begin
          fillchar(rbuf,sizeof(rbuf),0);
          fetchN(j,rbuf);
          if NoError then
               begin
               i := 1;
               writeln('Record - ',j,'    size=',recsiz);
               while i < recsiz do
                   begin
                   move(rbuf[i],zbuf,16);
                   writeln(Buf16ToHexStr(i,(recsiz-i),zbuf,true));
                   i := i + 16;
                   end;
               end;
          if recsiz > 16 then writeln(' ');
          end;
     end;


procedure BFILE_object.clearfile;
var fn : string;
     begin
     err := 0;
     fn := filename;
     BFILE_object.close;
     BFILE_object.open(fn,true);      { do a REWRITE }
     end;


procedure BFILE_object.refreshfile;
var fn : string;
     begin
     err := 0;
     fn := filename;
     BFILE_object.close;
     BFILE_object.open(fn,false);      { do a RESET }
     end;



Function  BFILE_object.seekN(n : longint) : boolean;
     begin
     seekN := false;
     if not opened then exit;
     if (hdrsiz > 0) and (n > count) then exit;
     if (hdrsiz = 0) and (n > (count-1)) then exit;
     curr     := n;
     position := RecAddress(curr);
   { writeln('seeking ',curr,'  ',position, '    filesize ',filesize(fil));}
    {$I-} SYSTEM.seek(fil,position); {$I+}
     IOResultErrChk;
     SeekN    := NoError;
     end;


Function BFILE_object.ReadHeader : boolean;
var results : integer;
     begin
     ReadHeader := false;
     if hdrptr = NIL then exit;
     if hdrsiz = 0 then exit;
     if not opened then exit;
    {$I-} SYSTEM.seek(fil,0); {$I+}
     IOResultErrChk;
     if NoError then
          begin
         {$I-} SYSTEM.blockread(fil,hdrptr^,hdrsiz,results); {$I+}
          IOResultErrChk;
          end;
     ReadHeader := NoError;
     end;


Function BFILE_object.UpDateHeader : boolean;
var results : integer;
     begin
     UpDateHeader := false;
     if hdrptr = NIL then exit;
     if hdrsiz = 0 then exit;
     if not opened then exit;
    {$I-} SYSTEM.seek(fil,0); {$I+}
     IOResultErrChk;
     if NoError then
          begin
         {$I-} SYSTEM.blockwrite(fil,hdrptr^,hdrsiz,results); {$I+}
          IOResultErrChk;
          end;
     UpDateHeader := NoError;
     end;



Function  BFILE_object.storeN(n : longint; var rec) : boolean;
var results : integer;
    ok      : boolean;
     begin
     StoreN := false;
     if not opened then exit;
     err := 0;
     ok  := false;
     if n >= count then
          begin
          position := RecAddress(n);
         {$I-} SYSTEM.seek(fil,position); {$I+}
          ok := not IOResultErrChk;
          end
     else if ((hdrsiz > 0) and (n < 1)) or (n < 0) then
          begin
          ok := false;
          position := 0;
          curr := 0;
          end
     else ok := seekN(n);
     if ok then
          begin
         {$I-} SYSTEM.blockwrite(fil,rec,recsiz,results); {$I+}
          storeN := IOResultErrChk;
          end;
     storeN := NoError;
     end;


Function  BFILE_object.append(var rec) : boolean;
var results : integer;
     begin
     append := false;
     if not opened then exit;
     err := 0;
     append := storen(count,rec);
     end;


function BFILE_object.fetchN(n : longint; var rec) : boolean;
var results : integer;
var ok : boolean;
     begin
     fillchar(rec,recsiz,0);
     fetchN := false;
     if not opened then exit;
     err := 0;
     if seekN(n) then
          begin
         {$I-} SYSTEM.blockread(fil,rec,recsiz,results); {$I+}
          IOResultErrChk;
          end
     else err := BFILE_Bad_Recnum_ERR;
     fetchN := NoError;
     end;


Function BFILE_object.fetchnext(var rec) : boolean;
var n  : integer;
     begin
     fetchnext := false;
     if not opened then exit;
     err := 0;
     n := curr;
     inc(n);
     fetchnext := fetchn(n,rec);
     end;



Procedure BFILE_object.export (fn : string; workproc : BFILE_RecToStringproc;
                              var rec; purgedata : boolean);
var TEXTF : TEXT;
    s   : string;
    ok  : boolean;
    i : integer;
     begin
     if not opened then exit;
     err := 0;
     SYSTEM.assign(TEXTF, fn);
     {$I-} SYSTEM.rewrite(TEXTF);  {$I+}
     if IOResultErrChk then exit;
     curr := 0;
     while ok do
         begin
         ok := BFILE_object.fetchnext(rec);
         if ok then
              begin
              workproc(rec,s);
              writeln('exported  ',curr:3,' [',s,']');
              {$I-} SYSTEM.writeln(TEXTF,s); {$I+}
              end;
         end;
     {$I-} SYSTEM.Close(TEXTF); {$I+}
     ok := not IOResultErrChk;
     end;


Procedure BFILE_object.import (fn : string; workproc : BFILE_StringToRecproc;
                              var rec; purgedata : boolean);
var TEXTF : TEXT;
    s   : string;
    ok  : boolean;
    i : integer;
     begin
     if not opened then exit;
     err := 0;
     SYSTEM.assign(TEXTF, fn);
     {$I-} SYSTEM.reset(TEXTF);  {$I+}
     ok := not IOResultErrChk;
     if not ok then exit;
     while not EOF(TEXTF) do
          begin
          readln(TEXTF,s);
          if s <> '' then
               begin
               workproc(s,rec);
               BFILE_object.storen(-1,rec);
               end;
          end;
     {$I-} SYSTEM.Close(TEXTF); {$I+}
     ok := not IOResultErrChk;
     BFILE_object.refreshfile;
     end;

