

Function MyOpenFileExisting(var fvar : file; fname : string;
                recsize, fmode : integer; var error : integer) : boolean;
     begin
     MyOpenFileExisting := false;
     if not FileExists(fname) then
          begin
          writeln('File not found [',fname,']');
          exit;
          end;
    { writeln('file found [',fname,']');}
     FileMode := fmode;
     assign(fvar,fname);
{$I-} reset(fvar,recsize); {$I+}
     error := IOResult;
     if error <> 0 then
          begin
          writeln('Unable to open file [',fname,']  error=',error);
          exit;
          end;
     MyOpenFileExisting := true;
     end;



Function MyOpenFileCreate(var fvar : file; fname : string;
                            recsize : integer; var error : integer) : boolean;
{ MUST NOT exist already }
     begin
     MyOpenFileCreate := false;
     if FileExists(fname) then
          begin
          writeln('Error - File already exists [',fname,']');
          exit;
          end;
    { writeln('file not found [',fname,']');}
     FileMode := 2;
     assign(fvar,fname);
{$I-} rewrite(fvar,recsize); {$I+}
     error := IOResult;
     if error <> 0 then
          begin
          writeln('Unable to create file [',fname,']  error=',error);
          exit;
          end;
     MyOpenFileCreate := true;
     end;


Function MyBlockRead(var fvar : file; var buf; count : integer;
                     var numread, error : integer) : boolean;
var mycount : integer;
    mybuf : array[1..4096] of char;
     begin
     MyBlockRead := false;
     error := 0;
     mycount := min(count,sizeof(mybuf));
     fillchar(mybuf,mycount,0);
{$I-} blockread(fvar,mybuf,mycount,numread); {$I+}
     error := IOResult;
     if (error <> 0) then
          begin
          writeln('MyBlockRead error=',error, '  numread=',numread);
          exit;
          end;
     move(mybuf,buf,numread);
     MyBlockRead := true;
     end;


Function MyBlockWrite(var fvar : file; var buf; count : integer;
                     var numwritten,error : integer) : boolean;
     begin
     MyBlockWrite := false;
     error := 0;
     numwritten := 0;
{$I-} blockwrite(fvar,buf,count,numwritten); {$I+}
     error := IOResult;
     if (error <> 0) then
          begin
          writeln('MyBlockWrite error=',error,'   numwritten=',numwritten);
          exit;
          end;
     MyBlockwrite := true;
     end;


Function MyCloseFile(var fvar : file; var error : integer) : boolean;
     begin
     MyCloseFile := false;
     error := 0;
{$I-} Close(fvar); {$I+}
     error := IOResult;
     if (error <> 0) then
          begin
          writeln('MyCloseFile error=',error);
          exit;
          end;
     MyCloseFile := true;
     end;


Function MySeek(var fvar : file; n : longint; var error : integer) : boolean;
     begin
     MySeek := false;
     error := 0;
{$I-} Seek(fvar,n); {$I+}
     error := IOResult;
     if (error <> 0) then
          begin
          writeln('MySeek error=',error);
          exit;
          end;
     MySeek := true;
     end;



{SECTION  TextPos }
{Note: code uses a 'TEXTREC' type  which must be in DOS (check it out)}

type wordrec = record low,high:word; end;

Function actualfilepos(var f:text):longint;
var reg         : registers;
    templong    : longint;
     begin
     with reg do
          begin
          ah := $42;
          al := 1;
          bx := textrec(f).handle;
          cx := 0;
          dx := 0;
          msdos(reg);
          wordrec(templong).high := dx;
          wordrec(templong).low := ax;
          end;
     actualfilepos := templong;
     end;


Function TextPos(var f:text):longint;
     begin
{     TextPos := actualfilepos(f) - textrec(f).bufsize + textrec(f).bufpos;
  Cantlon's algorithm didn't work for the first buffer - hnr 12/90
  this algorithm works fine for sequential file reading, but putting in
  a textseek screws this up.  Maybe fix it later. 1/94 hnr
}
{     writeln('TextPos   actual=',(actualfilepos(f)-1),
                    '  bufsize=',textrec(f).bufsize,
                    '  bufpos=',textrec(f).bufpos);  }

     TextPos := (((actualfilepos(f)-1) div textrec(f).bufsize) *
                         textrec(f).bufsize)    + textrec(f).bufpos;
     end;



{SECTION  TextSeek }
{* TurboPower equivalent calls, so I don't have to change code *}
{Note: code uses a 'TEXTREC' type  which must be in DOS (check it out)}

Function TextSeek(var f:text; n:longint) : boolean;
var reg         : registers;
    c           : char;
     begin
     if n < 0 then n := 0;
     with reg do
          begin
          ah := $42;
          al := 0;
          bx := textrec(f).handle;
          cx := wordrec(n).high;
          dx := wordrec(n).low;
          msdos(reg);
          end;
     textrec(f).bufpos := textrec(f).bufend;
     read(f,c);
     textrec(f).bufpos := 0;
     TextSeek := true;  { have to figure out error return - hnr 12/90}
                        { seek past eof is error }
     end;



{SECTION  FmtFileInfo  }
Function  FmtFileInfo(fname,ext : string) : string;
                    {[FILE] gets info and formats it}
var SR : searchrec;
     begin
     fileinfo(fname,ext,SR);
     FmtFileInfo := FmtSearchRec(SR);
     end;



{SECTION FmtSearchRec }
Function FmtSearchRec(SR : SearchRec) : string;
var s : string[35];
    dt : datetime;
    i : integer;
     begin
     s := leftstr(SR.name,12);
     i := 13; replacestr(s,i,longintstr(SR.size,8));
     i := 23; replacestr(s,i,leftstr(FmtPTimeStr(SR.time),14));
     FmtSearchRec := s;
     end;


{SECTION FmtSearchRecK   }
Function FmtSearchRecK(SR : SearchRec) : string;
var s : string[35];
    dt : datetime;
    i : integer;
     begin
     s := leftstr(SR.name,12);
     if SR.size < 2048 then SR.size := 2048;
     i := 13; replacestr(s,i,rightstr(FmtKstrComma((SR.size)),7));
     i := 22; replacestr(s,i,leftstr(FmtPTimeStr(SR.time),14));
     FmtSearchRecK := s;
     end;


{SECTION  FullFmtFileInfo  }
Function  FullFmtFileInfo(fname,ext : string; p : pathstr) : string;
                    {[FILE] gets info and formats it(FULL PATH)}
var fn : string;
    SR : searchrec;
     begin
     fn := fname;
     fn := addbackslash(p)+fn;
     fileinfo(fn,ext,SR);
     FullFmtFileInfo := FullFmtSearchRec(SR,p);
     end;


{SECTION  FullFmtSearchRec }
Function  FullFmtSearchRec(SR : SearchRec; p : pathstr) : string;
var s,s1 : string;
     begin
     s1 := FmtSearchRec(SR);
     delete(s1,1,12);
     s := p + SR.name;
     replacestr(s,40,' '+s1);
     FullFmtSearchRec := s;
     end;


{SECTION  FullFmtSearchRecK  }
Function  FullFmtSearchRecK(SR : SearchRec; p : pathstr) : string;
var s,s1 : string;
     begin
     s1 := FmtSearchRecK(SR);
     delete(s1,1,12);
     s := p + SR.name;
     replacestr(s,40,' '+s1);
     FullFmtSearchRecK := s;
     end;


{SECTION  SearchEngine }
{ hnr note - started with anonymous pd code called ENGINE
             obtained from EMS shareware

 SEARCH ENGINE
        Input Parameters:
              Mask  : The file specification to search for
                      May contain wildcards
              Attr  : File attribute to search for
              Proc  : Procedure to process each found file

        Output Parameters:
              ErrorCode  : Contains the final error code.
}

VAR EngineMask : FSCAN_FullNameStr;
    EngineAttr : Byte;
    EngineProc : FSCAN_ProcType;
    EngineCode : Byte;


Procedure SearchEngine(Mask : PathStr; Attr : Byte; Proc : FSCAN_ProcType;
                       VAR ErrorCode : Byte);
VAR S : SearchRec;
    P : PathStr;
    Ext : ExtStr;

     begin
     FSplit(Mask, P, Mask, Ext);
     Mask := Mask + Ext;
     FindFirst(P + Mask, Attr, S);
     if DosError <> 0 then
          begin
          ErrorCode := DosError;
          Exit;
          end;

     while DosError = 0 do
          begin
          Proc(S, P);
          FindNext(S);
          end;
     if DosError = 18 then ErrorCode := 0
     ELSE ErrorCode := DosError;
     end;


{SECTION  SearchEngineAll  }
Procedure SearchEngineAll(path : PathStr; Mask : FSCAN_FullNameStr; Attr : Byte;
                          Proc : FSCAN_ProcType; VAR ErrorCode : Byte);

     begin
     (* Set up Unit global variables for use in recursive directory search Procedure *)
     EngineMask := Mask;
     EngineProc := Proc;
     EngineAttr := Attr;
     SearchEngine(path + Mask, Attr, Proc, ErrorCode);
     SearchEngine(path + '*.*', Directory OR Attr, SESearchOneDir, ErrorCode);
     ErrorCode := EngineCode;
     end;


{SECTION  SESearchOneDir  }
{$F+}
Procedure SESearchOneDir(VAR S : SearchRec; P : PathStr);
{$F-}                        {Recursive Procedure to search one directory}
     begin
     if SEGoodDirectory(S) then
          begin
          P := P + S.name;
          SearchEngine(P + '\' + EngineMask, EngineAttr, EngineProc, EngineCode);
          SearchEngine(P + '\*.*',Directory OR Archive, SESearchOneDir, EngineCode);
          end;
     end;


{SECTION  SEErrorMessage  }
Procedure SEErrorMessage(ErrCode : Byte);
     begin
     CASE ErrCode OF
          0    : ;                              {OK -- no error}
          2    : WriteLn(' 2 File not found');
          3    : WriteLn(' 3 Path not found');
          5    : WriteLn(' 5 Access denied');
          6    : WriteLn(' 6 Invalid handle');
          8    : WriteLn(' 8 Not enough memory');
          10   : WriteLn(' 10 Invalid environment');
          11   : WriteLn(' 11 Invalid format');
          18   : ;                              {OK -- merely no more files}
          ELSE WriteLN('ERROR #', ErrCode);
          end;
     end;



{SECTION  SEGoodDirectory }
Function  SEGoodDirectory(S : SearchRec) : Boolean;
     begin
     SEGoodDirectory := (S.name <> '.') AND (S.name <> '..') AND
                      (S.Attr AND Directory = Directory);
     end;
