PROGRAM MAKEMEMO;

{$M 20000,0,655000}

Uses DOS, PbMISC, PbDATA, PbOBJS, PbHIGH, PbPARMS, PbOUT0,
          PbDBOBJ, PbMEMO, PbDBLIB;

{
Description : Takes sectioned file and produces simple DBF and MEMO files

Author      : Howard Richoux
Date        : 12/20/93
Last revised: 12/25/93 hnr PbOUT output
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

DBF file is probably of the form(specified by DBFSPEC):
   FILENAME   C12
   FILEDATE   Date
   FILEEOF    N8.0
   SECTNAME   C24
   LINES      N5
   TEXT       Memo

Config Parameters        meaning                    default
DBFNAME=<fname>          create <fname>             TEST.DBF
                                                    TEST.DBT
DBFSPEC=[...]            dbf field specifications
  [FILENAME(C12),FILEDATE(D),FILEEOF(N8.0),SECTNAME(C24),LINES(N5),TEXT(M)]

}


var DBF      : DBF_object;
    MEMOFILE : MEMO_object;
    MEMO     : STRA_object;

var dbfname : string;    { Name of DBF file  }
    memname : string;    { Name of MEMO file }
    dbfspec : string;    { DBF fields }
    secttag : string;    { text file section designator }
    err     : integer;   { general use }

var workspec : string;
    worklist : STRA_object;


var filename : string;
    fileeof  : longint;
    filedate : string;
    sectname : string;
    lines    : integer;
    sr       : searchrec;

{*****************************************************************}


Procedure SetFileInfo(fname : string);
var err : integer;
     begin
     sectname   := '<none>';
     filedate   := '19931231';
     fileeof    := 9999;
     filename   := '<filename>';
     err := FileInfo(fname,'',sr);
     if err = 0 then
          begin
          filedate   := PTimeToDBase(sr.time);
          fileeof    := sr.size;
          filename   := sr.name;
          end;
     end;


Function AddDBFRecord(var D : DBF_object;
                  fname,sname,fdate : string; eof,mnum : longint):boolean;
var i,err : integer;
    ok    : boolean;
     begin
     D.dbf.dbcleardbbuf;
     i := D.dbf.dbfldno('FILENAME');
     if i > 0 then D.dbf.dbputstr(i,fname);
     i := D.dbf.dbfldno('SECTNAME');
     if i > 0 then D.dbf.dbputstr(i,sname);
     i := D.dbf.dbfldno('FILEDATE');
     if i > 0 then D.dbf.dbputdate(i,fdate);
     i := D.dbf.dbfldno('FILEEOF');
     if i > 0 then D.dbf.dbputlong(i,eof);
     i := D.dbf.dbfldno('LINES');
     if i > 0 then D.dbf.dbputint(i,lines);
     i := D.dbf.dbfldno('TEXT');
     if i > 0 then D.dbf.dbputlong(i,mnum);
     ok := D.dbf.dbappend;
     if ok then writeln('DBF record added ok.',sname)
     else       writeln('DBF record add ERR  ',sname,'  ',err);
     end;


Function CreateDBFfile : boolean;
     begin
     CreateDBFfile := true;
     writeln('dbfname: ',dbfname);
     writeln('dbfspec: ',dbfspec);
     if not DBFCreateFile(dbfname,dbfspec,err) then
          begin
          writeln('Create error ',err);
          CreateDBFfile := false;
          end
     else begin
          DBF.init(dbfname,0,fREADWRITE);
          if DBF.opened then writeln('DBF opened')
          else writeln('DBF open err ',dbf.err);
          end;
     end;


Function CreateMEMOfile : boolean;
     begin
     CreateMEMOfile := true;
     if fileexists(memname) then
          begin
          writeln('MEMO file already exists [',memname,']');
          exit;
          end;
     writeln('Creating memoname: ',memname);
     MEMOFILE.init(memname,fCREATE);
     MEMOFILE.done;
     if not fileexists(memname) then
          begin
          writeln('MEMO file not found - Create error ',err);
          CreateMEMOfile := false;
          end
     else begin
          MEMOFILE.init(memname,fREADWRITE);
          if MEMOFILE.NoError then writeln('MEMO created ok.');
          end;
     end;


Procedure HandleMEMO(var memo : STRA_object);
var ndx : longint;
    blocks : integer;
     begin
     ndx := -1;
     blocks := 0;
     MEMOFILE.append(MEMO,ndx,blocks);
    { writeln('After MEMO appending at ',ndx,'  ',blocks);}
     lines := MEMO.count;
     MEMO.append(chr($1A)); {end of MEMO}
     if not AddDBFRecord(DBF,filename,sectname,filedate,
                              fileeof,ndx) then
          begin
          writeln('AddDBFRecord failed.');
          end;
     MEMO.done;
     end;


Procedure ProcessLine(str : string);
var s : string;
     begin
     s := str;
     if secttag = UpCaseStr(leftstr(s,length(secttag))) then
          begin
          if MEMO.count > 0 then HandleMEMO(MEMO);
          MEMO.init(1000);
          delete(s,1,length(secttag));
          sectname := GetLeftStr(s,' ');
          sectname := UpCaseStr(sectname);
          end;
     MEMO.append(str+chr($0D)+chr($8A));
     end;


Function OpenOrCreateFiles : boolean;
     begin
     OpenOrCreateFiles := true;
     if DBFValidDBFfile(dbfname) then
          begin
          DBF.init(dbfname,0,fREADWRITE);
          if DBF.opened then writeln('DBF opened')
          else writeln('DBF open err ',dbf.err);
          end
     else if not CreateDBFfile then  OpenOrCreateFiles := false;
     if fileExists(memname) then
          begin
          writeln('MEMO file exists');
          MEMOFILE.init(memname,fREADWRITE);
          if not MEMOFILE.opened then OpenOrCreateFiles := false;
          writeln('MEMO records ',memofile.count);
          end
     else if not CreateMEMOfile then OpenOrCreateFiles := false;
     end;


Procedure ProcessFile(fname : string);      { Initialization is over, do some work.}
     begin
     pCurrFName := fname;
     if not FileExists(pCurrFName) then
          begin
          writeln('Input file does not exist [',pCurrFName,']');
          exit;
          end;
     if OpenOrCreateFiles then
          begin
        {  OutPause; }
          SetFileInfo(pCurrFName);
          writeln('secttag [',secttag,']');
          MEMO.init(1000);    { holding spot for memos }
          ReadTEXTFile(pCurrFName,Processline);
          if MEMO.count > 0 then HandleMEMO(MEMO);
          MEMOFILE.done;
          DBF.done;
          end;
     end;


Procedure GoOn;
var i : integer;
     begin
     for i := 1 to worklist.count do
           ProcessFile(worklist.fetchN(i));
     end;


Procedure Init;
var s : string;
     begin
     AddParm(1,'SECTTAG','{SECTION');
     AddParm(1,'DBFNAME','TEST.DBF');
     AddParm(1,'DBFSPEC',
      '[FILENAME(C12),FILEDATE(D),FILEEOF(N8.0),SECTNAME(C24),LINES(N5),TEXT(M)]');

     StandardOUTInit;                    { also calls StandardpVarsInit }

     dbfname := GetParmStr('DBFNAME');
     dbfspec := GetParmStr('DBFSPEC');
     memname := dbfname;
     ForceExt(memname,'DBT');
     secttag := UpCaseStr(GetParmStr('SECTTAG'));

     worklist.init(100);
     if paramcount > 0 then
          begin
          workspec := UpCaseStr(paramstr(1));
          GetFilesSTRA(workspec,worklist,fsortbyname);
          worklist.dump;
          end;
     end;



(*  Main program *)
     BEGIN
     pProgID := 'MAKEMEMO 1.00';
     Init;

     if worklist.count > 0 then
          begin
          GoOn;
          end
     else begin
          writeln('** No input file(s) specified. [',workspec,']');
          ShowDocFile;
          end;
     OUTdone;
     end.


