PROGRAM COMPILE;

{$M 15000,0,25000}

Uses PbMISC, PbDATA, PbOBJS, PbPARMS, PbOUT0;

{
Description : Compiles a bunch of files at once, reports failures

Author      : Howard Richoux
Date        : 12/20/93
Last revised: 12/25/93 hnr 1.02 PbOUT output
               2/18/94 HNR 1.04 NEW LIBRARIES
Application : IBM PC and compatibles, done in Turbo Pascal 7.0
Status      : Placed in the Public Domain by HNR Software 1/29/94
Published in: none

Config Parameters        meaning
MINSIZEK=100             100k bytes        demo param, not used

}


var srclistname : string;
var srclist     : HOLD_object;


{*****************************************************************}

Procedure GoOn;      { Initialization is over, do some work.}
var fn : string;
    i,err, failed,good  : integer;
    ok             : boolean;
    longerr        : longint;
     begin
     err := 0; failed := 0; good := 0;
     srclist.init(100);
     srclist.load(srclistname);
     for i := 1 to srclist.count do
          begin
          fn := srclist.fetchstrN(i);
          forceext(fn,'pas');
          ok := TPC(fn,'',err);
          if err <> 0 then inc(failed)
          else inc(good);
          ok := srclist.storeN(i,fn,err);
          end;
     OUT(' ');
     OUT(integerstr(good,3)+'  Compiles OK. ');
     if failed = 0 then
          begin
          OUT('     All files compiled OK  '+integerstr(srclist.count,3));
          end
     else begin
          OUT(integerstr(failed,3)+'  Compiles failed. ');
          OUT('     The first failure was: ');
          i := 1;
          while i < srclist.count do
              begin
              ok := srclist.fetchN(i,fn,longerr);
              if longerr <> 0 then
                   begin
                   ok := srclist.fetchN(i,fn,longerr);
                   OUT('     '+fn+'  '+longintstr(longerr,4));
                   ok := TPC(fn,'',err);
                   i := 9999;
                   end;
              inc(i);
              end;
          end;
     end;


Procedure Init;
var s : string;
    begin

    StandardOUTInit;                    { also calls StandardpVarsInit }
    srclistname := 'compile.cmd';
    if paramcount > 0 then
         begin
         srclistname := paramstr(1);
         RemoveLeading(srclistname,'@');
         end;
    end;


(*  Main program *)
    BEGIN
    pProgID := 'Compile 1.04';
    Init;
    GoOn;
    OUTdone;
    end.


