{ Fido Pascal Conference  PASCAL 
Msg  : 339 of 373                                                               
From : Wilbert van Leijen                  2:281/256.14         24 Jun 93  20:14 
To   : Ian Chapman                         1:250/322.0                           
Subj : Code For Program                                                       

17 Jun 93, Ian Chapman writes to All:

 IC> If I have run my program ("IFP.EXE") and then shell to DOS in it, which is
 IC> one of the features, and then run "IFP.EXE" again it will say "Cannot Load
 IC> iNFiNiPLEX More Than Once!".

 IC>  My program is called iNFiNiPLEX just to let you know

The name of the program doesn't matter.  Technique: set a flag using an
interrupt handler, just like almost any TSR does in order to thwart an attempt 
to install a memory resident program twice.}

Program OnlyOnce;
uses Dos;

{$M 4096, 0, 0 }

Var
  Int16Vector : Pointer;

{ Using INT 16h: a handler is always present, not as crowdy as INT 2Fh }

Procedure Int16Handler; Assembler;

ASM
        CMP    AX, 'hi'
        JNE    @1
        MOV    AX, 'HI'
        RETF   2           { preserve flags when using INT 16h }

@1:     PUSH   DS
        PUSH   AX
        MOV    AX, SEG @Data
        MOV    DS, AX
        POP    AX
        PUSHF
        CALL   [Int16Vector]
        POP    DS
        RETF   2
end;

Function CopyinMemory : Boolean; Assembler;

ASM
        MOV   AX, 'hi'
        INT   16h
        CMP   AX, 'HI'
        JE    @1
        MOV   AL, False
        JMP   @2
@1:     MOV   AL, True
@2:
end;

Begin
  GetIntVec($16, Int16Vector);
  If CopyInMemory Then
    WriteLn('Refusing to load ONLYONCE twice.')
  Else
    Begin
      SetIntVec($16, @Int16Handler);
      WriteLn('Now shelling to DOS...  Type EXIT to return');
      WriteLn('And do try to run ONLYONCE now!');
      Exec(GetEnv('COMSPEC'), '');
      WriteLn('Back from DOS, terminating ONLYONCE normally.');
      SetIntVec($16, Int16Vector);
    end;
end.