{ Fido Pascal Conference  PASCAL 
Msg  : 446 of 457                                                               
From : Mark Stephen                        1:2607/102.0         08 Jul 93  13:20 
To   : David Drzyzga                                                             
Subj : Encryption                                                             

DD>Thaere hasn't been much on this subject for the last couple of weeks, but he
DD>is an encryption/decryption scheme that would be very difficult to crack:

Knowing the algorithm _and_ the random number generator (RNG), it's no
trouble at all to crack it. The following code (mainly yours, the rest
obvious) correctly identified the password 111222 in some encrypted text
in a couple of minutes.

Ray Gardner posted some clever code in the C echo which will crack most
any xor-encryption scheme provided the message is sufficiently long and
the password is sufficiently short. I don't know the period of your RNG,
but there is probably a trade-off between a long period and using a
well-known RNG -- either Gardner gets you, or brute force and a copy of
Knuth does. There is a RNG known as the r250 algorithm, which is seeded
with a random array of numbers, themselves generated by something
simpler like your RNG. R250 has a period of 2^255 (I think). Suppose you
allowed the user to specify not only the seed but also the increment and
multiplier in your RNG. You'd probably end up with a rotten RNG, but you
only need 250 numbers, so who cares. Now you have a monstrously long
period, and a brute force approach must try 2^96 rather than 2^32
numbers -- still feasible, but a serious nuisance. Better yet, conceal
the details of your algorithm.

FWIW (and sorry to mess with your exemplary programming style):}

program findpw;

uses
  crt;
const bufsize = 128;
      tval = 120;               (* about bufsize * 0.95 *)
var
  Index,
  UserKey, jj : longint;
  NumRead     : word;
  InFile      : file;
  InFileName  : string[79];
  Ch          : char;
  ii, Error   : integer;
  Buf         : array [1..bufsize] of char;

function crypt(ch:char):char;
var
  UserKey_byte : byte;
begin
  UserKey_byte := UserKey shr 24;
  crypt := chr(ord(ch) xor ord(UserKey_byte));
  UserKey := $63C5 * UserKey + $A561;
  {The two constants above can be changed but must be prime #s}
end;

begin
  clrscr;
  write('Enter FileName to En/Decrypt: ');
  readln(InFileName);
  assign(InFile, InFileName);
  reset(InFile,1);

  writeln(#10#13'Testing possible passwords ...');
  blockread(InFile, Buf, Bufsize, NumRead);
  for jj := 1 to MAXLONGINT do begin
    userkey := jj;
    ii := 0;
    for Index := 1 to NumRead do begin
      ch := crypt(Buf1[Index]);
      (* count printable chars, make sure full boolean evaluation is OFF *)
      if (ch < #128) and (ch > #31) and (ch <> #8)
          and (ch <> #10) and (ch <> #13) then
        inc(ii);
    end;
    if ii > tval then begin
      writeln('password was probably ', jj);
      break;
    end;
  end;
  close(InFile);
end.