{ Fido Pascal Conference  PASCAL 
Msg  : 377 of 394                                                               
From : Laurent Chartinier                  2:325/1.0            30 Jun 93  14:22 
To   : Dustin Nulf                                                               
Subj : .voc Soundblaster     1/5                                              

Laurent M.CHARTINIER wrote to Dustin NULF

DN>Does anyone know where I can find some Soundblaster pascal source that will
DN>let me read in .VOC files?  I have something called TPSBK100.ZIP, but I can'
DN>get it to work...(supposively the wrong DMA channel, or something to do with
DN>the hardware that I can't figure out).  Any help
DN>would be greatly appreciated!  Thanks in advance...

I find a unit to work with CreativeLabs VOC file :}


UNIT VOCTOOL;
{
 ********************************************************************
 ********************************************************************

}
INTERFACE

TYPE
   VOCFileTyp = File;

CONST
   VOCToolVersion  = 'v1.5';  { Num of version unit VOCTOOL }
   VOCBreakEnd     = 0;       { Loop Interrupt constant }
   VOCBreakNow     = 1;       { Loop Interrupt constant }

VAR
   VOCStatusWord        : WORD;   { Sound-Blaster-Status  }
   VOCErrStat           : WORD;   { N error driver }
   VOCFileHeader        : STRING; { CreativeLabs Header = CT}
   VOCFileHeaderLength  : BYTE;     { Length of Header CT }
   VOCPaused            : BOOLEAN;  { Flag Voice-Pause    }
   VOCDriverInstalled   : BOOLEAN;  { Flag Driver Ok      }
   VOCDriverVersion     : WORD;     { Num of version of Driver     }
   VOCPtrToDriver       : Pointer;  { Pointer on Driver in memory }
   OldExitProc          : Pointer;  { Pointer on old Unit-ExitProc }


PROCEDURE PrintVOCErrMessage;
FUNCTION  VOCGetBuffer(VAR VoiceBuff : Pointer; Voicefile : STRING):BOOLEAN;
FUNCTION  VOCFreeBuffer(VAR VoiceBuff : Pointer):BOOLEAN;
FUNCTION  VOCGetVersion:WORD;
PROCEDURE VOCSetPort(PortNumber : WORD);
PROCEDURE VOCSetIRQ(IRQNumber : WORD);
FUNCTION  VOCInitDriver:BOOLEAN;
PROCEDURE VOCDeInstallDriver;
PROCEDURE VOCSetSpeaker(OnOff:BOOLEAN);
PROCEDURE VOCOutput(BufferAddress : Pointer);
PROCEDURE VOCOutputLoop (BufferAddress : Pointer);
PROCEDURE VOCStop;
PROCEDURE VOCPause;
PROCEDURE VOCContinue;
PROCEDURE VOCBreakLoop(BreakMode : WORD);

IMPLEMENTATION

USES DOS,Crt;

TYPE
   TypeCastType = ARRAY [0..6000] of Char;

VAR
   Regs : Registers;

PROCEDURE PrintVOCErrMessage;
{
}
BEGIN
   CASE VOCErrStat OF
      100 : Write(' Driver CT-VOICE.DRV not find ');
      110 : Write(' Not enougth memory for driver ');
      120 : Write(' Bad Driver ');

      200 : Write(' Voc File not found ');
      210 : Write(' Not enougth memory for VOC file ');
      220 : Write(' This file is not a VOC file ');

      300 : Write(' Implementation Memory Error ');

      400 : Write(' Sound Blaster Card not found ');
      410 : Write(' Bad Port Address ');
      420 : Write(' Interrupt not valid ');

      500 : Write(' No run in time ');
      510 : Write(' No Data works actually ');
      520 : Write(' No Data Stopped ');
      END;
   END;

FUNCTION Exists (Filename : STRING):BOOLEAN;
{
}
VAR
   F : File;
BEGIN
   Assign(F,Filename);
{$I-}
   Reset(F);
   Close(F);
{$I+}
   Exists := (IoResult = 0) AND (Filename <> '');
   END;

PROCEDURE AllocateMem (VAR Pt : Pointer; Size : LongInt);
{

}
VAR
   SizeIntern : WORD;
BEGIN
   Inc(Size,15);
   SizeIntern := (Size shr 4);
   Regs.AH := $48;
   Regs.BX := SizeIntern;
   MsDos(Regs);
   IF (Regs.BX <> SizeIntern) THEN Pt := NIL
   ELSE Pt := Ptr(Regs.AX,0);
END;

FUNCTION  CheckFreeMem (VAR VoiceBuff : Pointer; VoiceSize : LongInt):BOOLEAN;
BEGIN
   AllocateMem(VoiceBuff,VoiceSize);
   CheckFreeMem := VoiceBuff <> NIL;
   END;

FUNCTION  VOCGetBuffer (VAR VoiceBuff : Pointer; Voicefile : STRING):BOOLEAN;
{
}
VAR
   SampleSize : LongInt;
   FPresent   : BOOLEAN;
   VFile      : VOCFileTyp;
   Segs       : WORD;
   Read       : WORD;

BEGIN
   FPresent := Exists(VoiceFile);

{ VOC File not found }
   IF Not(FPresent) THEN BEGIN
      VOCGetBuffer := FALSE;
      VOCErrStat   := 200;
      EXIT
      END;

   Assign(VFile,Voicefile);
   Reset(VFile,1);
   SampleSize := Filesize(VFile);
   AllocateMem(VoiceBuff,SampleSize);

{ Not enougth memory for VOC file }
   IF (VoiceBuff = NIL) THEN BEGIN
      Close(VFile);
      VOCGetBuffer := FALSE;
      VOCErrStat   := 210;
      EXIT;
      END;

   Segs := 0;
   REPEAT
      Blockread(VFile,Ptr(seg(VoiceBuff^)+4096*Segs,Ofs(VoiceBuff^))^,$FFFF,Rea
      Inc(Segs);
      UNTIL Read = 0;
   Close(VFile);

{ Le fichier n'est pas au format VOC }
   IF (TypeCastType(VoiceBuff^)[0]<>'C') OR
      (TypeCastType(VoiceBuff^)[1]<>'r') THEN BEGIN
      VOCGetBuffer := FALSE;
      VOCErrStat := 220;
      EXIT;
      END;

{ Load Ok }
   VOCGetBuffer := TRUE;
   VOCErrStat   := 0;

{ Read Length Header }
   VOCFileHeaderLength := Ord(TypeCastType(VoiceBuff^)[20]);
   END;

FUNCTION VOCFreeBuffer (VAR VoiceBuff : Pointer):BOOLEAN;
{
}
BEGIN
   Regs.AH := $49;
   Regs.ES := seg(VoiceBuff^);
   MsDos(Regs);
   VOCFreeBuffer := TRUE;
   IF (Regs.AX = 7) OR (Regs.AX = 9) THEN BEGIN
      VOCFreeBuffer := FALSE;
      END;
   END;

FUNCTION VOCGetVersion:WORD;
{
}
VAR
   VDummy : WORD;
BEGIN
   ASM
      MOV       BX,0
      CALL      VOCPtrToDriver
      MOV       VDummy, AX
      END;
   VOCGetVersion := VDummy;
   END;

PROCEDURE VOCSetPort(PortNumber : WORD);
{
}
BEGIN
   ASM
      MOV    BX,1
      MOV    AX,PortNumber
      CALL   VOCPtrToDriver
      END;
   END;

PROCEDURE VOCSetIRQ(IRQNumber : WORD);
{
}
BEGIN
   ASM
      MOV    BX,2
      MOV    AX,IRQNumber
      CALL   VOCPtrToDriver
      END;
   END;

FUNCTION  VOCInitDriver: BOOLEAN;
{
}
VAR
   Out, VSeg, VOfs : WORD;
   F   : File;
   Drivername,
   Pdir        : DirStr;
   Pnam        : NameStr;
   Pext        : ExtStr;

BEGIN
   Pdir := ParamStr(0);
   Fsplit(ParamStr(0),Pdir,Pnam,Pext);
   Drivername := Pdir+'CT-VOICE.DRV';

   VOCInitDriver := TRUE;

{ Driver not found }
   IF Not Exists(Drivername) THEN BEGIN
      VOCInitDriver := FALSE;
      VOCErrStat    := 100;
      EXIT;
      END;
{ Loading of  driver }
   Assign(F,Drivername);
   Reset(F,1);
   AllocateMem(VOCPtrToDriver,Filesize(F));

{ Not enougth memory for driver }

   IF VOCPtrToDriver = NIL THEN BEGIN
      VOCInitDriver := FALSE;
      VOCErrStat    := 110;
      EXIT;
      END;

   Blockread(F,VOCPtrToDriver^,Filesize(F));
   Close(F);

{ Bad Driver, don't begin by "CT" }

   IF (TypeCastType(VOCPtrToDriver^)[3]<>'C') OR
      (TypeCastType(VOCPtrToDriver^)[4]<>'T') THEN BEGIN
         VOCInitDriver := FALSE;
         VOCErrStat    := 120;
         EXIT;
         END;

{ Return Number of Version }
   VOCDriverVersion := VOCGetVersion;

{ Start Driver }
   Vseg := Seg(VOCStatusWord);
   VOfs := Ofs(VOCStatusWord);
   ASM
      MOV       BX,3
      CALL      VOCPtrToDriver
      MOV       Out,AX
      MOV       BX,5
      MOV       ES,VSeg
      MOV       DI,VOfs
      CALL      VOCPtrToDriver
      END;

{ Sound Blaster card not found  }
   IF Out = 1 THEN BEGIN
      VOCInitDriver := FALSE;
      VOCErrStat    := 400;
      EXIT;
      END;

{ Bad address port }
   IF Out = 2 THEN BEGIN
      VOCInitDriver := FALSE;
      VOCErrStat    := 410;
      EXIT;
      END;

{ Bad Interrupt Number }
   IF Out = 3 THEN BEGIN
      VOCInitDriver := FALSE;
      VOCErrStat    := 420;
      EXIT;
      END;

   END;

PROCEDURE VOCDeInstallDriver;
{
}
VAR
   Check : BOOLEAN;
BEGIN
   IF VOCDriverInstalled THEN
   ASM
      MOV       BX,9
      CALL      VOCPtrToDriver
      END;
   Check := VOCFreeBuffer(VOCPtrToDriver);
   END;

PROCEDURE VOCSetSpeaker(OnOff:BOOLEAN);
{
}
VAR
   Switch : BYTE;
BEGIN
   Switch := Ord(OnOff) AND $01;
   ASM
      MOV       BX,4
      MOV       AL,Switch
      CALL      VOCPtrToDriver
      END;
   END;

PROCEDURE VOCOutput (BufferAddress : Pointer);
{
}
VAR
   VSeg, VOfs : WORD;
BEGIN
   VOCSetSpeaker(TRUE);
   VSeg := Seg(BufferAddress^);
   VOfs := Ofs(BufferAddress^)+VOCFileHeaderLength;
   ASM
      MOV       BX,6
      MOV       ES,VSeg
      MOV       DI,VOfs
      CALL      VOCPtrToDriver
      END;
   END;

PROCEDURE VOCOutputLoop (BufferAddress : Pointer);
VAR
   VSeg, VOfs : WORD;
BEGIN
   VSeg := Seg(BufferAddress^);
   VOfs := Ofs(BufferAddress^)+VOCFileHeaderLength;
   ASM
      MOV       BX,6
      MOV       ES,VSeg
      MOV       DI,VOfs
      CALL      VOCPtrToDriver
      END;
   END;

PROCEDURE VOCStop;
{
}
BEGIN
   ASM
      MOV       BX,8
      CALL      VOCPtrToDriver
      END;
   END;

PROCEDURE VOCPause;
{
}
VAR
   Switch : WORD;
BEGIN
   VOCPaused := TRUE;
   ASM
      MOV       BX,10
      CALL      VOCPtrToDriver
      MOV       Switch,AX
      END;
   IF (Switch = 1) THEN BEGIN
      VOCPaused := FALSE;
      VOCErrStat := 510;
      END;
   END;

PROCEDURE VOCContinue;
{
}
VAR
   Switch : WORD;
BEGIN
   ASM
      MOV       BX,11
      CALL      VOCPtrToDriver
      MOV       Switch,AX
      END;
   IF (Switch = 1) THEN BEGIN
      VOCPaused := FALSE;
      VOCErrStat := 520;
      END;
   END;

PROCEDURE VOCBreakLoop(BreakMode : WORD);
{
}
BEGIN
   ASM
      MOV       BX,12
      MOV       AX,BreakMode
      CALL      VOCPtrToDriver
      MOV       BreakMode,AX
      END;
   IF (BreakMode = 1) THEN VOCErrStat := 500;
   END;

{$F+}
PROCEDURE VoiceToolsExitProc;
{$F-}
{
              install  la fin du programme
}
BEGIN
   VOCDeInstallDriver;
   ExitProc := OldExitProc;
   END;

BEGIN
{
}
{ Change old ExitProc on newer Tool-Unit }
   OldExitProc := ExitProc;
   ExitProc := @VoiceToolsExitProc;
{ Init basic value }
   VOCStatusWord := 0;
   VOCErrStat    := 0;
   VOCPaused     := FALSE;
   VOCFileHeaderLength := $1A;
   VOCFileHeader :=
      'Creative Voice File'+#$1A+#$1A+#$00+#$0A+#$01+#$29+#$11+#$01;
{

}
   VOCDriverInstalled := VOCInitDriver;
END.