{ Fido Pascal Conference  PASCAL 
Msg  : 342 of 353
From : John Linden                         1:280/17.0           23 Jul 93  22:09
To   : Martin Bouchard
Subj : BGI

MB> I need to convert some file that are in Borland BGI format. Those files are
MB> simple icons in 16 colors. My experience tell me that this file format is
MB> based on bitplanes, but it's only a guess. Could anybody help?
MB>
MB> BTW, this is the same format used byicons in RIPTERM.

Hmm, well since I am writing an RIP icon editor, I can probably help. The
icons are saved using the GetImage and PutImage. The following routines are
some that I use to load and save icons.}

USES graph;
 
Type  BigArray     =Array[1..60000] of Byte;
      PBigArray    =^BigArray;
 
 
Var   F            :File;
      IconSize     :Word;
      Icon         :PBigArray;
      Gd,Gm        :Integer;
 
Procedure LoadIcon(FN:String);
Begin
  Assign(F,FN);
  {$I-} Reset(F,1); {$I+}
  IconSize:=FileSize(F); 
  GetMem(Icon, IconSize); 
  BlockRead(F,Icon^,IconSize);
  PutImage(1,1,Icon^,CopyPut);
  Close(F);
End;
 
Procedure SaveIcon( X1, Y1, X2, Y2: Integer;
                     FileName: String);
Var
   FileToSave   : File;
   I            : Integer;
   PointImage   : Pointer;
   Size         : Word;
Begin
     Assign(FileToSave, FileName);
     Size := ImageSize(X1, Y1, X2, Y2);
     ReWrite(FileToSave, Size);
     GetMem(PointImage, Size);
     GetImage(X1, Y1, X2, Y2, PointImage^);
     BlockWrite(FileToSave, PointImage^, 1);
     FreeMem(PointImage, Size);
     Close(FileToSave);
End;