{ Fido Pascal Conference  PASCAL 
Msg  : 152 of 158                                                               
From : Mark Lewis                          1:3634/12.0          18 Jul 93  11:40 
To   : Brian Swanson                       1:123/419.0                           
Subj : Miscellaneous Unit St                                                  

 >>  way to call exec(); without the output from the
 >> "shell" going to the
 >>  screen?..thanx for any help...
 > I asked about this a few months ago...A few people came up with
 > some jury rigged fixes, but I never found one that really worked
 > well...What you need to do is hook whatever interrupt is called
 > when characters are displayed, and just don't display them...

=or= use true redirection... i don't remember who the original author was or
who posted this way back... but here it is, once again... enjoy -=B-)

______________________________O/______ snip _________________________
                              O\}

{
Use it exactly as you would the normal EXEC procedure:

  Exec('MASM.EXE','mystuff.asm');

To activate redirection simply add the redirection symbols, etc:

  Exec('MASM.EXE','mystuff.asm >err.lst');

One note of caution.  This routine temporarily uses extra handles. It's
either two or four more.  The various books I have are not clear as to
whether duplicated handles 'count' or not. My guess is yes.  If you don't
plan on redirecting STDIN then remove all the code for duplicating it to
cut your handle overhead in half.
}

Unit Execute;

Interface

Procedure Exec(Path,CmdLine : String);

Implementation

Uses Dos;

Function ExtractFileName(Var Line : String;Index : Integer) : String;

Var
  Temp : String;

Begin
  Delete(Line,Index,1);
  While (Index <= Length(Line)) AND (Line[Index] = ' ')
    Do Delete(Line,Index,1);
  Temp := '';
  While (Index <= Length(Line)) AND (Line[Index] <> ' ') Do
  Begin
    Temp := Temp + Line[Index];
    Delete(Line,Index,1);
  End;
  ExtractFileName := Temp;
End;

Procedure CloseHandle(Handle : Word);

Var
  Regs : Registers;

Begin
  With Regs Do
  Begin
    AH := $3E;
    BX := Handle;
    MsDos(Regs);
  End;
End;

Procedure Duplicate(SourceHandle : Word;Var TargetHandle : Word);

Var
  Regs : Registers;

Begin
  With Regs Do
  Begin
    AH := $45;
    BX := SourceHandle;
    MsDos(Regs);
    TargetHandle := AX;
  End;
End;

Procedure ForceDuplicate(SourceHandle : Word;Var TargetHandle : Word);

Var
  Regs : Registers;

Begin
  With Regs Do
  Begin
    AH := $46;
    BX := SourceHandle;
    CX := TargetHandle;
    MsDos(Regs);
    TargetHandle := AX;
  End;
End;

Procedure Exec(Path,CmdLine : String);

Var
  StdIn   : Word;
  Stdout  : Word;
  Index   : Integer;
  FName   : String[80];
  InFile  : Text;
  OutFile : Text;

  InHandle  : Word;
  OutHandle : Word;
         { ===============>>>> }   { change below for STDERR }
Begin
  StdIn := 0;
  StdOut := 1;                    { change to 2 for StdErr       }
  Duplicate(StdIn,InHandle);      { duplicate standard input     }
  Duplicate(StdOut,OutHandle);    { duplicate standard output    }
  Index := Pos('>',CmdLine);
  If Index > 0 Then               { check for output redirection }
  Begin
    FName := ExtractFileName(CmdLine,Index);  { get output file name  }
    Assign(OutFile,FName);                    { open a text file      }
    Rewrite(OutFile);                         { .. for output         }
    ForceDuplicate(TextRec(OutFile).Handle,StdOut);{ make output same }
  End;
  Index := Pos('<',CmdLine);
  If Index > 0 Then               { check for input redirection }
  Begin
    FName := ExtractFileName(CmdLine,Index);  { get input file name  }
    Assign(InFile,FName);                     { open a text file     }
    Reset(InFile);                            { for input            }
    ForceDuplicate(TextRec(InFile).Handle,StdIn);  { make input same }
  End;
  DOS.Exec(Path,CmdLine);           { run EXEC }
  ForceDuplicate(InHandle,StdIn);   { put standard input back to keyboard }
  ForceDuplicate(OutHandle,StdOut); { put standard output back to screen  }
  CloseHandle(InHandle);            { close the redirected input file     }
  CloseHandle(OutHandle);           { close the redirected output file    }
End;

End.