{ Fido Pascal Conference  PASCAL 
Msg  : 221 of 323
From : William Sitch                       1:163/542.0          04 Jun 93  18:18
To   : Chris Gahan                         1:259/423.0
Subj : Scaling..

Quoting [From: Chris Gahan; To: All]

CG>         I've been trying for some time to get a Pascal
CG> procedure that can SCALE and/or ROTATE graphic images. if
CG> anyone has any idea how to do this, or has a source code,
CG> PLEEEAASSEE drop me a line.. THANK YOU!

Here is some code to rotate an image (in MCGA screen mode $13) ... but it has a
few drawbacks... its kinda slow and the image falls apart during rotation... it
hasn't been tested fully either...

---}
procedure rotate (x1,y1,x2,y2:word; ang,ainc:real);
var
  ca,sa    :  real;
  cx,cy    :  real;
  dx,dy    :  real;
  h,i,j,k  :  word;
  pinf     :  array [1..12500] of record
                                    x,y  :  word;
                                    col  :  byte;
                                  end;
begin
  ca := cos((ainc/180)*pi);
  sa := sin((ainc/180)*pi);

  for h := 1 to round(ang/ainc) do
    begin
      k := 0;
      cx := x1 + ((x2 - x1) / 2);
      cy := y1 + ((y2 - y1) / 2);
      for i := x1 to x2 do
        for j := y1 to y2 do
          begin
            inc(k);

            dx := cx + (((i - cx) * ca) - ((j - cy) * sa));
            dy := cy + (((i - cx) * sa) + ((j - cy) * ca));

            if (round(dx) > 0) and (round(dy) > 0) and (round(dx) < 65000) and 
(round(dy) < 65000) then
              begin
                pinf[k].x := round(dx);
                pinf[k].y := round(dy);
                pinf[k].col := mem[$A000:j*320+i];
              end
            else
              begin
                pinf[k].x := 0;
                pinf[k].y := 0;
                pinf[k].col := 0;
              end;
          end;

      for i := x1 to x2 do
        for j := y1 to y2 do
          mem[$A000:j*320+i] := 0;

      x1 := 320; x2 := 1;
      y1 := 200; y2 := 1;
      for i := 1 to k do
        begin
          if (pinf[i].x < x1) then
            x1 := pinf[i].x;
          if (pinf[i].x > x2) then
            x2 := pinf[i].x;

          if (pinf[i].y < y1) then
            y1 := pinf[i].y;
          if (pinf[i].y > y2) then
            y2 := pinf[i].y;

          if (pinf[i].x > 0) and (pinf[i].y > 0) then
            mem[$A000:pinf[i].y*320+pinf[i].x] := pinf[i].col;
        end;
    end;
end;
---

It works, but DON'T try to use it for a main module or base a program AROUND
it... instead try to change it to suit your needs, as right now it's kinda
optimized for my needs...

Sorry for not editing it to work with any screen mode, but I just don't have
the time.  MCGA memory is a linear block of bytes, and you can access it using:
mem[$A000:offset].  So to find the color at screen position 10,10, you would
go:

mem[$A000:y*320+x]
          ^  ^  ^-- x val, 10
          |  |----- screenwidth
          |-------- y val, 10
