{ Fido Pascal Conference  PASCAL 
Msg  : 629 of 643
From : Michael Nicolai                     2:2401/411.2         06 Jun 93  03:53
To   : Wouter Goderis
Subj : Circle 320x200x256

# Der User Wouter Goderis@2:291/1500.58 musste am Sonntag, dem 30.05.93 um
12:19 Uhr
# in der Area PASCAL folgendes seiner Tastatur antun................

>         Hmm,
>
>         does someone have a circle routine for the 320x200x256 mode.
>         I need one using the assembler...  (FAST) ( or isn't that possible)
>         I doesn't need to be very perfect, if it has the shape of a circle,
>         I'm satisfied.
>         Can someone give me some hints ?
>
>                                                         \/\/ OUTER

I don't have any ASM-program yet but i got the same question some time ago.

Here ist what i answered then......


Ok then, let's do some math:

The basic formula (and quickest?) for drawing a circle is: x^2 + y^2 = r^2.
The r stands for radius (half the diameter). You know this formula, i am
sure. A guy called Phytagoras set i up very long ago to calculate the
hypotenuse of a given triangle.


                   |\
                   | \
                 a |  \ c      c^2 = a^2 + b^2
                   |   \
                   |____\

                     b

Remember?

Now look at this:        ...|     a quater of the circle
                       ..   |
                      . ____|y
                     . |\   |
                    .  | \  |
                    .  | r\ |
                    .  |   \|
               --------------------------
                    r  x    |0
                            |
                            |


r is given and take 0 - r as a starting point for x. Then all you have to do
is to calculate y and plot the point.

    y = sqrt((r * r) - (x * x))      sqrt : square root

After each calculation x is increased until it has reached 0. Then one
quarter of the circle is drawn. The other three quarters are symmetrical.

I have written a short program for you to draw a circle in 320x200x256
graphics mode. When you key in some values please remember that NO error
checking will be done. x has to be between 0 and 319, and y between 0 and
199. The radius must NOT be greater than x AND y.

Example: x : 160; y : 100; r : 90

When you start this program you will not get correct circles because in
graphics mode ONE pixel is not square!!! You have to calculate an aspect
ratio to get nice looking circles.}

program circle;

uses CRT, DOS;

var

 regs    : Registers;
 x0, y0  : word;
 x, y, R : real;
 temp    : real;
 c       : char;

procedure putpixel(x, y : word; color : byte);
begin
 mem[$A000: (y * 320 + x)] := color;
end;

begin
 clrscr;
 writeln('Enter coordinates of middle-point :');
 writeln;
 write('x : '); readln(x0);
 write('y : '); readln(y0);
 writeln;
 write('Enter radius :'); readln(R);

 { Switch to 320x200x256 }

 regs.ax := $0013;
 intr($10, regs);

 x := (-1) * R;  { go from 0 - R to 0 }
 temp := R * R;
 repeat
  y := sqrt(temp - (x * x));
  putpixel((x0 + trunc(x)), (y0 - trunc(y)), 15); { 4.th quadrant }
  putpixel((x0 - trunc(x)), (y0 - trunc(y)), 15); { 1.st quadrant }
  putpixel((x0 + trunc(x)), (y0 + trunc(y)), 15); { 3.rd quadrant }
  putpixel((x0 - trunc(x)), (y0 + trunc(y)), 15); { 2.nd quadrant }
  x := x + 0.1; { change this if you want coarse or fine circle. }
 until (x >= 0.0);
 c := readkey;  { wait for keypress. }

 { Switch back to textmode. }

 regs.ax := $0003;
 intr($10, regs);
end.