{ Fido Pascal Conference  PASCAL 
Msg  : 436 of 612
From : Trisdaresa Sumarjoso                1:272/38.0           12 Jun 93  01:02
To   : Jeff Carney
Subj : READING/WRITING Pointers

 -=> Quoting Jeff Carney to All <=-

 JC> PLEASE HELP ME!!!!
 JC> I am looking for a way to get an Image into a pointer (besides
 JC> arrays) and write it to my disk. I am using arrays right now, and
 JC> works fine, but When  I get big images I run out of mem fast...  ::
 JC> IBUF : array [1..30000] of byte; getimage(x1,y1,x2,y2,IBUF);
 JC> repeat
 JC> Write(f,IBUF[NUM]);
 JC> num:=num+1;
 JC> until num=sizeof(ibuf);
 JC> This works as long as I dont try to grab a large image.
 JC> Any comments are welcome.....  Please reply...
 JC> Jeff Carney

        Hello Jeff...
        I grab following code from a larger work of mine. This is just a
        little modified version of the image saver part. No need to say,
        this handle only a very limited image (anything that is less than
        64k in BGI format). And in procedure RESTOREIMAGE, you will be
        better of finding your image size using FILESIZE function, since
        this procedures assume one file per image.}

Program TestingSaveImage;
Uses
    Graph, Crt;

Procedure SaveImage( X1, Y1, X2, Y2: Integer;
                     FileName: String);
Var
   FileToSave   : File;
   I            : Integer;
   PointImage   : Pointer;
   Size         : Word;
Begin
     Assign(FileToSave, FileName);
     Size := ImageSize(X1, Y1, X2, Y2);
     ReWrite(FileToSave, Size);
     GetMem(PointImage, Size);
     GetImage(X1, Y1, X2, Y2, PointImage^);
     BlockWrite(FileToSave, PointImage^, 1);
     FreeMem(PointImage, Size);
     Close(FileToSave);
End;

Procedure RestoreImage( X1, Y1, X2, Y2: Integer;
                        FileName: String);
Var
   FileToSave   : File;
   I            : Integer;
   PointImage   : Pointer;
   Size         : Word;
Begin
     Assign(FileToSave, FileName);
     Size := ImageSize(X1, Y1, X2, Y2);
     Reset(FileToSave, Size);
     GetMem(PointImage, Size);
     BlockRead(FileToSave, PointImage^, 1);
     PutImage(X1, Y1, PointImage^, CopyPut);
     FreeMem(PointImage, Size);
     Close(FileToSave);
End;

Var
   Gd, Gm       : Integer;

Begin
     Gd := Detect;
     InitGraph(Gd, Gm, 'c:\bp\bgi');
     Bar(0, 0, GetMaxX, GetMaxY);
     SaveImage(0, 0, 100, 100, 'Testing.Dat');
     Repeat
     Until ReadKey = #13;
     ClearViewPort;
     Repeat
     Until ReadKey = #13;
     RestoreImage(0, 0, 100, 100, 'Testing.Dat');
     Repeat
     Until ReadKey = #13;
     CloseGraph;
End.