{ Fido Pascal Conference  PASCAL 
Msg  : 512 of 587
From : Sean Palmer                         1:104/130.0          04 Jun 93  02:42
To   : All
Subj : State-Driven Interrupts

I just got this working, so have fun, guys!! 8)}

{by Sean L. Palmer}
{Public Domain}

{This is a 'multitasking' program in the sense that it hooks into
 the timer interrupt, but what that interrupt ends up actually
 doing is controlled by the current value in SaveAdr, which
 changes with each interrupt as the routine passes control back
 to the tick handler not by exiting normally, but by an explicit
 transfer of control.}
{The end result of this is that you can write a state-driven
 interrupt handler}
{The included example is REALLY simplistic, and barely tested.
 I intend to use this to write a comm port driver that
 parses the incoming data as it receives it which would
 be nice in a communications program that shells to dos, as
 the incoming chars could be saved to disk in the background
 with buffered ZModem or something...}

program intTest;

uses dos;

var saveAdr:word;  {offset in this code segment of where we are now}
var active:boolean;  {to avoid re-entrancy}

procedure intHandler; far; assembler; asm
 pusha
 mov ax,seg @DATA
 mov ds,ax

 {anything you need to do before continuing (reading port data?), do here}

 in al,$61  {click speaker as an example}
 xor al,2
 out $61,al

 test active,$FF  {exit now if interrupted ourselves}
 jz @OK
 popa
 iret

@OK:
 inc byte ptr active
 sti
 jmp [saveAdr]  {near jump to continue where handler last left off}
 end;

{call this procedure from StateHandler to suspend execution until next time}

procedure wait; near; assembler; asm {wait for next interrupt}
 pop word ptr saveAdr  {save where to continue next time}
 dec byte ptr active
 popa                  {restore caller regs}
 iret
 end;

const c:char='.';

procedure stateHandler; begin

{a stateHandler procedure should never ever exit (only by calling 'wait'),
 shouldn't have any local variables or parameters, and shouldn't call
 'wait' with anything on the stack (like from a subroutine).
 This routine is using the caller's (interrupted program's) stack, so be
 very very careful}

 asm pop bp; end;  {clean up stack mess left by Turbo's procedure header}
{^ alternative method here is to init saveAdr to offset(proc)+3 and skip
 the push bp; mov bp,sp altogether}

 repeat  {this is an example only}
  c:='@';
  wait;
  c:='.';
  wait;
  until false;                {don't let it return normally!!}
 end;

var oldHook:procedure;
var i:integer;

begin
 saveAdr:=ofs(stateHandler);
 getIntVec($1C,@oldHook);
 setIntVec($1C,@intHandler);
 for i:=1 to 1500 do write(c);
 setIntVec($1C,@oldHook);
 end.