{ Fido Pascal Conference  PASCAL 
Msg  : 322 of 362
From : Jon Jasiunas                        1:273/216.0          28 May 93  09:56
To   : Rob Perelman
Subj : Make a new VAR in program

===========================================================================
Date: 05-22-93 (22:04)
Subj: Make a new VAR in program
   ------------------------------------------------------------------------
RP> I was wondering if there's a way to make a new variable inside the
  > program code...like say:

RP> MAKEVAR(THISNAME, Array[1..10] of String);

No......

RP> Or at least change the size:

RP> {In Proper Place: Var ThisName: Array[1..10] of String;
  > In Program: IncVar(ThisName, 1); Now Array[1..11]

RP> No?  Maybe just wishful thinking...

This can be done by using a dynamic array.  Just make sure to use
pointers so you don't overwrite other data and/or program code.

   - cut here ----}
uses
  Crt;

type
  ItemType = String;
  StrArray = array[0..0] of ItemType;

var
  PStr       : ^StrArray;
  NumElements: Byte;
  Index      : Byte;

begin
  ClrScr;
  WriteLn('Allocate space for how many strings? ',
          '(255 max)');
  ReadLn(NumElements);
  WriteLn;
  If NumElements > 255 then
    NumElements := 255;
  GetMem(PStr, NumElements * SizeOf(ItemType));
  For Index := 0 to Pred(NumElements) do
    begin
      Write('String to store in element ', Index, '? ');
      ReadLn(PStr^[Index]);
    end;  { For }
  ClrScr;
  For Index := 0 to Pred(NumElements) do
    WriteLn('String stored in element ', Index, ' = ', PStr^[Index]);
  FreeMem(PStr, NumElements * SizeOf(ItemType));
end.