{ Fido Pascal Conference  PASCAL 
Msg  : 267 of 323
From : Sean Palmer                         1:104/123.0          05 Jun 93  01:22
To   : All
Subj : Avatar interpretation

Using the state-driven approach, I came up with this simplistic
Avatar/0 interpreter as an example. Do with it as you wish...}

{by Sean L. Palmer}
{Public Domain}

program avtWrite;  {example to do avatar/0 (FSC-0025) interpretation}
  {could easily be extended to handle /0+ and /1 codes}

uses crt;

{this part of the program controls the state-driven part of the display
 handler.}

var saveAdr:pointer;  {where state handler is now}
var
 c:char;    {char accessed by state handler}
 b:byte absolute c;

procedure avtWriteCh(c2:char);Inline(
  $8F/$06/>C/            {pop byte ptr [>c]}
  $FF/$1E/>SAVEADR);     {call dword ptr [>saveAdr]}  {continue where handler l

{call this procedure from StateHandler to suspend execution until next time}

procedure wait; near; assembler; asm {wait for next char}
 pop word ptr saveAdr  {save where to continue next time}
 retF    {simulate exit from calling proc}
 end;

{a stateHandler procedure should never ever exit (only by calling 'wait'),
 shouldn't have any local variables or parameters, and shouldn't call
 'wait' with anything on the stack (like from a subroutine).
 This routine is using the caller's stack, so be careful}

var
 avc:char;
 avb:byte absolute avc;

procedure stateHandler; begin
 repeat
  case c of
   ^L:begin clrscr; textattr:=3; end;
   ^Y:begin
    wait; avc:=c;
    wait;
    while c<>#0 do begin dec(c); write(avc); end;
    end;
   ^V:begin
    wait;
    case c of
     ^A:begin
      wait;
      textattr:=byte(c);
      end;
     ^B:textattr:=textattr or $80;
     ^C:if whereY>1 then gotoxy(whereX,whereY-1);
     ^D:if whereY<25 then gotoxy(whereX,whereY+1);
     ^E:if whereX>1 then gotoxy(whereX-1,whereY);
     ^F:if whereX<80 then gotoxy(whereX+1,whereY);
     ^G:clreol;
     ^H:begin
      wait; avb:=b;
      wait; gotoxy(b+1,avb+1);
      end;
     else write(^V,c)
     end;
    end;
   else write(c);
   end;
  wait;
  until false;
 end;

var i:integer;
const s:string='Oh my'^V^D^V^D^V^F^V^A#1'it works'^V^A#4',see?';
begin  {could do something like attach it to Output's InOutFunc...}
 saveAdr:=ptr(seg(stateHandler),ofs(stateHandler)+3); {skip header}
 for i:=1 to length(s) do avtWriteCh(s[i]);
 end.