{ Fido Pascal Conference  PASCAL 
Msg  : 455 of 587
From : Sepp Mayer                          2:246/36.0           03 Jun 93  16:51 
To   : Ryan Brown                                                                
Subj : Structure Too Large                                                    

    about: Structure too large ---

 RB> Help... I have an array of records. The highest I can get this array
 RB> is to 700 records.. the record contains one string[10] and one
 RB> string[72]. can anyone  tell me how to get thearray to 1000?

 Hello Ryan,

 The limit of your Data-Segment is 65 KByte.
 A string[10] need 11 Byte Memory, A string[72] needs 73 Byte of Memory.
 (The first Byte for the Length followed by the String itself)
 So, one Record needs 84 Bytes in Memory. 
 The Maximum with your Method is 781. 
 781 * 84 = 65604.

 The solution:

 Use the Heap, dont store the Record in the Data-Segment (=DS), store only a
 POINTER to it in the DS.

 A Little example:}

 program HeapTest;

 type
   TStr10    = string[10];
   TStr72    = string[72];
   PAnyThing = ^TAnyThing;
   TAnyThing = record
     FieldOne : TStr10;
     FieldTwo : TStr72;
   end;

 var
   AnyThing : array[1..1000] of PAnyThing;
   CountOfAnyThing : integer;
   i : integer;

 procedure AddAnyThing(One, Two : string); (* Adds a new AnyThing *)
 begin
   If CountOfAnyThing = 1000
   then begin
     WriteLn('Too many AnyThings');
     Exit;
   end;
   Inc(CountOfAnyThing);
   AnyThing[CountOfAnyThing] := New(PAnyThing);
   AnyThing[CountOfAnyThing]^.FieldOne := Copy(One,1,10); (* See the ^ *)
   AnyThing[CountOfAnyThing]^.FieldTwo .= Copy(Two,1,72); (* See the ^ *)
 end;
 
 procedure RemoveAnyThing;   (* Removes the Last AnyThing *)
 begin
   if CountOfAnyThing = 0
   then begin
     WriteLn('There is no AnyThing');
     Exit;
   end;
   Dispose(AnyThing[CountOfAnyThing]);
   Dec(CountOfAnyThing);
 end;

 begin
   CountOfAnyThing := 0;                     (* Set Count to 0 *)
   RemoveAnyThing;                           (* Only to show the Error *)
   AddAnyThing('field1','field2');           (* Create a AnyThing *)
   (* Whatever you want ... *)
   for i := 1 to CountOfAnyThing do          (* At the End of the Programm *)
     RemoveAnyThing;                         (* or when you dont need your *)
 end.                                        (* array, remove it *)


 It is a good Idea to free the Memory you catched with New, otherwise your
 Computers Memory will shrink from run to run and at the end you have to
 reboot your System.