{ Fido Pascal Conference  PASCAL 
Msg  : 404 of 591
From : David Drzyzga                       1:3612/220.0         23 Jun 93  16:57
To   : Dale Barnes                         1:3601/200.0
Subj : Program wanted

 DB> Does anyone know of any program that will scan an
 DB> entire programs pascal source code and give a listing
 DB> of each procedure/function in each file?

Here's something I just threw together. There is minimal error checking and if
you run it on a unit you will get double listings (from the interface and
implementation sections).}

{------------------------------------------------------------------------------
     Original source code by David Drzyzga, FidoNet 1:3612/220, SysOp of
                  =>> CUTTER JOHN'S <<= (904) 932-1849 [HST]
                                  06-23-1993
------------------------------------------------------------------------------}
program findsubr;

uses
  crt;

var
  FileIn, FileOut         : text;
  InFileName, OutFileName : string[79];
  LineIn, Lineout         : string;

function upcasestr(s:string):string;
var
  st : string;
  ix : byte;
begin
  st := '';
  for ix := 1 to length(s) do st := st + upcase(s[ix]);
  upcasestr := st;
end; {UpCaseStr}

procedure ProcessFile;
var
  c:char;
begin
  assign(FileIn, ParamStr(1));
  {$I-} Reset(FileIn); {$I+};
  if IOResult <> 0 then begin
    writeln(#13#10'Input file ''',ParamStr(1),''' not found.'#13#10);
    halt;
  end;
  InFileName := ParamStr(1);
  Delete(InFileName, pos('.',InFileName),4);
  if Length(ParamStr(2)) > 0 then
    OutFileName := ParamStr(2)
  else
    OutFileName := InFileName+'.$$$';
  assign(FileOut, OutFileName);
  {$I-} Reset(FileOut); {$I+};
  if IOResult = 0 then begin
    writeln;
    write('Output file ''',OutFileName,''' already exists, overwrite? ');
    repeat c := UpCase(ReadKey) until (c in ['Y','N']);
    writeln(c,#13#10);
    if c = 'N' then halt;
  end;
  rewrite(FileOut);
  while not eof(FileIn) do begin
    readln(FileIn,LineIn);
    while pos(' ', LineIn) = 1 do delete(LineIn, 1 ,1);
    LineOut := upcasestr(LineIn);
    if (pos('PROCEDURE', LineOut) = 1) or
       (pos('FUNCTION', LineOut) = 1) then
      writeln(FileOut,LineIn);
  end;
  Close(FileIn);
  Close(FileOut);
  if OutFileName = InFileName + '.$$$' then begin
    erase(FileIn);
    rename(FileOut, ParamStr(1));
  end;
end; {ProcessFile}

procedure ParseCommandLine;
begin
  if ParamCount < 1 then begin
    writeln;
    writeln('Usage:  FINDSUBR <input file> <output file>');
    writeln;
    write('If no output file is specified the input file will be ');   
writeln('overwritten.'); {on its own line just cuz wordwrap}
    writeln;
    halt;
  end;
end; {ParseCommandLine}

{Main program code}
begin
  ParseCommandLine;
  ProcessFile;
end.