{ This is a demonstration of the archive directory handling
  provided by the Pascal Wizard's Library }



{$M $3000,0,0 }          { stack size, min heap, max heap (bytes) }
{$D-}                    { debug info off }
{$A-}                    { word alignment off (so use byte alignment) }
{$I-}                    { don't crash on errors }



USES
   Archives, Strings;



VAR
   CurrentSize, OriginalSize: LongInt;
   tmp, ErrCode: Integer;
   Verbose: Boolean;
   FileName, DateSt, TimeSt: String;



PROCEDURE WriteComma (Number: LongInt; FieldLen: Integer);
VAR
   N, R: String;
BEGIN
   Str(Number, N);
   R := '';
   WHILE Length(N) > 3 DO BEGIN
      R := Right(N, 3) + ',' + R;
      N := Left(N, Length(N) - 3);
   END;
   IF Length(N) > 0 THEN
      R := N + ',' + R;
   IF Right(R, 1) = ',' THEN
      R := Left(R, Length(R) - 1);
   IF Length(R) < FieldLen THEN
      R := Dupe(FieldLen - Length(R), ' ') + R;
   Write(R);
END;



BEGIN
   IF (ParamCount = 0) THEN BEGIN
      WriteLn('ARCVIEW  Demo for the PasWiz Library archive directory routines');
      WriteLn;
      WriteLn('Syntax:');
      WriteLn('   ARCVIEW [/V] arcname');
      WriteLn;
      WriteLn('Archives may be in the following formats:');
      WriteLn;
      WriteLn('   .ARC     .LZH     .ZIP');
      WriteLn('   .ARJ     .PAK     .ZOO');
      WriteLn;
      WriteLn('(and associated self-extracting .EXE archives)');
      WriteLn;
      WriteLn('Just the filenames will be listed, unless the /V (verbose) switch is used.');
   END
   ELSE BEGIN
      Verbose := FALSE;
      FOR tmp := 1 TO ParamCount DO
         IF Uppercase(ParamStr(tmp)) = '/V' THEN
            Verbose := TRUE;
      IF Verbose AND (ParamCount = 1) THEN BEGIN
         WriteLn('Please specify the name of an archive.');
         EXIT;
      END;
      FOR tmp := 1 TO ParamCount DO
         IF Uppercase(ParamStr(tmp)) <> '/V' THEN BEGIN
            FindFirstA(ParamStr(tmp), '*.*', ErrCode);
            IF ErrCode <> 0 THEN BEGIN
               WriteLn('Unable to open archive "', ParamStr(tmp), '"');
               writeln(errcode);
               EXIT;
            END;
            IF Verbose THEN BEGIN
               WriteLn('Filename       Date       Time    CRC        Curr. Size    Orig. Size');
               WriteLn('------------   --------   -----   --------   -----------   -----------');
            END;
            WHILE ErrCode = 0 DO BEGIN
               FileName := GetNameA;
               IF Verbose THEN BEGIN
                  Write(FileName, Dupe(15 - Length(FileName), ' '));
                  DateSt := Left(GetDateA, 6) + Right(GetDateA, 2);
                  TimeSt := Left(GetTimeA, 5);
                  Write(DateSt, '   ', TimeSt, '   ', GetCRCA);
                  GetSizeA(OriginalSize, CurrentSize);
                  WriteComma(CurrentSize, 14);
                  WriteComma(OriginalSize, 14);
                  WriteLn;
               END
               ELSE
                  Write(FileName, Dupe(16 - Length(FileName), ' '));
               FindNextA(ErrCode);
            END;
            CloseA;
            IF NOT Verbose THEN WriteLn;
         END;
   END;
END.
