UNIT autodoc;

INTERFACE

procedure SelfDisplayingDocumentation;

IMPLEMENTATION

USES crt, dos;
VAR Actual_Page : word;
    Max_Page    : word;
    OldAttr     : byte;
    CursorTop,
    CursorTopSaved,
    CursorTail,
    CursorTailSaved : byte;

PROCEDURE SaveCursorShape(VAR Top, Tail : byte);
VAR Regs : Registers;
begin
  Regs.AH := 3;
  Intr($10,Regs);
  Top :=  Regs.CH;
  Tail := Regs.CL;
  CursorTailSaved := Tail;
  CursorTopSaved := Top;
end;

Procedure CursorOff;
VAR Regs : Registers;
begin
  Regs.AH := 1;
  Regs.CH := 32;
  Regs.CL := 0;
  Intr($10,Regs);
end;

Procedure CursorOn;
VAR Regs : Registers;
begin
  Regs.AH := 1;
  Regs.CH := CursorTop;
  Regs.CL := CursorTail;
  Intr($10,Regs);
end;

Procedure RestoreCursor;
VAR Regs : Registers;
begin
  Regs.AH := 1;
  Regs.CH := CursorTopSaved;
  Regs.CL := CursorTailSaved;
  CursorTop := CursorTopSaved;
  CursorTail := CursorTailSaved;
  Intr($10,Regs);
end;


procedure BottomLine;
begin
  OldAttr := TextAttr;
  gotoxy(1,25);
  if Actual_Page = 1 then
    begin
      write('':15);
      TextBackGround(LightGray);
      TextColor(Black);
      write('  Next page : DOWN / RIGHT   Exit :  X / Q  [', Actual_Page:2,' of ', Max_Page:2,']')
    end
                     else
    if Actual_Page = Max_Page then
      begin
        write('':15);
        TextBackGround(LightGray);
        TextColor(Black);
        write(' Previous page : UP / LEFT    Exit :  X / Q [', Actual_Page:2,' of ', Max_Page:2,']')
      end
                              else
   begin
     {write('':5);}
     TextBackGround(LightGray);
     TextColor(Black);
     write(' Previous page : UP / LEFT   Next page : DOWN / RIGHT  Exit :  X / Q [', Actual_Page:2,' of ', Max_Page:2,']');
   end;
  TextAttr := OldAttr;
end;

procedure ErrorBeep;
begin
  sound(1000);
  delay(500);
  nosound;
end;


procedure ShowPage_1;
begin
  Actual_Page := 1;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write('                           ');
  TextColor(4);
  write('P A S P A G E R   1 . 0');
  writeln;
  write('                          ++++++++++++++++++++++++++');
  writeln;
  write('');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(1);
  write('1. What is PASPager ?');
  writeln;
  write(' ---------------------');
  writeln;
  write(' ');
  TextColor(0);
  writeln;
  write(' PASPager is a tool for creating selfdisplaying textpages with Borland or');
  writeln;
  write(' Turbo Pascal. It takes a scriptfile (*.PPS), containing the text to display');
  writeln;
  write(' and some special control expressions, as input and creates the source for');
  writeln;
  write(' a Borland/Turbo Pascal unit. The user ''USES'' this unit in a program which');
  writeln;
  write(' has to display a lot of text, for instance a selfdisplaying manual, a');
  writeln;
  write(' tutorial ot something similiar. The unit then contains only one callable');
  writeln;
  write(' procedure, the main display procedure. In the main program, this main');
  writeln;
  write(' display procedure is called and then it does its job to display one or more');
  writeln;
  write(' pages of text.');
  writeln;
  write('');
  writeln;
  BottomLine;
end;


procedure ShowPage_2;
begin
  Actual_Page := 2;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  TextColor(1);
  write('2. What are the features of PASPager ?');
  writeln;
  write(' --------------------------------------');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('Everything you can do with it is based on the scriptfile. There you can');
  writeln;
  write(' (and should) set the name of the above mentioned main display procedure,');
  writeln;
  write(' split our text into several separate pages, set the primary fore- and back-');
  writeln;
  write(' ground color for the text on the page, change this colors within the text');
  writeln;
  write(' to highlight some parts of it and print out special ASCII charakters.');
  writeln;
  write('');
  writeln;
  BottomLine;
end;


procedure ShowPage_3;
begin
  Actual_Page := 3;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  TextColor(1);
  write('3. Who do I invoke it ?');
  writeln;
  write(' -----------------------');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('PASPager is a command line utility, in other words, it doesn''t have a cool');
  writeln;
  write(' or funny looking user interface, but this kind of stuff  isn''t necessary.');
  writeln;
  write(' Normally, you would call it this way :');
  writeln;
  write('');
  writeln;
  write('        ');
  TextBackGround(0);
  TextColor(7);
  write('PASPAGER infile.pps outfile.pas');
  TextBackGround(7);
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('Then the program would go ahead and translate the scriptfile into a');
  writeln;
  write(' ready-to-compile Borland/Turbo Pascal unit sourcefile.');
  writeln;
  write(' By default, it will also create a "PASPAGER.LOG" file containing some');
  writeln;
  write(' informations and statistics about the current job and a list of all warnings');
  writeln;
  write(' and errors occured while translating the scriptfile. These warnings and');
  writeln;
  write(' error-messages will also be printed to screen. If an errors occurs, the');
  writeln;
  write(' outputfile is deleted.');
  writeln;
  write('');
  writeln;
  BottomLine;
end;


procedure ShowPage_4;
begin
  Actual_Page := 4;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  TextColor(1);
  write('4. Are there any commandline options ?');
  writeln;
  write(' --------------------------------------');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('Yes, there are some. With this options you can change the behaviour of the');
  writeln;
  write(' program from the defaults to what you prefer. Here is a short list :');
  writeln;
  write('');
  writeln;
  write('   ');
  TextBackGround(0);
  TextColor(7);
  write('Options :    -m    no screenmessages');
  TextBackGround(7);
  TextColor(0);
  writeln;
  write('                ');
  TextBackGround(0);
  TextColor(7);
  write('-l    no message logfile');
  TextBackGround(7);
  TextColor(0);
  writeln;
  write('                ');
  TextBackGround(0);
  TextColor(7);
  write('-a    append to old logfile');
  TextBackGround(7);
  TextColor(0);
  writeln;
  write('                ');
  TextBackGround(0);
  TextColor(7);
  write('-k    keep file on error');
  TextBackGround(7);
  TextColor(0);
  writeln;
  BottomLine;
end;


procedure ShowPage_5;
begin
  Actual_Page := 5;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write('');
  writeln;
  write('  ');
  TextColor(0);
  write('Long explanation of this options :');
  writeln;
  write('');
  writeln;
  write('      -m     supresses all warnings or error-messages on screen, so you');
  writeln;
  write('             have to look up the logfile for information');
  writeln;
  write('      -l     supresses creation of the standard logfile');
  writeln;
  write('             WARNING : You should not use this together with the "-m"');
  writeln;
  write('             option ! In this case, you will not be notified of ANY error');
  writeln;
  write('             or warning condition.');
  writeln;
  write('      -a     appends to old logfile if one exists, useful for tracking the');
  writeln;
  write('             list of translated files.');
  writeln;
  write('      -k     keeps the outputfile even when an error occurs (does not delete');
  writeln;
  write('             it), only added for (my) debugging purposes.');
  writeln;
  BottomLine;
end;


procedure ShowPage_6;
begin
  Actual_Page := 6;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  TextColor(1);
  write('5. What are these "control expressions" ?');
  writeln;
  write(' -----------------------------------------');
  writeln;
  write('');
  writeln;
  write('  ');
  TextColor(0);
  write('The control expressions are the basic elements of an PASPager scriptfile.');
  writeln;
  write('  There are expressions to set the callname (the name of the main display');
  writeln;
  write('  procedure), for page separation, for setting page and text colors and for');
  writeln;
  write('  printing special ASCII charakters. All these expressions start with "');
  write(Chr(92));
  write('{"');
  writeln;
  write('  and are terminated by "}". The following is a reference to these control');
  writeln;
  write('  expressions.');
  writeln;
  write('');
  writeln;
  write('  Expressions                   Meaning');
  writeln;
  write('');
  writeln;
  write('  ');
  write(Chr(92));
  write('{CALLNAME:foo}               Set the callname (the name of the main');
  writeln;
  write('                                display procedure) to "foo". This must be');
  writeln;
  write('                                the first statement in the scriptfile. If');
  writeln;
  write('                                the callname is not set by the user, a');
  writeln;
  write('                                warning will be printed and the callname');
  writeln;
  write('                                will by set to the default, "TextView".');
  writeln;
  write('                                Anything following this command is ignored.');
  writeln;
  BottomLine;
end;


procedure ShowPage_7;
begin
  Actual_Page := 7;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  write(Chr(92));
  write('{PAGE:BEGIN}                  For page separation, marks the begin of a');
  writeln;
  write('                                new page of text. Must be used for all pages,');
  writeln;
  write('                                including the first one (Just like the');
  writeln;
  write('                                "BEGIN" statement in pascal).');
  writeln;
  write('                                Anything following this command is ignored.');
  writeln;
  write('');
  writeln;
  write(' ');
  write(Chr(92));
  write('{PAGE:END}                    For page separation, marks the end of the');
  writeln;
  write('                                current page of text. Must be used with all');
  writeln;
  write('                                pages, including the last one (Just like the');
  writeln;
  write('                                "END" statement in pascal.');
  writeln;
  write('                                Anything following this command is ignored.');
  writeln;
  write('');
  writeln;
  write(' ');
  write(Chr(92));
  write('{PAGEBACK:foo}                Sets the background color of the entire page,');
  writeln;
  write('                                should be the first command on a new page.');
  writeln;
  write('                                The screen is cleared after this command.');
  writeln;
  write('                                If the page background color is not set by');
  writeln;
  write('                                the user, the default (black) will remain.');
  writeln;
  write('                                The colorname "foo" is one of the following :');
  writeln;
  write('                                     BLACK, BLUE, GREEN, CYAN, RED, MAGENTA,');
  writeln;
  write('                                     BROWN, LIGHTGRAY.');
  writeln;
  write('                                Anything following this command is ignored.');
  writeln;
  BottomLine;
end;


procedure ShowPage_8;
begin
  Actual_Page := 8;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  write(Chr(92));
  write('{PAGETEXT:foo}                Sets the text color for the entire page,');
  writeln;
  write('                                should be the second command on a new page.');
  writeln;
  write('                                The screen is cleared after this command.');
  writeln;
  write('                                If the page background color is not set by');
  writeln;
  write('                                the user, the default (white) will remain.');
  writeln;
  write('                                The colorname "foo" is one of the following :');
  writeln;
  write('                                     BLACK, BLUE, GREEN, CYAN, RED, MAGENTA,');
  writeln;
  write('                                     BROWN, LIGHTGRAY, DARKGRAY, LIGHTBLUE,');
  writeln;
  write('                                     LIGHTGREEN, LIGHTCYAN, LIGHTRED,');
  writeln;
  write('                                     LIGHTMAGENTA, YELLOW, WHITE.');
  writeln;
  write('');
  writeln;
  write('                               If you want flashing text, use one of these :');
  writeln;
  write('                                     BLUEFLASH, GREENFLASH, CYANFLASH,');
  writeln;
  write('                                     REDFLASH, MAGENTAFLASH, BROWNFLASH,');
  writeln;
  write('                                     LIGHTGRAYFLASH, DARKGRAYFLASH,');
  writeln;
  write('                                     LIGHTBLUEFLASH, LIGHTGREENFLASH,');
  writeln;
  write('                                     LIGHTCYANFLASH, LIGHTREDFLASH,');
  writeln;
  write('                                     LIGHTMAGENTAFLASH, YELLOWFLASH,');
  writeln;
  write('                                     WHITEFLASH.');
  writeln;
  write('');
  writeln;
  write('                               Anything following this command is ignored.');
  writeln;
  BottomLine;
end;


procedure ShowPage_9;
begin
  Actual_Page := 9;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  write(Chr(92));
  write('{TEXTBACK:foo}               Set the new background for the text on this');
  writeln;
  write('                               page. For color names, look up');
  writeln;
  write('                               "');
  write(Chr(92));
  write('{PAGEBACK:foo}".');
  writeln;
  write('');
  writeln;
  write(' ');
  write(Chr(92));
  write('{TEXTCOL:foo}                Set the new color for the text on this page.');
  writeln;
  write('                               For color names, look up "');
  write(Chr(92));
  write('{PAGETEXT:foo}".');
  writeln;
  write('');
  writeln;
  write(' ');
  write(Chr(92));
  write('{ASCII:foo}                  Print special ASCII charakter. The value');
  writeln;
  write('                               foo is the code number of this charakter');
  writeln;
  write('                               (a number between 0 and 255).');
  writeln;
  write('');
  writeln;
  write(' ');
  write(Chr(92));
  write('{EOF}                        Mark end of inputfile. After finding this');
  writeln;
  write('                               expression, PASPager writes the tail of');
  writeln;
  write('                               the unit source.');
  writeln;
  BottomLine;
end;


procedure ShowPage_10;
begin
  Actual_Page := 10;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' Specials :');
  writeln;
  write('            You can use comments in your scriptfile. A comment line is');
  writeln;
  write('            marked by "//" (like in C++) as the first two charakters at');
  writeln;
  write('            this line. The comment sign must start at position 1 of the');
  writeln;
  write('            line.');
  writeln;
  write('');
  writeln;
  write('            To separate pages in your scriptfile optically, you can use');
  writeln;
  write('            empty lines between the last "');
  write(Chr(92));
  write('{PAGE:END}" and the next');
  writeln;
  write('            "');
  write(Chr(92));
  write('{PAGE:BEGIN} expression.');
  writeln;
  write('');
  writeln;
  write('            You cannot write anything else than comments or empty lines');
  writeln;
  write('            between a "');
  write(Chr(92));
  write('{PAGE:END} and a "');
  write(Chr(92));
  write('{PAGE:BEGIN} expression.');
  writeln;
  write('');
  writeln;
  BottomLine;
end;


procedure ShowPage_11;
begin
  Actual_Page := 11;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write('');
  writeln;
  write(' ');
  TextColor(1);
  write('6. Are there any limits ?');
  writeln;
  write(' -------------------------');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('Hmm, huu . . ., yes, there are some limits you should remember when using');
  writeln;
  write(' this tool. At first, a Borland/Turbo Pascal unit cannot contain more than');
  writeln;
  write(' 64 KB of code. So, if you want to use larger texts, split them over several');
  writeln;
  write(' units. Second, remember the number of textlines on the screen. Normally,');
  writeln;
  write(' you would run 25 lines, giving you 23 for your text on the page. Why');
  writeln;
  write(' not 25 ? Well, the last line is used for a bottomline telling the user how');
  writeln;
  write(' to get to the next/previous page and how to exit this text display. If');
  writeln;
  write(' you have more lines on your page, the first ones would scroll off screen.');
  writeln;
  write(' Please do not use the string "');
  write(Chr(92));
  write('{" in your texts. As mentioned before, this');
  writeln;
  write(' is the marker all command expressions start with. So, if PASPager finds');
  writeln;
  write(' this string in your text it will try to evaluate this "expression",');
  writeln;
  write(' leading to a warning saying I don''t understand this". If you HAVE to use');
  writeln;
  write(' this string, use the "');
  write(Chr(92));
  write('{ASCII:foo}" expression for the backslash to');
  writeln;
  write(' avoid this trouble. The line maximum length of a line in the scriptfile');
  writeln;
  write(' is 255 charakters, because Borland Pascal''s string handling routines are');
  writeln;
  write(' limited to this value and I''m using them a lot.');
  writeln;
  BottomLine;
end;


procedure ShowPage_12;
begin
  Actual_Page := 12;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write(' ');
  writeln;
  write(' ');
  TextColor(1);
  write('7. The legal stuff');
  writeln;
  write(' ------------------');
  writeln;
  write('');
  writeln;
  write(' ');
  TextColor(0);
  write('Yeah, I know, you like this part ;-)');
  writeln;
  write(' Sorry, but I must do this. This program (PASPager) is Copyright (c) 1994');
  writeln;
  write(' by Alexander Schreiber. Please do not edit, hack, patch, decompile or');
  writeln;
  write(' disassemble it nor change the executable binary and the included');
  writeln;
  write(' documentation and samples in any other way. If you ignore this warning');
  writeln;
  write(' and mess with this package, a Balrog would come and take you directly into');
  writeln;
  write(' the deepest and most painful torture room at Barad-Dr in the dark lands');
  writeln;
  write(' of Mordor. There you will have to suffer eternal pain.  ;-)');
  writeln;
  write(' Ok, let''s get serious.');
  writeln;
  write(' This program is released to the public domain, this means, you can use and');
  writeln;
  write(' distribute this program for free. In fact, you are encouraged to spread it');
  writeln;
  write(' around, give it to your friends, upload it to your favourite BBS and so on.');
  writeln;
  write(' You don''t have to pay anything to me. If you get this software from a');
  writeln;
  write(' shareware distributor, a software dealer or from similiar sources where you');
  writeln;
  write(' have to pay money for it, you may only pay a copying fee. This software');
  writeln;
  write(' should not be sold as commercial stuff by anybody. It may not be sold as');
  writeln;
  write(' part of a software package without my written permission.');
  writeln;
  write(' Borland Pascal and Turbo Pascal are trademarks by Borland International.');
  writeln;
  write(' This program was written using Borland Pascal.');
  writeln;
  BottomLine;
end;


procedure ShowPage_13;
begin
  Actual_Page := 13;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(7);
  ClrScr;
  TextColor(0);
  ClrScr;
  write('');
  writeln;
  write(' I can not give you any guarantees that this software will run on any');
  writeln;
  write(' system, under any configuration without any problems, I can not even');
  writeln;
  write(' guarantee that it will run at all, althought it was running fine on my');
  writeln;
  write(' system. If you run the program and your computer breakes, you are left with');
  writeln;
  write(' the pieces. The only warranty I can give you is, that this software will');
  writeln;
  write(' take up some diskspace somewhere.');
  writeln;
  BottomLine;
end;


procedure ShowPage_14;
begin
  Actual_Page := 14;
  TextBackGround(Black);
  TextColor(White);
  ClrScr;
  TextBackGround(0);
  ClrScr;
  TextColor(132);
  ClrScr;
  write('');
  writeln;
  write('');
  writeln;
  write('');
  writeln;
  write('                               I  h o p e ,  y o u');
  writeln;
  write('');
  writeln;
  write('');
  writeln;
  write('                L                I      K       K     EEEEEEEEEE');
  writeln;
  write('                L                I      K     K       E');
  writeln;
  write('                L                I      K   K         E');
  writeln;
  write('                L                I      K K           E');
  writeln;
  write('                L                I      KK            EEEEEEEEEE');
  writeln;
  write('                L                I      K  K          E');
  writeln;
  write('                L                I      K    K        E');
  writeln;
  write('                L                I      K      K      E');
  writeln;
  write('                LLLLLLLLLLLL     I      K        K    EEEEEEEEEE');
  writeln;
  write('');
  writeln;
  write('');
  writeln;
  write('                                      i t !');
  writeln;
  write('');
  writeln;
  write('');
  writeln;
  BottomLine;
end;


procedure SelfDisplayingDocumentation;
var OldText : byte;
    Command : char;
begin
  CursorOff;
  OldText := textattr;
  while keypressed do Command := readkey;
  ShowPage_1;
  Command := ' ';
  while (UpCase(Command) <> 'Q') AND (UpCase(Command) <> 'X') do
   begin
     while not keypressed do delay(1);
     Command := ReadKey;
     if (Ord(Command) = 75) OR (Ord(Command) = 72) then
      begin
        case Actual_Page of
          1 : ErrorBeep;
         2 : ShowPage_1;
         3 : ShowPage_2;
         4 : ShowPage_3;
         5 : ShowPage_4;
         6 : ShowPage_5;
         7 : ShowPage_6;
         8 : ShowPage_7;
         9 : ShowPage_8;
         10 : ShowPage_9;
         11 : ShowPage_10;
         12 : ShowPage_11;
         13 : ShowPage_12;
         14 : ShowPage_13;
        end;
      end;
     if (Ord(Command) = 77) OR (Ord(Command) = 80) then
      begin
        case Actual_Page of
          1 : ShowPage_2;
          2 : ShowPage_3;
          3 : ShowPage_4;
          4 : ShowPage_5;
          5 : ShowPage_6;
          6 : ShowPage_7;
          7 : ShowPage_8;
          8 : ShowPage_9;
          9 : ShowPage_10;
          10 : ShowPage_11;
          11 : ShowPage_12;
          12 : ShowPage_13;
          13 : ShowPage_14;
          14 : ErrorBeep;
        end;
      end;
   end;
  TextAttr := OldText;
  CursorOn;
  RestoreCursor;
end;

BEGIN
  SaveCursorShape(CursorTop, CursorTail);
  Max_Page := 14;
END.
