program GraphTest;
uses
   Graph;
var
   GraphDriver,
   GraphMode,
   ErrorCode: integer;
   ModeCnt: integer;
begin
   GraphDriver := Detect;   { Set flag: do detection }
   InitGraph( GraphDriver, GraphMode, 'C:\DRIVERS' );
   ErrorCode := GraphResult;
   if ErrorCode <> GrOK then begin  { Error? }
      writeln( 'Graphics error: ', GraphErrorMsg( ErrorCode ) );
      writeln( 'Program aborted...' );
      Halt( 1 );
   end;
   Rectangle( 0, 0, GetMaxX, GetMaxY );   { Draw full screen box }
   SetTextJustify( CenterText, CenterText );   { Center text }
   for ModeCnt := 0 to 2 do begin
      SetTextStyle( DefaultFont, HorizDir, ModeCnt );
      OutTextXY( GetMaxX div 2, GetMaxY div 2 + ModeCnt*10,
                 'Borland Graphics Interface (BGI)' );
   end;
   ErrorCode := GraphResult;
   readln;
   CloseGraph;
   writeln( 'Error Code: ', ErrorCode );
end.   { end of program GraphTest }