program UserHeapManagement;
{ Illustarates how the user can steal the heap }
{ management routines used by the Graph unit }

uses
   Graph;

var
   GraphDriver, GraphMode: integer;
   ErrorCode             : integer;  { Used to store GraphResult return code }
   PreGraphExitProc: pointer;

{$F+}   { User routines must be far call model }

procedure MyGetMem( var P: Pointer; Size: word );
{ Allocate memory for graphics device drivers }
   begin
      GetMem( P, Size );
   end; { of proc MyGetMem }

procedure MyFreeMem( var P: pointer; Size: word );
{ Deallocate memory for graphics device drivers }
   begin
      write( 'MyFreeMem was called, <HIT RETURN>:' ); readln;
      if P <> nil then begin   { Don't free Nil pointers! }
         FreeMem( P, Size );
         P := nil;
      end
   end; { of proc MyFreeMem }

procedure MyExitProc;
{ Always gets called when program terminates }
   begin
      ExitProc := PreGraphExitProc;   { Restore original exit proc }
      CloseGraph;                     { Do heap clean up }
   end; { of proc MyExitProc }

{$F-}

begin
   { install clean-up routine }
   PreGraphExitProc := ExitProc;
   ExitProc := @MyExitProc;

   GraphGetMemPtr := @MyGetMem;     { Steal memory allocation }
   GraphFreeMemPtr := @MyFreeMem;   { Stral memory de-allocation }

   GraphDriver := Detect;
   InitGraph( GraphDriver, GraphMode, '' );
   ErrorCode := GraphResult;
   if ErrorCode <> grOK then begin
      writeln( 'Graphics error: ', GraphErrorMsg( ErrorCode ) );
      readln;
      Halt(1);
   end;
   Line( 0, 0, GetMaxX, GetMaxY );
   OutTextXY( 1, 1, 'Press <RETURN>: ' );
   readln;
end.   { of prog UserHeapManagement }