{$R+}
program ErrDemo;
   { A demonstration of error walkback using a user supplied error handler. }
uses Crt;
type
   Str20 = string[20];
const
   ProgDepth = 2; { How deeply nested are your calls ? }
                 { Keep this as small a possible to save space }
var
   TopErr   : integer; { Points to top of ErrStack }
   ErrStack : array[0..ProgDepth] of Str20;
   ErrorPtr : word;

   procedure PushErr( Strin: Str20 );
      { Put the procedure name on the stack. }
      { Call right after the Begin in each procedure or dunction }
      { and don't forget to call PopErr at the End. }
   begin
      TopErr := TopErr+1;
      if ( TopErr > ProgDepth ) then begin
         TopErr := ProgDepth;
         ErrStack[TopErr] := Strin;
      end
   end; { of proc PushErr }

   procedure PopErr;
      { Take the prodecure name off the stack }
      { Don't forget to call right before the }
      { end of each procedure or fucntion in which you call PushErr }
   begin
      TopErr := TopErr - 1;
      if ( TopErr < 0 ) then begin   { there is a problem }
         TopErr := 0;
         ErrStack[0] := 'ErrStack Corrupted' ;
      end
   end; { of proc PopErr }

   procedure ErrHalt( ErrNum, ErrAddr: integer );
      { error handler to demonstarte the walkback }
   var
      I, Row, Col: integer;
   begin
      writeln;
      case Hi(ErrNum) of
         0: writeln( 'User break ' );
         1: writeln( 'I/O Error # ', Lo(ErrNum) );
         2: writeln( 'Run time error # ', Lo(ErrNum) );
      end; { case }
      write( 'Occurred at ADDRESS: ', ErrAddr );
      writeln( ' in ROUTINE: ', ErrStack[TopErr] );
      writeln( 'Press <Return> for Error Walkback: ' );
      readln;
      ClrScr;
      gotoXY( 10, 5 );
      write( '----- WALK BACK -----' );
      Row := 6;
      Col := 3;
      for I := TopErr downto 0 do begin
         gotoXY( Col, Row );
         write( ErrStack[I]:20, ' ', I );
         Row := Row+ 1;
         if ( I = 24 ) then begin
            Row := 6;
            Col := Col + 24 ;
         end;
      end;
      writeln;
      write( 'Execution halted.' );
      Halt;  { or turbo will do it for us }
   end; { of proc ErrHalt }

   procedure UserTwo( Arg: real );
   begin
      PushErr( 'UserTwo' );
      writeln( 'Square root of ', Arg, ' is ', Sqrt( Arg ) );
      { this should procedure an error if Arg is < 0! }
      PopErr;
   end; { of proc UserTwo }

procedure UserOne( Arg: real );
   begin
      PushErr( 'UserOne' );
      UserTwo( Arg );
      PopErr;
   end; { of proc UserOne }

begin
   { Nest two lines initialize ErrStack }
   TopErr := 0;
   ErrStack[0] := 'Main Program' ;
   { Replace turbo's Error Handler }
   ErrorPtr := Ofs(ErrHalt);
   { Do something }
   UserOne(2);   { OK }
   UserOne(-1);  { Error }
end. { of program ErrDemo }