unit FPal;
interface
uses
   Objects;
const
   Top                                             =     63;
   FPOon                                           =     1.00;
   FPGon                                           =     0.24;
   FPNon                                           =     0.00;

   FPCycTop                                        =     FPOon;
   FPCycBot                                        =     FPNon;
type
   RFPRgb=record
      Red                                          ,
      Green                                        ,
      Blue                                         :     Real;
   end;

   PFPPal=^TFPPal;
   TFPPal=object(TObject)
      Spot                                         :     Byte;
      Red                                          ,
      Green                                        ,
      Blue                                         :     Real;
    constructor Init(n:Byte);
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure This(a,b,c:Real);                        virtual;
      procedure That(var a,b,c:Real);                    virtual;
   end;
   PFPPla=^TFPPla;
   TFPPla=object(TFPPal)
      cRed                                         ,
      cGreen                                       ,
      cBlue                                        :     Integer;
    constructor Init(n:Byte);
      procedure Cycle;                                   virtual;
   end;

   AFPPalette=array [0..255] of TFPPal;
   AFPPlaette=array [0..255] of TFPPla;

   PFPPalette=^TFPPalette;
   TFPPalette=object(TObject)
      Pals                                         :     AFPPalette;
    constructor Init;
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure ThisAt(a:Byte; b,c,d:Real);              virtual;
      procedure ThatAt(a:Byte; var b,c,d:Real);          virtual;
   end;
   PFPPlaette=^TFPPlaette;
   TFPPlaette=object(TObject)
      Pals                                         :     AFPPlaette;
    constructor Init;
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure ThisAt(a:Byte; b,c,d:Real);              virtual;
      procedure ThatAt(a:Byte; var b,c,d:Real);          virtual;
      procedure Cycle;                                   virtual;
   end;



implementation
{TObject.TFPPal}
constructor TFPPal.Init(n:Byte);
begin
   inherited Init;
   Spot:=n;
end;
procedure   TFPPal.Copy;
begin
   Port[$3c7]:=Spot;
   Red:=Port[$3c9]/Top;
   Green:=Port[$3c9]/Top;
   Blue:=Port[$3c9]/Top;
end;
procedure   TFPPal.Push;
begin
   Port[$3c8]:=Spot;
   Port[$3c9]:=Round(Red*Top);
   Port[$3c9]:=Round(Green*Top);
   Port[$3c9]:=Round(Blue*Top);
end;
procedure   TFPPal.This(a,b,c:Real);
begin
   Red:=a/100;
   Green:=b/100;
   Blue:=c/100;
   Push;
end;
procedure   TFPPal.That(var a,b,c:Real);
begin
   Copy;
   a:=Red*100;
   b:=Green*100;
   c:=Blue*100;
end;
{TFPPal.TFPPla}
constructor TFPPla.Init(n:Byte);
begin
   inherited Init(n);
   cRed:=-1;
   cGreen:=-1;
   cBlue:=-1;
end;
procedure   TFPPla.Cycle;
begin
   if (cRed=-1) and (Red-0.01<FPCycBot)     then cRed:=-1*cRed;
   if (cREd=1)  and (Red+0.01>FPCycTop)     then cRed:=-1*cRed;
   if (cGreen=-1) and (Green-0.01<FPCycBot) then cGreen:=-1*cGreen;
   if (cGreen=1) and (Green+0.01>FPCycTop)  then cGreen:=-1*cGreen;
   if (cBlue=-1) and (Blue-0.01<FPCycBot)   then cBlue:=-1*cBlue;
   if (cBlue=1) and (Blue+0.01>FPCycTop)    then cBlue:=-1*cBlue;
   This(100*Red+cRed,100*Green+cGreen,100*Blue+cBlue);
end;

{TObject.TFPPalette}
constructor TFPPalette.Init;
var
   a:Byte;
begin
   inherited Init;
   for a:=0 to 255 do
      Pals[a].Init(a);
end;
procedure   TFPPalette.Copy;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Copy;
end;
procedure   TFPPalette.Push;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Push;
end;
procedure   TFPPalette.ThisAt(a:Byte; b,c,d:Real);
begin
   Pals[a].This(b,c,d);
end;
procedure   TFPPalette.ThatAt(a:Byte; var b,c,d:Real);
begin
   Pals[a].That(b,c,d);
end;
{TObject.TFPPlaette}
constructor TFPPlaette.Init;
var
   a:Byte;
begin
   inherited Init;
   for a:=0 to 255 do
      Pals[a].Init(a);
end;
procedure   TFPPlaette.Copy;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Copy;
end;
procedure   TFPPlaette.Push;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Push;
end;
procedure   TFPPlaette.ThisAt(a:Byte; b,c,d:Real);
begin
   Pals[a].This(b,c,d);
end;
procedure   TFPPlaette.ThatAt(a:Byte; var b,c,d:Real);
begin
   Pals[a].That(b,c,d);
end;
procedure   TFPPlaette.Cycle;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Cycle;
end;

end.