unit fsupvga;

interface
var
{  GraphDriver : integer;   The Graphics device driver }
{  GraphMode   : integer;   The Graphics mode value }
  MaxX, MaxY  : word;     { The maximum resolution of the screen }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }

procedure Initializesupvga(graphmode:integer; pathtodriver:string);



implementation
uses
   crt,graph;
var
  OldExitProc : Pointer;  { Saves exit procedure address }
  graphicmode : ^integer;

{$F+}
procedure MyExitProc;
begin
  ExitProc := OldExitProc; { Restore exit procedure address }
{  CloseGraph;}              { Shut down the graphics system }
  restorecrtmode;
end; { MyExitProc }
{$F-}

{$F+}
function DetectVGA256 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
    DetectVGA256 := graphicmode^        { Default video mode = 0 }
  else
    DetectVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}


procedure Initializesupvga(graphmode:integer; pathtodriver:string);
{ Initialize graphics and report any errors that may occur }
var
  graphdriver:integer;
  InGraphicsMode : boolean; { Flags initialization of graphics mode }
{  PathToDriver   : string;   Stores the DOS path to *.BGI & *.CHR }
  AutoDetectPointer : pointer;
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  graphicmode^:=graphmode;
  DirectVideo := False;
  OldExitProc := ExitProc;                { save previous exit proc }
  ExitProc := @MyExitProc;                { insert our exit proc in chain }
{  PathToDriver := '';}
  repeat

    AutoDetectPointer := @DetectVGA256;   { Point to detection routine }
    GraphDriver := InstallUserDriver('SVGA256', AutoDetectPointer);
    GraphDriver := Detect;

    InitGraph(GraphDriver, GraphMode, PathToDriver);
    ErrorCode := GraphResult;             { preserve error return }
    if ErrorCode <> grOK then             { error? }
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      if ErrorCode = grFileNotFound then  { Can't find driver file }
      begin
        Writeln('Enter full path to BGI driver or type <Ctrl-Break> to quit:');
        Readln(PathToDriver);
        Writeln;
      end
      else
        Halt(1);                          { Some other error: terminate }
    end;
  until ErrorCode = grOK;
  Randomize;                { init random number generator }
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
end; { Initialize }




begin
end.
