unit fernrogr;

interface
uses
   fernando;
type
   palrgb=record
      red,
      green,
      blue:byte;
   end;
   fullpalette=array [0..255] of palrgb;

procedure storefullpalette(var pal:fullpalette);
procedure restorefullpalette(pal:fullpalette);

procedure getpalettecol(a:byte; var palcol:palrgb);
procedure getpalettecolor(a:byte; var palcol:crgb);

procedure putpalettecolor(palcol:crgb);

implementation

procedure storefullpalette(var pal:fullpalette);
var
   a:byte;
begin
   for a:=0 to 255 do begin
      port[$3c7]:=a;
      with pal[a] do begin
         red:=port[$3c9];
         green:=port[$3c9];
         blue:=port[$3c9];
      end;
   end;
end;

procedure restorefullpalette(pal:fullpalette);
var
   a:byte;
begin
   for a:=0 to 255 do begin
      port[$3c8]:=a;
      with pal[a] do begin
         port[$3c9]:=red;
         port[$3c9]:=green;
         port[$3c9]:=blue;
      end;
   end;
end;

procedure getpalettecol(a:byte; var palcol:palrgb);
begin
   port[$3c7]:=a;
   with palcol do begin
      red:=port[$3c9];
      green:=port[$3c9];
      blue:=port[$3c9];
   end;
end;

procedure getpalettecolor(a:byte; var palcol:crgb);
begin
   port[$3c7]:=a;
   with palcol do begin
      color:=port[$3c7];
      red:=port[$3c9];
      green:=port[$3c9];
      blue:=port[$3c9];
   end;
end;

procedure putpalettecolor(palcol:crgb);
begin
   with palcol do
      setcolr(color,red,green,blue);
end;
      
begin
end.