Program Life;
uses
     crt,graph;
const
     maxmatrix=50;
     death=[0,1,4,5,6,7,8];
     living=[2,3];
     birth=[3];
type
     matrixarray=array[-1..maxmatrix,-1..maxmatrix] of boolean;


procedure setupgraph;
var
     gd,gm:integer;
begin
     gd:=mcga;
     gm:=mcgahi;
     initgraph(gd,gm,'c:\tp\bgi');
     if graphresult<>grOk then halt;
     settextstyle(smallfont,horizdir,1);
end;


procedure zeroset(var matrix:matrixarray);
var
     a,b:integer;
begin
     for a:=-1 to maxmatrix do
         for b:=-1 to maxmatrix do
              matrix[a,b]:=false;
end;


procedure draw(command:byte;  matrix:matrixarray;  x,y:integer);
const
     clearbord=1;
     clearborder=clearbord+clearbord+1;
var
     txh,txw:integer;

  procedure field(txh,txw:integer);
  var
       a:integer;
  begin
       setcolor(3);
       for a:=0 to maxmatrix do
       begin
            line(a*txw,0,a*txw,(maxmatrix)*txh);
            line(0,a*txh,(maxmatrix)*txh,a*txw);
       end;
  end;

  procedure pieces(txh,txw:integer;  matrix:matrixarray);
  var
       x,y:integer;
  begin
       setcolor(1);
       setfillstyle(solidfill,black);
       for x:=0 to maxmatrix-1 do
            for y:=0 to maxmatrix-1 do
            begin
                 bar(x*txw+1,y*txh+1,(x+1)*txw-1,(y+1)*txh-1);
                 if matrix[x,y] then outtextxy(x*txw+2,y*txh+2,'O');
            end;
  end;

  procedure part(txh,txw:integer;  matrix:matrixarray;  x,y:integer);
  var
       a,b:integer;
  begin
       setcolor(1);
       for a:=x-1 to x+1 do
            for b:=y-1 to y+1 do
            begin
                bar(a*txw+1,b*txh+1,(a+1)*txw-1,(b+1)*txh-1);
                if matrix[a,b] then outtextxy(a*txw+2,b*txh+2,'O');
            end;
  end;

  procedure pointer(txh,txw:integer;  matrix:matrixarray;  x,y:integer);
  begin
       part(txh,txw,matrix,x,y);
       bar(x*txw+1,y*txh+1,(x+1)*txw-1,(y+1)*txh-1);
       setcolor(2);
       outtextxy(x*txw+2,y*txh+2,'X');
  end;


begin
     txh:=textheight('I')+clearborder;
     txw:=textwidth('H')+clearborder;
     case command of
          1: pieces(txh,txw,matrix);
          2: field(txh,txw);
          3: pointer(txh,txw,matrix,x,y);
          4: part(txh,txw,matrix,x,y);
     end;
end;


procedure inputmatrix(var matrix:matrixarray;  var continue:boolean;  var x,y:integer);
var
     a:char;
begin
     repeat
          draw(3,matrix,x,y);
          a:=readkey;
          case a of
               '1': if (y<maxmatrix-1) and (x>0) then begin x:=x-1; y:=y+1; end;
               '2': if y<maxmatrix-1 then y:=y+1;
               '3': if (y<maxmatrix-1) and (x<maxmatrix-1) then begin y:=y+1; x:=x+1; end;
               '4': if x>0 then x:=x-1;
               '6': if x<maxmatrix-1 then x:=x+1;
               '7': if (x>0) and (y>0) then begin x:=x-1; y:=y-1; end;
               '8': if y>0 then y:=y-1;
               '9': if (y>0) and (x<maxmatrix-1) then begin x:=x+1; y:=y-1 end;
               ' ': matrix[x,y]:=not matrix[x,y];
               else begin  end;
          end;
     until (upcase(a)='S') or (ord(a)=27);
     if upcase(a)='S' then continue:=true else continue:=false;
end;


procedure matrixgeneration(var matrix:matrixarray);
var
     x,y:integer;
     duh:matrixarray;

 function lifeanddeath(m:matrixarray;  x,y:integer):boolean;
 var
      a,b,n:integer;
 begin
      n:=0;
      a:=x-1;
      for b:=y-1 to y+1 do
            if m[a,b] then n:=n+1;
      a:=x+1;
      for b:=y-1 to y+1 do
            if m[a,b] then n:=n+1;
      if m[x,y+1] then n:=n+1;
      if m[x,y-1] then n:=n+1;
      case m[x,y] of
           true: lifeanddeath:=(n in living);
           false: lifeanddeath:=(n in birth);
      end;
 end;

begin
     zeroset(duh);
     for x:=0 to maxmatrix-1 do
          for y:=0 to maxmatrix-1 do
               duh[x,y]:=lifeanddeath(matrix,x,y);
               draw(4,duh,x,y);
     matrix:=duh;
end;


procedure lively;
var
     matrix:matrixarray;
     x,y:integer;
     continue:boolean;
begin
     zeroset(matrix);
     x:=0;     y:=0;
     continue:=true;
{     draw(2,matrix,x,y);}
     draw(1,matrix,x,y);
     inputmatrix(matrix,continue,x,y);
     while continue do
     begin
          while not keypressed do
          begin
               matrixgeneration(matrix);
               draw(1,matrix,x,y);
          end;
          inputmatrix(matrix,continue,x,y);
     end;
end;


begin
     setupgraph;
     lively;
     closegraph;
     restorecrtmode;
end.