unit FRgb;
interface
uses
   Objects;
const
   Top                                             =     63;
   FROon                                           =     63;
   FRGon                                           =     15;
   FRNon                                           =     0;

   FRCycTop                                        =     FROon;
   FRCycBot                                        =     FRNon;
type
   RFRRgb=record
      Red                                          ,
      Green                                        ,
      Blue                                         :     Byte;
   end;

   PFRPal=^TFRPal;
   TFRPal=object(TObject)
      Spot                                         ,
      Red                                          ,
      Green                                        ,
      Blue                                         :     Byte;
    constructor Init(n:Byte);
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure This(a,b,c:Byte);                        virtual;
      procedure That(var a,b,c:Byte);                    virtual;
   end;
   PFRPla=^TFRPla;
   TFRPla=object(TFRPal)
      cRed                                         ,
      cGreen                                       ,
      cBlue                                        :     Integer;
    constructor Init(n:Byte);
      procedure Cycle;                                   virtual;
   end;

   AFRPalette=array [0..255] of TFRPal;
   AFRPlaette=array [0..255] of TFRPla;

   PFRPalette=^TFRPalette;
   TFRPalette=object(TObject)
      Pals                                         :     AFRPalette;
    constructor Init;
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure ThisAt(a,b,c,d:Byte);                    virtual;
      procedure ThatAt(var a,b,c,d:Byte);                virtual;
   end;
   PFRPlaette=^TFRPlaette;
   TFRPlaette=object(TObject)
      Pals                                         :     AFRPlaette;
    constructor Init;
      procedure Copy;                                    virtual;
      procedure Push;                                    virtual;
      procedure ThisAt(a,b,c,d:Byte);                    virtual;
      procedure ThatAt(var a,b,c,d:Byte);                virtual;
      procedure Cycle;                                   virtual;
   end;



implementation
{TObject.TFRPal}
constructor TFRPal.Init(n:Byte);
begin
   inherited Init;
   Spot:=n;
end;
procedure   TFRPal.Copy;
begin
   Port[$3c7]:=Spot;
   Red:=Port[$3c9];
   Green:=Port[$3c9];
   Blue:=Port[$3c9];
end;
procedure   TFRPal.Push;
begin
   Port[$3c8]:=Spot;
   Port[$3c9]:=Red;
   Port[$3c9]:=Green;
   Port[$3c9]:=Blue;
end;
procedure   TFRPal.This(a,b,c:Byte);
begin
   Red:=a;
   Green:=b;
   Blue:=c;
   Push;
end;
procedure   TFRPal.That(var a,b,c:Byte);
begin
   Copy;
   a:=Red;
   b:=Green;
   c:=Blue;
end;
{TFRPal.TFRPla}
constructor TFRPla.Init(n:Byte);
begin
   inherited Init(n);
   cRed:=-1;
   cGreen:=-1;
   cBlue:=-1;
end;
procedure   TFRPla.Cycle;
begin
   if (cRed=-1) and (Red-1<FRCycBot)     then cRed:=-1*cRed;
   if (cREd=1)  and (Red+1>FRCycTop)     then cRed:=-1*cRed;
   if (cGreen=-1) and (Green-1<FRCycBot) then cGreen:=-1*cGreen;
   if (cGreen=1) and (Green+1>FRCycTop)  then cGreen:=-1*cGreen;
   if (cBlue=-1) and (Blue-1<FRCycBot)   then cBlue:=-1*cBlue;
   if (cBlue=1) and (Blue+1>FRCycTop)    then cBlue:=-1*cBlue;
   This(Red+1,Green+1,Blue+1);
end;

{TObject.TFRPalette}
constructor TFRPalette.Init;
var
   a:Byte;
begin
   inherited Init;
   for a:=0 to 255 do
      Pals[a].Init(a);
end;
procedure   TFRPalette.Copy;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Copy;
end;
procedure   TFRPalette.Push;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Push;
end;
procedure   TFRPalette.ThisAt(a,b,c,d:Byte);
begin
   Pals[a].This(b,c,d);
end;
procedure   TFRPalette.ThatAt(var a,b,c,d:Byte);
begin
   Pals[a].That(b,c,d);
end;
{TObject.TFRPlaette}
constructor TFRPlaette.Init;
var
   a:Byte;
begin
   inherited Init;
   for a:=0 to 255 do
      Pals[a].Init(a);
end;
procedure   TFRPlaette.Copy;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Copy;
end;
procedure   TFRPlaette.Push;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Push;
end;
procedure   TFRPlaette.ThisAt(a,b,c,d:Byte);
begin
   Pals[a].This(b,c,d);
end;
procedure   TFRPlaette.ThatAt(var a,b,c,d:Byte);
begin
   Pals[a].That(b,c,d);
end;
procedure   TFRPlaette.Cycle;
var
   a:Byte;
begin
   for a:=0 to 255 do
      Pals[a].Cycle;
end;

end.