{****************************************************************************}
{***********************                              ***********************}
{**                           R-G-B Demonstrator                           **}
{****************************                    ****************************}
{**                       Copyrighted February 12, 1993                    **}
{**                       (C) To Authors                                   **}
{**                             Fernando Padilla                           **}
{**                             Stephen Markham                            **}
{******************************                ******************************}
{****************************************************************************}

uses
     roger,crt;
const
     pause=15;
     base=15;
     top=63;
type
     RGB=(R,RRRG,RRG,RRRGG,RG,RRGGG,RGG,RGGG,G,GGGB,GGB,GGGBB,GB,GGBBB,GBB,GBBB,B,BBBR,BBR,BBBRR,BR,BBRRR,BRR,BRRR,W);

procedure updatergb(a,b,c,d:integer);
begin
     textcolor(1);
     gotoxy(1,1);
      write('Color:');
      writeln(a:14);
     gotoxy(1,3);
      write('RED:');
      writeln(b:16);
     gotoxy(1,4);
      write('GREEN:');
      writeln(c:14);
     gotoxy(1,5);
      write('BLUE:');
      writeln(d:15);
end;


Procedure saycolor(a,b,c,d:integer;  updat:boolean);
  function inverse(a,b:integer):integer;
  begin
       inverse:=abs(a-b);
  end;
begin
     PutColor(a,b,c,d);
     PutColor(a+1,inverse(d,top),inverse(c,top),inverse(d,top));
     if updat then UpdateRGB(a,b,c,d);
end;


procedure control(display:boolean);
var
     palette:rogerrgbpalette;
     color:rgb;
     stop:boolean;
  Procedure FadeColor(c:RGB;  display:boolean;  var stop:boolean);
  var
       i:integer;
    Procedure DoColor(c:RGB;  i:integer;  var display,stop:boolean);
    Begin
         if not stop then
         begin
              Case c of
                   R: SayColor(0,i,0,0,display);
                RRRG: SayColor(0,i,i div 3,0,display);
                 RRG: SayColor(0,i,i div 2,0,display);
               RRRGG: SayColor(0,i,(i*2) div 3,0,display);
                  RG: SayColor(0,i,i,0,display);
               RRGGG: SayColor(0,(i*2) div 3,i,0,display);
                 RGG: SayColor(0,i div 2,i,0,display);
                RGGG: SayColor(0,i div 3,i,0,display);
                   G: SayColor(0,0,i,0,display);
                GGGB: SayColor(0,0,i,i div 3,display);
                 GGB: SayColor(0,0,i,i div 2,display);
               GGGBB: SayColor(0,0,i,(i*2) div 3,display);
                  GB: SayColor(0,0,i,i,display);
               GGBBB: SayColor(0,0,(i*2) div 3,i,display);
                 GBB: SayColor(0,0,i div 2,i,display);
                GBBB: SayColor(0,0,i div 3,i,display);
                   B: SayColor(0,0,0,i,display);
                BBBR: SayColor(0,i div 3,0,i,display);
                 BBR: SayColor(0,i div 2,0,i,display);
               BBBRR: SayColor(0,(i*2) div 3,0,i,display);
                  BR: SayColor(0,i,0,i,display);
               BBRRR: SayColor(0,i,0,(i*2) div 3,display);
                 BRR: SayColor(0,i,0,i div 2,display);
                BRRR: SayColor(0,i,0,i div 3,display);
                   W: SayColor(0,i,i,i,display);
              end;
              delay(pause);
              stop:=keypressed;
         end;
    end;
  Begin
       if not stop then
       begin
            For i := base To top Do Docolor(c,i,display,stop);
            For i := top DownTo base Do Docolor(c,i,display,stop);
       end;
  end;
Begin
     store(palette);
     stop:=false;
     Repeat
       for color:=R to W do FadeColor(color,display,stop);
     Until KeyPressed or stop;
     Restore(palette);
End;


begin
     clrscr;
     window(30,11,51,17);
     control(not(pos('false',paramstr(1))>0));
end.