unit p31992u;


interface
type
     linerecordptr=^linerecord;
     fullline=string[81];
     linerecord=record
          image:fullline;
          previous:linerecordptr;
          next:linerecordptr;
     end;
     pointtype = record
          x:word;
          y:word;
     end;

var
     linepointing:linerecordptr;

procedure movetoheadofimage;
procedure movetotailofimage;
procedure gotolinenumber(line:word);
procedure expand(var point:pointtype);
function  testrectangle(point1,point2:pointtype):boolean;
procedure clearrectangle(point1,point2:pointtype);


procedure addline(nline:fullline);
procedure removeline;
procedure addimage(var batchfile:text);
procedure removeimage;





implementation

procedure movetoheadofimage;
begin
     while not(linepointing^.previous=nil) do
          linepointing:=linepointing^.previous;
end;

procedure movetotailofimage;
begin
     while not(linepointing^.next=nil) do
          linepointing:=linepointing^.next;
end;

procedure gotolinenumber(line:word);
 procedure recursive(line:word);
 begin
      if (line=0) or (linepointing^.next=nil) then exit
      else begin
           linepointing:=linepointing^.next;
           recursive(line-1);
      end;
 end;
begin
     movetoheadofimage;
     recursive(line);
end;

procedure expand(var point:pointtype);
begin
     gotolinenumber(point.x);
     while not(linepointing^.image[point.y+1]='0') do
          inc(point.y);
     dec(point.x);
     while not(linepointing^.image[point.y]='0') do
     begin
          inc(point.x);
          if linepointing^.next=nil then exit
          else gotolinenumber(point.x+1);
     end;
end;

function testrectangle(point1,point2:pointtype):boolean;
var
     x,y:word;
     stop:boolean;
begin
     stop:=false;
     x:=point1.x;
     repeat
          gotolinenumber(x);
          y:=point1.y;
          repeat
               stop:=(linepointing^.image[y]='0');
               inc(y);
          until (stop) or (y-1=point2.y);
          inc(x);
     until (stop) or (x-1=point2.x);
     testrectangle:=not stop;
end;

procedure clearrectangle(point1,point2:pointtype);
var
     x,y:word;
begin
     for x:=point1.x to point2.x do
     begin
          gotolinenumber(x);
          for y:=point1.y to point2.y do
               linepointing^.image[y]:='0';
     end;
end;







procedure addline(nline:fullline);
var
     line:linerecordptr;
begin
     new(line);
     with line^ do
     begin
          image:=nline;
          if linepointing=nil then
          begin
               next:=nil;
               previous:=nil;
          end
          else begin
               next:=linepointing^.next;
               previous:=linepointing;
          end;
     end;
     if not(linepointing=nil) then
     begin
          linepointing^.next^.previous:=line;
          linepointing^.next:=line;
     end;
     linepointing:=line;
end;

procedure removeline;
var
     deadmeatline:linerecordptr;
begin
     linepointing^.next^.previous:=linepointing^.previous;
     linepointing^.previous^.next:=linepointing^.next;
     deadmeatline:=linepointing;
     if linepointing^.previous=nil then linepointing:=linepointing^.next
     else linepointing:=linepointing^.previous;
     dispose(deadmeatline);
end;

procedure addimage(var batchfile:text);
var
     temp:string[81];
begin
     linepointing:=nil;
     repeat
          readln(batchfile,temp);
          addline(concat(temp,'0'));
     until eoln(batchfile);
end;

procedure removeimage;
begin
     repeat
          movetotailofimage;
          removeline;
     until (linepointing=nil) or ((linepointing^.previous=nil) and (linepointing^.next=nil));
     linepointing^.image:='';
     linepointing^.previous:=nil;
     linepointing^.next:=nil;
end;







begin
end.