{*****************************************************************************}
{                                                                             }
{                   Bit-image scaler by scaling factor                        }
{                                   by                                        }
{                          Fernando Luis Padilla                              }
{       (c), Copyrighted to above stated author, December 23, 1992            }
{                                                                             }
{*****************************************************************************}

program scalingII;
uses
     crt;
const
      pausechar=chr(2);


procedure firststep(var batchfile:text;  var hatchfile:text);
var
     a:integer;
     scale:integer;
     tempchar:char;
     tempstring:string[80];
begin
     while not eof(batchfile) do begin
          write('+');
          readln(batchfile,scale);
          while not((eoln(batchfile)) or (eof(batchfile))) do begin
               write('=');
               tempstring:='';
               while not((eoln(batchfile)) or (eof(batchfile))) do begin
                    read(batchfile,tempchar);
                    for a:=1 to scale do tempstring:=concat(tempstring,tempchar);
               end;
               readln(batchfile);
               for a:=1 to scale do writeln(hatchfile,tempstring);
          end;
          writeln(hatchfile,pausechar);
     end;
     writeln;
end;

procedure output(var hatchfile:text);
var
     tempstring:string[80];
begin
     repeat
          readln(hatchfile,tempstring);
          case tempstring[1] of
               pausechar:begin
                    writeln;
                    readln;
               end
               else writeln(tempstring);
          end;
     until eof(hatchfile);
end;

procedure control;
var
     batchfile:text;
     hatchfile:text;
begin
     assign(batchfile,'a:p1-data.dat');
     reset(batchfile);
     assign(hatchfile,'a:tempfile.dat');
     rewrite(hatchfile);
     clrscr;
     firststep(batchfile,hatchfile);
     close(batchfile);
     reset(hatchfile);
     output(hatchfile);
     close(hatchfile);
     erase(hatchfile);
end;

begin
     control;
end.