unit graphin3;
interface
uses
     graph,crt;
type
     timing=(hr,min,sec,hndthsec);
const
     gap=1;
     backcolor=0;
     gapcolor=white;

     hrhandcolor=5;
     minhandcolor=4;
     sechandcolor=3;
     hndthsechandcolor=2;

     centerx=319;
     centery=239;

     hrhandsize=80;
     minhandsize=130;
     sechandsize=180;
     hndthsechandsize=230;

     hrhandnumber=24;
     minhandnumber=60;
     sechandnumber=60;
     hndthsechandnumber=100;

procedure setupgraph;
procedure setupgrid;

function incrementsize(hand:timing):real;
procedure puthand(lasthandposition,handposition:word;  hand:timing);

function handcolor(hand:timing):integer;
function handsize(hand:timing):integer;

procedure beep;
function streng(num:word):string;



implementation

function streng(num:word):string;
var
      strenged:string;
begin
     str(num,strenged);
     streng:=strenged;
end;

procedure beep;
begin
     sound(200);
     delay(1);
     nosound;
end;


function handcolor(hand:timing):integer;
begin
     case hand of
          hr: handcolor:=hrhandcolor;
          min: handcolor:=minhandcolor;
          sec: handcolor:=sechandcolor;
          hndthsec: handcolor:=hndthsechandcolor;
     end;
end;

function handsize(hand:timing):integer;
begin
     case hand of
          hr: handsize:=hrhandsize;
          min: handsize:=minhandsize;
          sec: handsize:=sechandsize;
          hndthsec: handsize:=hndthsechandsize;
     end;
end;

function incrementsize(hand:timing):real;
begin
     case hand of
          hr: incrementsize:=360/hrhandnumber;
          min: incrementsize:=360/minhandnumber;
          sec: incrementsize:=360/minhandnumber;
          hndthsec: incrementsize:=360/hndthsechandnumber;
     end;
end;

procedure puthand(lasthandposition,handposition:word;  hand:timing);
var
     angl:integer;
begin
     setcolor(handcolor(hand));
     angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*handposition));
     pieslice(centerx,centery,angl+gap,round(angl-gap+incrementsize(hand)),handsize(hand));

     setcolor(backcolor);
     angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*(lasthandposition)));
     pieslice(centerx,centery,angl+gap,round(angl-gap+incrementsize(hand)),handsize(hand));
end;


procedure setupgraph;
var
     Gd, Gm: Integer;
begin
     Gd:=VGA;
     Gm:=vgaHI;
     InitGraph(Gd,Gm,'c:\tp\bgi');
     if GraphResult<>grOk then halt;
     cleardevice;
end;

function handnumber(hand:timing):integer;
begin
     case hand of
          hr: handnumber:=hrhandnumber;
          min: handnumber:=minhandnumber;
          sec: handnumber:=sechandnumber;
          hndthsec: handnumber:=hndthsechandnumber;
     end;
end;

procedure setupgrid;
var
     hand:timing;
     handposition,angl:integer;
     oldpattern:fillpatterntype;
begin
     getfillpattern(oldpattern);
     setfillpattern(oldpattern,0);
     bar(0,0,getmaxx,getmaxy);
     setcolor(gapcolor);
     for hand:=hr to hndthsec do
     begin
          for handposition:=1 to handnumber(hand) do
          begin
               angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*handposition));
               pieslice(centerx,centery,angl,angl,handsize(hand));
          end;
     end;
end;

begin
end.