unit graphin1;
interface
uses
     graph,crt;
type
     timing=(hr,min,sec,hndthsec);
const
     gap=1;
     backcolor=black;
     gapcolor=black;

     hrhandcolor={5}white;
     minhandcolor={4}white;
     sechandcolor={3}white;
     hndthsechandcolor={2}white;

     centerx:integer=241;
     centerc:integer=240;
     centery=239;

     hrhandsize=59;
     minhandsize=119;
     sechandsize=179;
     hndthsechandsize=239;

     hrhandnumber=24;
     minhandnumber=60;
     sechandnumber=60;
     hndthsechandnumber=100;

procedure setupgraph;
procedure setupgrid;

function incrementsize(hand:timing):real;
procedure puthand(lasthandposition,handposition:word;  hand:timing);

function handcolor(hand:timing):integer;
function handsize(hand:timing):integer;

procedure beep;
function streng(num:word):string;



implementation

function streng(num:word):string;
var
      strenged:string;
begin
     str(num,strenged);
     if length(strenged)<2 then streng:=concat('0',strenged) else streng:=strenged;
end;

procedure beep;
begin
     sound(200);
     delay(1);
     nosound;
end;


function handcolor(hand:timing):integer;
begin
     case hand of
          hr: handcolor:=hrhandcolor;
          min: handcolor:=minhandcolor;
          sec: handcolor:=sechandcolor;
          hndthsec: handcolor:=hndthsechandcolor;
     end;
end;

function handsize(hand:timing):integer;
begin
     case hand of
          hr: handsize:=hrhandsize;
          min: handsize:=minhandsize;
          sec: handsize:=sechandsize;
          hndthsec: handsize:=hndthsechandsize;
     end;
end;

function incrementsize(hand:timing):real;
begin
     case hand of
          hr: incrementsize:=360/hrhandnumber;
          min: incrementsize:=360/minhandnumber;
          sec: incrementsize:=360/minhandnumber;
          hndthsec: incrementsize:=360/hndthsechandnumber;
     end;
end;

procedure puthand(lasthandposition,handposition:word;  hand:timing);
var
     angl:integer;
begin
     setcolor(handcolor(hand));
     angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*handposition));
     arc(centerx,centery,angl+gap,round(angl-gap+incrementsize(hand)),handsize(hand));

     setcolor(backcolor);
     angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*(lasthandposition)));
     arc(centerc,centery,word(angl+gap),word(round(angl-gap+incrementsize(hand))),word(handsize(hand)));
end;


procedure setupgraph;
var
     Gd, Gm: Integer;
begin
     Gd:=VGA;
     Gm:=vgaHI;
     InitGraph(Gd,Gm,'c:\tp\bgi');
     if GraphResult<>grOk then halt;
     cleardevice;
end;

function handnumber(hand:timing):integer;
begin
     case hand of
          hr: handnumber:=hrhandnumber;
          min: handnumber:=minhandnumber;
          sec: handnumber:=sechandnumber;
          hndthsec: handnumber:=hndthsechandnumber;
     end;
end;

procedure setupgrid;
const
     solidtype:fillpatterntype=($AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA);
var
     hand:timing;
     handposition,angl:integer;
{     oldpattern:fillpatterntype;}
begin
{     getfillpattern(oldpattern);}
     setfillstyle(solidfill,backcolor);
     setfillpattern(solidtype,backcolor);
     bar(0,0,getmaxx,getmaxy);
{     setcolor(backcolor);
     for hand:=hr to hndthsec do
     begin
          for handposition:=1 to handnumber(hand) do
          begin
               angl:=round(450-(incrementsize(hand)/2)-(incrementsize(hand)*handposition));
               arc(centerx,centery,angl+gap,round(angl-gap+incrementsize(hand)),handsize(hand));
          end;
     end;}
end;

begin
end.