UNIT PARTOOLS;

{
   (C) M.Fiel 1993 Vienna - Austria
   CompuServe ID : 100041,2007

   Use freely if you find it useful.
}

INTERFACE

  USES
    Objects;

  TYPE

    {Object to hold variable data for the TVarParser defined in Unit Parser}

    PParserVar = ^TParserVar;
    TParserVar = object(TObject)

      Name : PString;
      Value : Real;

      constructor Init(aName:String;aValue:Real);
      destructor  Done; virtual;

      function    GetName : String; virtual;
      function    GetValue : Real; virtual;
      procedure   SetValue(NewValue : Real); virtual;

    end;

    {Container to hold TParserVar objects }

    PParserVarColl = ^TParserVarColl;
    TParserVarColl = object(TCollection)

      procedure FreeItem(Item:Pointer); virtual;
      function  GetVarIndex(Name:String) : Integer; virtual;
      function  GetVar(Name:String) : Real; virtual;
      procedure SetValue(Name:String;NewValue:Real); virtual;

    end;

   PStrColl = ^TStrColl;  { Container for Strings }
   TStrColl = object(TCollection)
     procedure  FreeItem(Item: Pointer); virtual;
   end;

  procedure OwnError(S:String); { Shows a MsgBox with S }
  function Trim(Line:String) : String; { Pads a String from End }
  function MkStr(Len,Val:Byte): String;
  { makes a String of length len and fills it with val }

IMPLEMENTATION

  USES
    MsgBox;

  constructor TParserVar.Init(aName:String;aValue:Real);
    begin
      inherited Init;
      Name:=NewStr(aName);
      Value:=aValue;
    end;

  destructor TParserVar.Done;
    begin
      DisposeStr(Name);
      inherited Done;
    end;

  function TParserVar.GetName : String;
    begin
      if Name<>NIL then GetName:=Name^ else GetName:='';
    end;

  function TParserVar.GetValue : Real;
    begin
      GetValue:=Value;
    end;

  procedure TParserVar.SetValue(NewValue : Real);
    begin
      Value:=NewValue;
    end;

  procedure TParserVarColl.FreeItem(Item:Pointer);
    begin
      if (Item <> NIL) then Dispose(PParserVar(Item),Done);
    end;


  function TParserVarColl.GetVar(Name:String) : Real;
    var
      Index:Integer;
    begin
      Index:=GetVarIndex(Name);

      if (Index<>-1) then
        GetVar:=PParserVar(At(Index))^.GetValue
      else begin
        OwnError('invalid variable');
        GetVar:=0;
      end;

    end;

  function TParserVarColl.GetVarIndex(Name:String) : Integer;

    function isName(P:PParserVar):Boolean;
      begin
        isName:=(P^.GetName = Name);
      end;

    begin
      GetVarIndex:=IndexOf(FirstThat(@isName));
    end;

  procedure TParserVarColl.SetValue(Name:String;NewValue:Real);
    var
      Index : Integer;

    begin

      Index:=GetVarIndex(Name);

      if (Index <> -1) then
        PParserVar(At(Index))^.SetValue(NewValue)
      else
        Insert(New(PParserVar,Init(Name,NewValue)));

    end;

  procedure OwnError(S:String);
    begin
       MessageBox(S,nil,mfError + mfOkButton);
    end;

  function Trim(Line:String) : String;
    var
      Len: BYTE ABSOLUTE Line;
    begin
      while (Len > 0) AND (Line[Len] = ' ') DO Dec(Len);
      Trim := Line;
    end ;

  function MkStr (Len,Val:Byte): String;
    var
      S:String;
    begin
       S[0]:=chr(Len);
       fillchar (S[1],Len,Val);
       MkStr:=s;
    end;

 procedure TStrColl.FreeItem(Item: Pointer);
   begin
     if Item<>Nil then DisposeStr(Item);
   end;

END.