PROGRAM PARDEMO;

{
   (C) M.Fiel 1993 Vienna - Austria
   CompuServe ID : 100041,2007

   Use freely if you find it useful.

   Demonstration of a Recursive descent Parser and a new Screensaver
   object.

   Infos watch the units and the parser.txt file

   if problems or comments leave me a message or mail me.

}



USES
  Objects,Drivers,Menus,Views,App,Dialogs,ScrSaver,TVParser;

CONST
  cmParser = 1001;
  cmScreenSave = 1002;

TYPE

   PApp = ^Tapp;
   TApp = object(TApplication)

      ScreenSaver : PScreenSaver; { defined in unit ScrSav }
      {add the screensaver object to the application}

      constructor Init;

      procedure   HandleEvent (var event:Tevent); virtual;
      procedure   InitMenuBar; virtual;
      procedure   InitStatusLine; virtual;
      procedure   ShowParser;
      procedure   GetEvent(var Event: TEvent); virtual;

   end;

  VAR
    XApplic: TApp;

   constructor TApp.Init;
     begin
       if not inherited Init then FAIL;

       ScreenSaver:=New(PScreenSaver,Init('I''m the Screensaver',180));
       Insert(ScreenSaver);

     end;

  procedure TApp.GetEvent(var Event: TEvent);
    begin
      inherited GetEvent(Event);
      ScreenSaver^.GetEvent(Event);  { don't forget this line }
    end;

   procedure Tapp.InitStatusLine;

     var
       R: TRect;
     begin

       GetExtent(r);
       R.A.Y := R.B.Y - 1;

       StatusLine:=New(PStatusLine, Init(R,

	  NewStatusDef (0, 1000,
	     newstatuskey ('~F10~-Menu',kbF10,cmmenu,
	     newstatuskey ('~Alt-X~ Exit', kbaltx, cmQuit,
	  NIL)),

       NIL)));

     end;

   procedure Tapp.InitMenuBar;

     var
       R : TRect;
     begin

	GetExtent(R);
	R.B.Y := R.A.Y + 1;

	MenuBar:=New(PMenuBar,Init(R,NewMenu(

	   NewSubMenu('~~ ',hcNoContext,NewMenu(
             NewItem('~Alt-X~ Exit','',kbAltX,cmQuit,hcNoContext,
	   NIL)),

           NewItem('~P~arser','',0,cmParser,hcNoContext,
           NewItem('~S~creensave','',0,cmScreenSave,hcNoContext,

        Nil))))));
    end;

  procedure TApp.ShowParser;
    var
      Parser:PVisionParser;
    begin
      Parser:=New(PVisionParser,Init);
      if Parser<>NIL then begin
        DeskTop^.ExecView(Parser);
        Dispose(Parser,Done);
      end;
    end;


  procedure Tapp.HandleEvent (var Event:TEvent);
    begin

      case Event.What of

	evCommand : begin

	  case (Event.Command) of

            cmParser : ShowParser;
            cmScreenSave : begin
              DoneVideo;
              ScreenSaver^.Activ:=True;
            end;
            else inherited HandleEvent (Event);

	  end;

        end;

        else inherited HandleEvent (Event);

      end;

    end;


begin

   XApplic.Init;
   XApplic.Run;
   XApplic.Done;

end.